/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RSKeysElements
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, CandidateKey key) throws Exception {
        ArrayList list = new ArrayList(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_KEY_Elements (Key_ID, Key_OVID, Type, Element_ID, Element_OVID, Element_Name, Sequence, Source_Label, Target_Label, Entity_ID, Key_Name, Entity_OVID, Entity_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = key.getNewElementsCollection().iterator();
        int seq = 0;
        while (it.hasNext()) {
            ++seq;
            DesignObject element = (DesignObject)it.next();
            String elmOVID = RSKeysElements.getOrCreateOVID(map, element.getObjectID());
            stmt.setString(1, key.getObjectID());
            stmt.setString(2, (String)map.get(key.getObjectID()));
            stmt.setString(3, element instanceof Relation ? "R" : "A");
            stmt.setString(4, element.getObjectID());
            stmt.setString(5, elmOVID);
            stmt.setString(6, element.getName());
            stmt.setInt(7, seq);
            stmt.setString(8, element instanceof Relation ? ((Relation)element).getNameOnSource() : null);
            stmt.setString(9, element instanceof Relation ? ((Relation)element).getNameOnTarget() : null);
            stmt.setString(10, key.getContainerObject().getObjectID());
            stmt.setString(11, key.getName());
            stmt.setString(12, (String)map.get(key.getContainerObject().getObjectID()));
            stmt.setString(13, key.getContainerObject().getName());
            stmt.setString(14, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

