/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;

public class RSDocuments
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<BIDocument> list = new ArrayList<BIDocument>(1000);
        int count = 0;
        ArrayList<BIDocument> docCollection = new ArrayList<BIDocument>();
        String query = "INSERT INTO DMRS_DOCUMENTS (Document_ID, Document_OVID, Document_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Parent_ID, Parent_OVID, Parent_Name, Doc_Reference, Doc_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getDocumentSet().iterator();
        while (it.hasNext()) {
            BIDocument doc2 = (BIDocument)it.next();
            String docOVID = RSDocuments.getOrCreateOVID(map, doc2.getObjectID());
            docCollection.add(doc2);
            BIDocument par = doc2.getParentDocument();
            stmt.setString(1, doc2.getObjectID());
            stmt.setString(2, docOVID);
            stmt.setString(3, doc2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            if (par != null) {
                stmt.setString(7, par.getObjectID());
                stmt.setString(8, RSDocuments.getOrCreateOVID(map, par.getObjectID()));
                stmt.setString(9, par.getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            stmt.setString(10, doc2.getReference());
            stmt.setString(11, doc2.getType());
            stmt.setString(12, designOVID);
            stmt.addBatch();
            list.add(doc2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (BIDocument doc2 : list) {
                RSComments.export(map, connection, doc2);
                RSDynamicProperties.export(design, map, connection, doc2);
            }
            list.clear();
        }
        RSDocuments.exportElements(map, connection, docCollection, designOVID);
        if (count > 0) {
            stmt.executeBatch();
            for (BIDocument doc : list) {
                RSComments.export(map, connection, doc);
                RSDynamicProperties.export(design, map, connection, doc);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportElements(Map map, Connection connection, List documents, String designOVID) throws Exception {
        int count1 = 0;
        String elemQuery = "INSERT INTO DMRS_DOCUMENT_ELEMENTS (Document_ID, Document_OVID, Document_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement elemStmt = connection.prepareStatement(elemQuery);
        for (BIDocument doc : documents) {
            for (ModelIDObject elem : doc.getElements()) {
                String elemOVID = RSDocuments.getOrCreateOVID(map, elem.getObjectID());
                elemStmt.setString(1, doc.getObjectID());
                elemStmt.setString(2, (String)map.get(doc.getObjectID()));
                elemStmt.setString(3, doc.getName());
                elemStmt.setString(4, elem.getObjectID());
                elemStmt.setString(5, elemOVID);
                elemStmt.setString(6, elem.getName());
                elemStmt.setString(7, elem.getObjectTypeName());
                elemStmt.setString(8, designOVID);
                elemStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                elemStmt.executeBatch();
            }
        }
        if (count1 > 0) {
            count1 = 0;
            elemStmt.executeBatch();
        }
        elemStmt.close();
        elemStmt = null;
    }
}

