/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.FKProxyUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxyUDBv81) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxyUDBv81 && ((FKProxyUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FKProxyUDBv81 fkproxy;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignUDB)this.getStorageDesign();
            fkproxy = (FKProxyUDBv81)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxyUDBv81)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fkproxy = (FKProxyUDBv81)object;
            this.storageDesign = (StorageDesignUDB)fkproxy.getStorageDesign();
        }
        if (fkproxy.getFKTable() instanceof Table) {
            TableProxyUDB tableProxy = (TableProxyUDB)fkproxy.getStorageDesign().getTableProxySet().getProxy(fkproxy.getTable().getObjectID());
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 0);
            this.appendBeforeAlterScript(buffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            SSBFKUDBv81.appendStringWithSpace(buffer, "ALTER");
            SSBFKUDBv81.appendStringWithSpace(buffer, "TABLE");
            SSBFKUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBFKUDBv81.appendStringWithSpace(buffer, "ADD");
            SSBFKUDBv81.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getName()));
            SSBFKUDBv81.appendString(buffer, "FOREIGN KEY");
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBFKUDBv81.appendStringWithSpace(buffer, '(');
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBFKUDBv81.appendString(buffer, fkproxy.getColumns(this.storageDesign));
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBFKUDBv81.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy, prettyPrint);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendOnUpdate(buffer, fkproxy, prettyPrint);
            this.appendConstraintAttribute(buffer, fkproxy, prettyPrint);
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBFKUDBv81.appendLineFinisher(buffer, prettyPrint);
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(buffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyUDBv81 fk, boolean prettyPrint) {
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv81.appendStringWithSpace(buffer, "REFERENCES");
        TableProxyUDB tableProxy = (TableProxyUDB)fk.getStorageDesign().getTableProxySet().getProxy(fk.getFKTable().getObjectID());
        SSBFKUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv81.appendStringWithSpace(buffer, '(');
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 0);
        SSBFKUDBv81.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv81.appendString(buffer, ')');
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyUDBv81 fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv81.appendStringWithSpace(buffer, "ON");
        SSBFKUDBv81.appendStringWithSpace(buffer, "DELETE");
        SSBFKUDBv81.appendString(buffer, onDelete);
    }

    private void appendOnUpdate(StringBuffer buffer, FKProxyUDBv81 fk, boolean prettyPrint) {
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv81.appendStringWithSpace(buffer, "ON");
        SSBFKUDBv81.appendStringWithSpace(buffer, "UPDATE");
        SSBFKUDBv81.appendString(buffer, fk.getOnUpdate());
    }

    private void appendConstraintAttribute(StringBuffer buffer, FKProxyUDBv81 fk, boolean prettyPrint) {
        SSBFKUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBFKUDBv81.appendStringWithSpace(buffer, fk.getValidation());
        SSBFKUDBv81.appendStringWithSpace(buffer, fk.getQueryOptimization());
        SSBFKUDBv81.appendStringWithSpace(buffer, "QUERY");
        SSBFKUDBv81.appendStringWithSpace(buffer, "OPTIMIZATION");
    }
}

