/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.FKProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.IndexProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && !(object instanceof FKProxyDB2v80) && ((IndexProxy)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxyDB2v80 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
            indexProxy = (IndexProxyDB2v80)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyDB2) {
            indexProxy = (IndexProxyDB2v80)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
        }
        if (index != null && indexProxy != null) {
            if (index.isFK()) {
                this.appendFKDefinition(buffer, index, indexProxy, prettyPrint);
            } else if (indexProxy.isMarkedGenerate()) {
                if (indexProxy.isCommentChanged()) {
                    this.appendComment(buffer, indexProxy);
                } else {
                    this.appendComment(buffer, index);
                }
                this.appendCreate(buffer);
                this.appendUnique(buffer, indexProxy);
                this.appendNotNull(buffer, indexProxy);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "INDEX");
                SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
                this.appendTable(buffer, index, prettyPrint);
                this.appendElementList(buffer, index, indexProxy, true);
                this.appendCluster(buffer, indexProxy, prettyPrint);
                this.appendPartitioned(buffer, indexProxy, prettyPrint);
                this.appendPartitions(buffer, indexProxy, prettyPrint);
                this.appendPadded(buffer, indexProxy, prettyPrint);
                this.appendUsingBlock(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendFreeBlock(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendGbpCacheBlock(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendDefine(buffer, indexProxy.getStorageTemplate(), prettyPrint);
                this.appendBufferPool(buffer, indexProxy, prettyPrint);
                this.appendClose(buffer, indexProxy, prettyPrint);
                this.appendDefer(buffer, indexProxy, prettyPrint);
                this.appendPieceSize(buffer, indexProxy, prettyPrint);
                this.appendCopy(buffer, indexProxy, prettyPrint);
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexDB2v80.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateIndex();
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
                }
            } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
            }
        } else if (index != null) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Index ");
            buffer.append(this.storageDesign.getFormatedName(index.getContainerWithKeyObject().getName()) + "." + this.storageDesign.getFormatedName(index.getName()));
            buffer.append(" has no columns");
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexComment(StringBuffer buffer, Index index, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (indexProxy != null && indexProxy.isCommentInRDBMSChanged()) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexDB2v80.appendStringWithSpace(buffer, "INDEX");
            SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
            SSBIndexDB2v80.appendStringWithSpace(buffer, "IS");
            SSBIndexDB2v80.appendString(buffer, '\'');
            SSBIndexDB2v80.appendString(buffer, indexProxy.getCommentInRDBMS());
            SSBIndexDB2v80.appendStringWithSpace(buffer, '\'');
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v80.appendLineFinisher(buffer, prettyPrint);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexDB2v80.appendStringWithSpace(buffer, "INDEX");
            SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
            SSBIndexDB2v80.appendStringWithSpace(buffer, "IS");
            SSBIndexDB2v80.appendString(buffer, '\'');
            SSBIndexDB2v80.appendString(buffer, index.getCommentInRDBMS());
            SSBIndexDB2v80.appendStringWithSpace(buffer, '\'');
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexDB2v80.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendTable(StringBuffer buffer, Index index, boolean prettyPrint) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tp = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        if (tp != null) {
            SSBIndexDB2v80.appendStringWithSpace(buffer, "ON");
            SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
        }
    }

    protected void appendElementList(StringBuffer buffer, Index index, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (index.hasIndexExpression()) {
            SSBIndexDB2v80.appendStringWithSpace(buffer, '(');
            SSBIndexDB2v80.appendString(buffer, index.getIndexExpression());
            SSBIndexDB2v80.appendStringWithSpace(buffer, ')');
        } else {
            ColumnProxy[] columns = indexProxy.getColumnProxies();
            ColumnProxy column = null;
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendString(buffer, ' ');
                SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column.getName()));
                SSBIndexDB2v80.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
                if (i >= columns.length - 1) continue;
                this.appendComma(buffer);
            }
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendUnique(StringBuffer buffer, IndexProxyDB2v80 index) {
        if (index.isUnique()) {
            SSBIndexDB2v80.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    protected void appendNotNull(StringBuffer buffer, IndexProxyDB2 indexProxy) {
        if (indexProxy.isUniquePlainIndex() && indexProxy.isWhereNotNull()) {
            SSBIndexDB2v80.appendStringWithSpace(buffer, "WHERE NOT NULL");
        }
    }

    protected void appendUsingBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            VCatDB2 vcat = st.getVCat();
            if (vcat != null) {
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "USING");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "VCAT");
                SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(vcat.getName()));
            } else {
                StorageGroupDB2 stogroup = st.getStorageGroup();
                if (stogroup != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                    SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "USING");
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "STOGROUP");
                    SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(stogroup.getLongNameDDL()));
                    SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "PRIQTY");
                    SSBIndexDB2v80.appendStringWithSpace(buffer, st.getSgPriqty());
                    SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "SECQTY");
                    SSBIndexDB2v80.appendStringWithSpace(buffer, st.getSgSeqty());
                    SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "ERASE");
                    SSBIndexDB2v80.appendStringWithSpace(buffer, st.isSgErase() ? BOOLEAN_YES : BOOLEAN_NO);
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "FREEPAGE");
            SSBIndexDB2v80.appendStringWithSpace(buffer, st.getFreePage());
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "PCTFREE");
            SSBIndexDB2v80.appendStringWithSpace(buffer, st.getPctFree());
        }
    }

    protected void appendGbpCacheBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!"".equalsIgnoreCase(st.getGbCache())) {
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "GBPCACHE");
                SSBIndexDB2v80.appendStringWithSpace(buffer, st.getGbCache());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "GBPCACHE");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "CHANGED");
            }
        }
    }

    protected void appendDefine(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (st.isDefine()) {
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "DEFINE");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "YES");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "DEFINE");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "NO");
            }
        }
    }

    protected void appendCluster(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getClusteredDB2().equalsIgnoreCase("NO")) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "CLUSTER");
        }
    }

    protected void appendPartitioned(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getPartitioned().equalsIgnoreCase("NO")) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "PARTITIONED");
        }
    }

    protected void appendPadded(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getPadded().equalsIgnoreCase("NO")) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "PADDED");
        }
    }

    protected void appendPartitions(StringBuffer buffer, IndexProxyDB2 indexProxy, boolean prettyPrint) {
        TableProxyDB2v80 tp = (TableProxyDB2v80)indexProxy.getTableProxy();
        boolean tpHasPart = false;
        if (tp.getPartitions().length > 0) {
            tpHasPart = true;
        }
        IndexPartitionDB2[] partitions = indexProxy.getPartitions();
        if (!tpHasPart && partitions.length > 0) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < partitions.length; ++i) {
                IndexPartitionDB2 partition = partitions[i];
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "PARTITION");
                SSBIndexDB2v80.appendStringWithSpace(buffer, partition.getPartNumber());
                SSBIndexDB2v80.appendStringWithSpace(buffer, "ENDING AT");
                SSBIndexDB2v80.appendStringWithSpace(buffer, '(');
                SSBIndexDB2v80.appendStringWithSpace(buffer, partition.getPartConstants());
                SSBIndexDB2v80.appendStringWithSpace(buffer, ')');
                this.appendUsingBlock(buffer, partition.getStorageTemplate(), prettyPrint);
                this.appendFreeBlock(buffer, partition.getStorageTemplate(), prettyPrint);
                this.appendGbpCacheBlock(buffer, partition.getStorageTemplate(), prettyPrint);
                if (i >= partitions.length - 1) continue;
                this.appendComma(buffer);
            }
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendBufferPool(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        BufferPoolDB2 bufferPool = indexProxy.getBufferPool();
        if (bufferPool != null) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "BUFFERPOOL");
            SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(bufferPool.getLongNameDDL()));
        }
    }

    protected void appendClose(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (!indexProxy.isClose()) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "CLOSE");
            SSBIndexDB2v80.appendStringWithSpace(buffer, "NO");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "CLOSE");
            SSBIndexDB2v80.appendStringWithSpace(buffer, "YES");
        }
    }

    protected void appendDefer(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexDB2v80.appendStringWithSpace(buffer, "DEFER");
        SSBIndexDB2v80.appendStringWithSpace(buffer, indexProxy.isDefer() ? BOOLEAN_YES : BOOLEAN_NO);
    }

    protected void appendCopy(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (indexProxy.isCopy()) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "COPY");
            SSBIndexDB2v80.appendStringWithSpace(buffer, "YES");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "COPY");
            SSBIndexDB2v80.appendStringWithSpace(buffer, "NO");
        }
    }

    protected void appendPieceSize(StringBuffer buffer, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getPieceSize().equalsIgnoreCase(" ")) {
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendStringWithSpace(buffer, "PIECESIZE");
            SSBIndexDB2v80.appendStringWithSpace(buffer, indexProxy.getPieceSize());
        }
    }

    private void appendFKDefinition(StringBuffer buffer, Index index, IndexProxyDB2v80 indexProxy, boolean prettyPrint) {
        TableProxyDB2 tableProxy = (TableProxyDB2)indexProxy.getTableProxy();
        FKIndexAssociation fkassociation = index.getFKAssociation();
        KeyObject foreignKey = fkassociation.getLocalFKIndex();
        if (foreignKey != null) {
            Column[] columns = (Column[])foreignKey.getElements();
            ColumnProxy columnProxy = null;
            if (columns != null && columns.length > 0) {
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "ALTER");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "TABLE");
                if (tableProxy != null) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                }
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "ADD");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkassociation.getName()));
                SSBIndexDB2v80.appendStringWithSpace(buffer, "FOREIGN KEY");
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendStringWithSpace(buffer, '(');
                if (tableProxy != null) {
                    for (int i = 0; i < columns.length; ++i) {
                        columnProxy = tableProxy.getColumnProxy(columns[i].getObjectID());
                        SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                        SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                        if (i >= columns.length - 1) continue;
                        this.appendComma(buffer);
                    }
                }
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendStringWithSpace(buffer, ')');
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendStringWithSpace(buffer, "REFERENCES");
                TableProxy tp = (TableProxy)indexProxy.getStorageDesign().getTableProxySet().getProxy(fkassociation.getOriginalContainer().getObjectID());
                if (tp != null) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
                }
                String deleteRule = fkassociation.getDeleteRule();
                String[] choises = fkassociation.getDeleteRuleChoices();
                SSBIndexDB2v80.appendStringWithSpace(buffer, "ON");
                SSBIndexDB2v80.appendStringWithSpace(buffer, "DELETE");
                if (deleteRule.equalsIgnoreCase(choises[0])) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "NO ACTION");
                } else if (deleteRule.equalsIgnoreCase(choises[1])) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "CASCADE");
                } else if (deleteRule.equalsIgnoreCase(choises[2])) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "SET NULL");
                } else if (deleteRule.equalsIgnoreCase(choises[3])) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "RESTRICT");
                }
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexDB2v80.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index object, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        IndexProxy indexProxy = null;
        index = object;
        StorageDesignDB2v80 storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
        if (index.isFK()) {
            indexProxy = (IndexProxy)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (index != null && !index.isOidKey() && (indexProxy != null && indexProxy.isMarkedGenerate() || indexProxy == null && index.isMarkedGenerate())) {
            this.storageDesign = (AbstractStorageDesignDB2)tableProxy.getStorageDesign();
            if (index.getElements().length > 0) {
                if (indexProxy != null && indexProxy.isCommentChanged()) {
                    this.appendComment(oldbuffer, indexProxy);
                } else {
                    this.appendComment(oldbuffer, index);
                }
                String indName = index.getName();
                String lname = indName = ApplyNamingStandards.createIndexNameAuto(tableProxy.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                if (indName.length() > 128) {
                    SSBIndexDB2v80.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBIndexDB2v80.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(128)");
                    SSBIndexDB2v80.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
                SSBIndexDB2v80.appendStringWithSpace(buffer, "CREATE");
                if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                    SSBIndexDB2v80.appendStringWithSpace(buffer, "UNIQUE");
                }
                SSBIndexDB2v80.appendStringWithSpace(buffer, "INDEX");
                SSBIndexDB2v80.appendStringWithSpace(buffer, storageDesign.getFormatedName(lname));
                advancedComment = buffer.toString();
                this.appendTable(buffer, index, true);
                this.appendConstraintElementList(buffer, index, tableProxy, true);
                SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
                SSBIndexDB2v80.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                DDLFileMaker.incrementCreateIndex();
            } else {
                SSBIndexDB2v80.appendNewLine(oldbuffer, prettyPrint, 0);
                oldbuffer.append("-- Error - Index ");
                oldbuffer.append(storageDesign.getFormatedName(index.getName()));
                oldbuffer.append(" has no columns");
                SSBIndexDB2v80.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ArrayList<ColumnProxy> list = new ArrayList<ColumnProxy>();
        for (Column col : index.getElementsCollectionImmutable()) {
            ColumnProxy cp = tableProxy.getColumnProxy(col.getObjectID());
            if (cp == null) continue;
            list.add(cp);
        }
        Object[] columns = list.toArray();
        SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexDB2v80.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexDB2v80.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexDB2v80.appendStringWithSpace(buffer, ',');
            }
            column = (ColumnProxy)columns[i];
            SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexDB2v80.appendString(buffer, ' ');
            String columnName = this.storageDesign.getFormatedName(column.getName());
            SSBIndexDB2v80.appendStringWithSpace(buffer, columnName);
            SSBIndexDB2v80.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexDB2v80.appendStringWithSpace(buffer, ')');
    }
}

