/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAUXTableIndexDB2v80
extends SQLStatementBuilder {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AUXTableIndexDB2 && ((AUXTableIndexDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        AUXTableIndexDB2 index = (AUXTableIndexDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(buffer, index);
        this.appendCreate(buffer);
        this.appendUnique(buffer, index);
        SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "INDEX");
        SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
        this.appendTable(buffer, index, prettyPrint);
        this.appendUsingBlock(buffer, index.getStorageTemplate(), prettyPrint);
        this.appendFreeBlock(buffer, index.getStorageTemplate(), prettyPrint);
        this.appendGbpCacheBlock(buffer, index.getStorageTemplate(), prettyPrint);
        this.appendBufferPool(buffer, index, prettyPrint);
        this.appendClose(buffer, index, prettyPrint);
        this.appendCopy(buffer, index, prettyPrint);
        this.appendPieceSize(buffer, index, prettyPrint);
        SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBAUXTableIndexDB2v80.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateIndex();
    }

    protected void appendUnique(StringBuffer buffer, AUXTableIndexDB2 index) {
        if (index.isUnique()) {
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "UNIQUE");
        }
    }

    protected void appendTable(StringBuffer buffer, AUXTableIndexDB2 index, boolean prettyPrint) {
        AUXTableDB2 table = index.getAuxTable();
        if (table != null) {
            SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "ON");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getLongNameDDL()));
        }
    }

    protected void appendUsingBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            VCatDB2 vcat = st.getVCat();
            if (vcat != null) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "USING");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "VCAT");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(vcat.getName()));
            } else {
                StorageGroupDB2 stogroup = st.getStorageGroup();
                if (stogroup != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                    SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "USING");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "STOGROUP");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(stogroup.getLongNameDDL()));
                    SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "PRIQTY");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, st.getSgPriqty());
                    SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "SECQTY");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, st.getSgSeqty());
                    SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "ERASE");
                    SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, st.isSgErase() ? BOOLEAN_YES : BOOLEAN_NO);
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (st.getFreePage() > 0) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "FREEPAGE");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, st.getFreePage());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "FREEPAGE");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "0");
            }
            if (st.getPctFree() > 0) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "PCTFREE");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, st.getPctFree());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "PCTFREE");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "10");
            }
        }
    }

    protected void appendGbpCacheBlock(StringBuffer buffer, StorageTemplateDB2 st, boolean prettyPrint) {
        if (st != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!"".equalsIgnoreCase(st.getGbCache())) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "GBPCACHE");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, st.getGbCache());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 2);
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "GBPCACHE");
                SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "CHANGED");
            }
        }
    }

    protected void appendBufferPool(StringBuffer buffer, AUXTableIndexDB2 index, boolean prettyPrint) {
        BufferPoolDB2 bufferPool = index.getBufferPool();
        if (bufferPool != null) {
            SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "BUFFERPOOL");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(bufferPool.getLongNameDDL()));
        }
    }

    protected void appendClose(StringBuffer buffer, AUXTableIndexDB2 index, boolean prettyPrint) {
        SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "CLOSE");
        SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, index.isClose() ? BOOLEAN_YES : BOOLEAN_NO);
    }

    protected void appendCopy(StringBuffer buffer, AUXTableIndexDB2 index, boolean prettyPrint) {
        SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
        SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "COPY");
        SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, index.isCopy() ? BOOLEAN_YES : BOOLEAN_NO);
    }

    protected void appendPieceSize(StringBuffer buffer, AUXTableIndexDB2 index, boolean prettyPrint) {
        if (!index.getPieceSize().equalsIgnoreCase("0")) {
            SSBAUXTableIndexDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, "PIECESIZE");
            SSBAUXTableIndexDB2v80.appendStringWithSpace(buffer, index.getPieceSize());
        }
    }
}

