/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.syntaxbuilder.spec.Filter;
import oracle.hcs.syntaxbuilder.spec.FilterIterator;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.MeasureSelector;
import oracle.hcs.templates.templateview.MeasureTreeNode;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.util.HCSFetchIcon;
import oracle.hcs.util.HyperLabel;
import oracle.hcs.util.HyperLabelActionListener;
import oracle.hcs.util.Resources;

public class TemplateHyperParamMeasure
extends TemplateHyperParam {
    private static final int LENGTH = 30;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamMeasure.class.getName());
    private static final String DEFAULT_NAME = "measure";
    private final String PROPERTY_ID = "id";
    private static final String BASE = "BASE";
    private static final String DERIVED = "DERIVED";
    private static final ParseNode pattern = new ParseNode("measure", HCSSyntaxType.MEASURE.toString(), ParseNode.PatternType.SKIP_CHILDREN);
    protected final HyperLabel button;
    private final JLabel label;
    private final JPanel gui = new JPanel(new FlowLayout(0, 0, 0));
    private String measure;
    private List<QDRData> qdr;
    protected AnalyticView analyticView;
    protected MeasureSelector selector;
    protected MeasureTreeNode root;
    private boolean abreviate;
    private Hierarchy selectedHierarchy;
    private AVHierarchy selectedAVHier;
    private NamedObject lastDimSelection;

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof Hierarchy) {
            this.selectedHierarchy = (Hierarchy)propertyChangeEvent.getNewValue();
            this.selectedAVHier = null;
        } else if (propertyChangeEvent.getNewValue() instanceof AttributeDimension) {
            AttributeDimension attributeDimension = (AttributeDimension)propertyChangeEvent.getNewValue();
            this.refreshQDRForCalcMeasure(attributeDimension);
            if (this.analyticView != null) {
                HCSSchema hCSSchema = (HCSSchema)this.analyticView.getSchema();
                AVDimensionality aVDimensionality = this.analyticView.findDimensionality(attributeDimension.getName());
                String string = aVDimensionality.getDefaultHierarchyName();
                Hierarchy hierarchy = hCSSchema.findHierarchy(string);
                if (this.selectedHierarchy != null) {
                    this.setSelectedHierarchy(hierarchy, this.selectedHierarchy, hierarchy);
                }
            }
        } else if (propertyChangeEvent.getNewValue() instanceof AVHierarchy) {
            this.selectedAVHier = (AVHierarchy)propertyChangeEvent.getNewValue();
            this.selectedHierarchy = null;
        } else if (propertyChangeEvent.getNewValue() instanceof AVDimensionality) {
            AVDimensionality aVDimensionality = (AVDimensionality)propertyChangeEvent.getNewValue();
            this.refreshQDRForCalcMeasure(aVDimensionality);
            if (this.analyticView != null) {
                AVDimensionality aVDimensionality2 = this.analyticView.findDimensionalityForAlias(aVDimensionality.getDimensionAlias());
                AVHierarchy aVHierarchy = aVDimensionality2.getDefaultHierarchy();
                if (this.selectedAVHier != null) {
                    this.setSelectedHierarchy(aVHierarchy.getHierarchy(), this.selectedAVHier.getHierarchy(), aVHierarchy);
                }
            }
        }
    }

    private void refreshQDRForCalcMeasure(NamedObject namedObject) {
        if (!(this.getTemplateHyperContext().isTimeTemplate() || this.lastDimSelection != null && this.lastDimSelection.getName().equals(namedObject.getName()))) {
            this.lastDimSelection = namedObject;
            this.refreshQDR();
        }
    }

    private void setSelectedHierarchy(Hierarchy hierarchy, Hierarchy hierarchy2, NamedObject namedObject) {
        if (hierarchy != null && !hierarchy.getDimension().equals(hierarchy2.getDimension())) {
            if (this.selectedAVHier == null) {
                this.selectedHierarchy = (Hierarchy)namedObject;
            } else if (this.selectedHierarchy == null) {
                this.selectedAVHier = (AVHierarchy)namedObject;
            }
        }
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void setDefaultValue() {
        if (this.root == null) {
            return;
        }
        MeasureTreeNode measureTreeNode = null;
        int[] nArray = new int[]{0};
        int n = this.analyticView.getMeasuresList().size();
        String string = null;
        try {
            string = this.getDefault();
            if (string != null) {
                nArray[0] = Math.max(0, Integer.parseInt(string) - 1);
            }
        }
        catch (Exception exception) {
            nArray[0] = 0;
        }
        HCSSchema hCSSchema = (HCSSchema)this.analyticView.getSchema();
        AnalyticView analyticView = hCSSchema.findAV(this.analyticView.getName());
        if (string == null) {
            String string2 = analyticView.getDefaultMeasure();
            AVBaseMeasure aVBaseMeasure = analyticView.findBaseMeasure(string2);
            if (aVBaseMeasure != null) {
                measureTreeNode = this.root.find(aVBaseMeasure.getFullID());
            }
        } else {
            measureTreeNode = this.iterateAVs(BASE, nArray);
            if (nArray[0] >= 0) {
                measureTreeNode = this.iterateAVs(DERIVED, nArray);
            }
            if (measureTreeNode == null) {
                nArray[0] = n - 1;
                measureTreeNode = this.iterateAVs(BASE, nArray);
            }
        }
        if (measureTreeNode != null) {
            this.setQDR(null, false);
            this.setValue(measureTreeNode);
        }
    }

    private MeasureTreeNode iterateAVs(String string, int[] nArray) {
        FilterIterator<AVMeasure> filterIterator = new FilterIterator<AVMeasure>(this.analyticView.getMeasuresList(), new MeasureFilter(string));
        MeasureTreeNode measureTreeNode = this.iterateMeasures(filterIterator, nArray);
        MeasureTreeNode measureTreeNode2 = null;
        if (nArray[0] >= 0) {
            HCSSchema hCSSchema = (HCSSchema)this.analyticView.getSchema();
            for (AnalyticView analyticView : hCSSchema.getAnalyticViews()) {
                if (analyticView == this.analyticView) continue;
                filterIterator = new FilterIterator<AVMeasure>(analyticView.getMeasuresList(), new MeasureFilter(BASE));
                measureTreeNode2 = this.iterateMeasures(filterIterator, nArray);
                if (measureTreeNode2 != null) {
                    measureTreeNode = measureTreeNode2;
                }
                if (nArray[0] >= 0) continue;
                break;
            }
        }
        return measureTreeNode;
    }

    private MeasureTreeNode iterateMeasures(FilterIterator<AVMeasure> filterIterator, int[] nArray) {
        MeasureTreeNode measureTreeNode = null;
        MeasureTreeNode measureTreeNode2 = null;
        for (AVMeasure aVMeasure : filterIterator) {
            measureTreeNode = this.root.find(aVMeasure.getFullID());
            if (measureTreeNode == null) continue;
            measureTreeNode2 = measureTreeNode;
            int n = nArray[0];
            nArray[0] = n - 1;
            if (n > 0) continue;
            break;
        }
        return measureTreeNode2;
    }

    public TemplateHyperParamMeasure() {
        this.gui.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.button = this.createButton();
        this.label = new JLabel(HCSArb.getString("CALC_EDITOR_NESTED_EXPRESION_LABEL"));
        this.label.setVisible(false);
        this.setName(DEFAULT_NAME);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.label);
        jPanel.add(this.button);
        this.gui.add(this.button);
        this.gui.add(this.label);
    }

    private HyperLabel createButton() {
        HyperLabel hyperLabel = new HyperLabel("");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                if (TemplateHyperParamMeasure.this.measure != null) {
                    TemplateHyperParamMeasure.this.selector.setNode(TemplateHyperParamMeasure.this.measure);
                }
                if (TemplateHyperParamMeasure.this.selector.showPickerDialog()) {
                    TemplateHyperParamMeasure.this.setValue(TemplateHyperParamMeasure.this.selector.getValue());
                }
            }
        });
        return hyperLabel;
    }

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public Object getValue() {
        return this.measure;
    }

    @Override
    public boolean setValue(Object object) {
        MeasureTreeNode measureTreeNode = null;
        List<QDRData> list = null;
        String string = null;
        String string2 = null;
        if (this.analyticView != null) {
            string2 = this.analyticView.getSchema().getName();
        }
        if (object == null) {
            this.setDefaultValue();
            return true;
        }
        if (object instanceof ParseNode) {
            ParseNode parseNode = (ParseNode)object;
            string = HCSSyntaxType.valueFrom(parseNode.getType()) == HCSSyntaxType.QDR ? ((ParseNode)parseNode.getChildAt(0)).getFullValue() : parseNode.getFullValue();
            String string3 = this.stripSchema(this.getObjectInternalName(string), string2);
            string3 = String.format("%s.%s", this.analyticView.getName(), string3);
            measureTreeNode = this.selector.setNode(string3);
            list = this.buildQDR();
            QDRData qDRData = null;
            block0: for (ParseNode parseNode2 : parseNode.getChildren()) {
                int n;
                String string4;
                if (parseNode2.getType().equals(HCSSyntaxType.DIMENSION.toString())) {
                    string4 = this.stripSchema(parseNode2.getValue(), string2);
                    n = 0;
                    if (string4.charAt(0) == '\"' && string4.charAt(string4.length() - 1) == '\"') {
                        ++n;
                    }
                    for (QDRData qDRData2 : list) {
                        if (!string4.regionMatches(true, n, qDRData2.getDimension(), 0, qDRData2.getDimension().length())) continue;
                        qDRData = qDRData2;
                        continue block0;
                    }
                    continue;
                }
                if (qDRData == null) continue;
                string4 = parseNode2.getFullValue();
                if (parseNode2.getType().equals(HCSSyntaxType.STRING.toString())) {
                    qDRData.setQuoteMemberExpression(true);
                    n = 0;
                    int n2 = string4.length();
                    if (string4.indexOf(39) == 0) {
                        n = 1;
                    }
                    if (string4.lastIndexOf(39) == string4.length() - 1) {
                        n2 = string4.length() - 1;
                    }
                    if (n != 0 || n2 != string4.length()) {
                        string4 = string4.substring(n, n2);
                    }
                } else {
                    string4 = parseNode2.getFullValue();
                    qDRData.setQuoteMemberExpression(false);
                }
                qDRData.setMemberKey(string4);
                qDRData.setMemberDescription(null);
                qDRData = null;
            }
        } else if (object != null && this.selector != null) {
            string = object.toString();
            measureTreeNode = this.selector.setNode(this.stripSchema(object.toString(), string2));
        }
        if (measureTreeNode != null) {
            this.setQDR(list, false);
            this.button.setVisible(true);
            this.label.setVisible(false);
            this.setValue(measureTreeNode);
            this.abreviate = false;
        } else if (string != null) {
            this.setQDR(list, false);
            this.button.setVisible(false);
            this.label.setVisible(true);
            this.setValue(string, "");
            this.abreviate = true;
        } else {
            this.setQDR(list, true);
        }
        return true;
    }

    void setValue(String string, String string2) {
        if (this.measure != null && this.measure.equals(string)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", this.measure, string);
        boolean bl = this.isValid();
        this.measure = string;
        this.button.setToolTipText(string);
        this.label.setToolTipText(string);
        if (string2.length() > 30) {
            string2 = String.format("%s...", string2.substring(0, 27));
        }
        this.button.setText(string2);
        this.firePropertyChangeEvent(propertyChangeEvent);
        boolean bl2 = this.isValid();
        if (bl2 != bl) {
            propertyChangeEvent = new PropertyChangeEvent(this, "VALID_PROPERTY", bl, bl2);
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    void setValue(MeasureTreeNode measureTreeNode) {
        this.setValue(measureTreeNode.getID(), measureTreeNode.toString());
    }

    @Override
    public String getExpression(String string) {
        if (this.measure != null) {
            IdentifierElement identifierElement = new IdentifierElement(this.measure);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (identifierElement.getCount() == 2) {
                string4 = identifierElement.get(0);
                string2 = identifierElement.get(1);
                string5 = this.getObjectExternalName(string4);
                string3 = this.getObjectExternalName(string2);
            }
            string6 = string3;
            if ("id".equals(string)) {
                return string6;
            }
            Object object = this.generateQDRText(false);
            if (object != null) {
                return String.format("QUALIFY(%s,%s)", string6, object);
            }
            if (identifierElement.getCount() == 2) {
                object = this.analyticView.findMeasure(string2);
                if (object != null) {
                    return this.getObjectExternalName(string2);
                }
                AVCalculatedMeasure aVCalculatedMeasure = this.analyticView.findCalculatedMeasure(string2);
                if (aVCalculatedMeasure != null) {
                    return this.getObjectExternalName(string2);
                }
            }
            return this.measure;
        }
        List<AVMeasure> list = this.analyticView.getMeasuresList();
        AVBaseMeasure aVBaseMeasure = list.get(list.size() - 1);
        this.measure = aVBaseMeasure.getName();
        return this.getObjectExternalName(this.measure);
    }

    @Override
    public String getExpression() {
        return this.getExpression(null);
    }

    void setAV(AnalyticView analyticView) {
        this.analyticView = analyticView;
        Resources resources = this.getTemplateHyperContext().getResources();
        HCSSchema hCSSchema = (HCSSchema)analyticView.getSchema();
        this.root = new MeasureTreeNode(analyticView, hCSSchema.getAnalyticViews(), resources, new HCSFetchIcon());
        this.selector = new MeasureSelector(this.root, resources, this.button);
    }

    public boolean setQDR(List<QDRData> list, boolean bl) {
        if (this.qdr == null) {
            return false;
        }
        boolean bl2 = false;
        if (list == null) {
            for (QDRData qDRData : this.qdr) {
                if (qDRData.getMemberKey() == null) continue;
                bl2 = true;
                qDRData.setMemberDescription(null);
                qDRData.setMemberKey(null);
            }
        } else {
            Connection connection = this.getTemplateHyperContext().getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            for (QDRData qDRData : this.qdr) {
                AVHierarchy aVHierarchy = qDRData.getAVHierarchy();
                String string = aVHierarchy.getHierarchyAlias();
                boolean bl3 = true;
                for (QDRData qDRData2 : list) {
                    AVHierarchy aVHierarchy2 = qDRData2.getAVHierarchy();
                    String string2 = aVHierarchy2.getHierarchyAlias();
                    if (!qDRData.getDimension().equals(qDRData2.getDimension()) || !string.equals(string2)) continue;
                    bl3 = false;
                    if (qDRData.equals(qDRData2)) continue;
                    bl2 = true;
                    qDRData.setData(qDRData2);
                    if (qDRData.getMemberKey() == null || qDRData.getMemberDescription() != null) break;
                    this.getMemberFromDB(qDRData, connection, dBUtil);
                    break;
                }
                if (!bl3 || qDRData.getMemberKey() == null) continue;
                bl2 = true;
                qDRData.setMemberDescription(null);
                qDRData.setMemberKey(null);
            }
        }
        return bl2;
    }

    private void refreshQDR() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", null, this.qdr);
        LOG.finest("Firing change" + propertyChangeEvent);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    private void getMemberFromDB(QDRData qDRData, Connection connection, DBUtil dBUtil) {
        HCSSchema hCSSchema = (HCSSchema)this.analyticView.getSchema();
        AttributeDimension attributeDimension = hCSSchema.findDimension(qDRData.getDimension());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", qDRData.getMemberKey());
        String string = "SELECT %1$s KEY, %2$s VALUE FROM %3$s WHERE %1$s = :key";
    }

    public AnalyticView getAV() {
        return this.analyticView;
    }

    protected HyperLabel getQDRComponent() {
        HyperLabel hyperLabel = new HyperLabel("(...)");
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                String string2 = null;
                if (TemplateHyperParamMeasure.this.selectedHierarchy != null) {
                    string2 = TemplateHyperParamMeasure.this.selectedHierarchy.getName();
                }
                if (TemplateHyperParamMeasure.this.selectedAVHier != null) {
                    string2 = TemplateHyperParamMeasure.this.selectedAVHier.getName();
                }
                ArrayList<QDRData> arrayList = TemplateHyperParamMeasure.this.qdr;
                if (TemplateHyperParamMeasure.this.lastDimSelection != null) {
                    ArrayList<QDRData> arrayList2 = new ArrayList<QDRData>();
                    for (QDRData qDRData : arrayList) {
                        if (TemplateHyperParamMeasure.this.lastDimSelection.getName().equals(qDRData.getDimension())) continue;
                        arrayList2.add(qDRData);
                    }
                    arrayList = arrayList2;
                }
                if ((arrayList = TemplateHyperParamMeasure.this.getTemplateHyperContext().showQDRSelector((List<QDRData>)arrayList, TemplateHyperParamMeasure.this.getAV().getSchema().getName(), string2)) != null) {
                    TemplateHyperParamMeasure.this.setQDR(arrayList, true);
                }
            }
        });
        return hyperLabel;
    }

    private String generateQDRText(boolean bl) {
        if (this.qdr == null) {
            return null;
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("");
        for (QDRData qDRData : this.qdr) {
            if (this.lastDimSelection != null && qDRData.getAVHierarchy().getHierarchyAlias().equals(this.lastDimSelection.getName())) {
                qDRData.setMemberDescription(null);
                qDRData.setMemberKey(null);
                continue;
            }
            if (!qDRData.isMemberSet()) continue;
            bl2 = true;
            if (bl) {
                stringBuilder.append(qDRData.toString());
            } else {
                stringBuilder.append(qDRData.getExpression());
            }
            stringBuilder.append(",");
        }
        if (bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return null;
    }

    private void setQDRText(JComponent jComponent, String string) {
        if (jComponent == null) {
            return;
        }
        if (string == null) {
            ((HyperLabel)jComponent).setText("(...)");
        } else {
            ((HyperLabel)jComponent).setText(string);
        }
    }

    @Override
    public void init() {
        this.setAV(this.getTemplateContext().getAV());
        this.setDefaultValue();
    }

    protected List<QDRData> buildQDR() {
        ArrayList<QDRData> arrayList = new ArrayList<QDRData>();
        for (AVDimensionality aVDimensionality : this.getAV().getDimensions()) {
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                arrayList.add(new QDRData(aVHierarchy, null, null));
            }
        }
        return arrayList;
    }

    @Override
    public int getPixelSize(int n) {
        int n2 = 0;
        if (this.abreviate) {
            return n2 + this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
        }
        return n2 + this.button.getFontMetrics(this.button.getFont()).stringWidth(this.button.getText());
    }

    @Override
    public boolean isValid() {
        return this.getValue() != null;
    }

    private class MeasureFilter
    implements Filter<AVMeasure> {
        private String type;

        public MeasureFilter(String string) {
            this.type = string;
        }

        @Override
        public boolean matches(AVMeasure aVMeasure) {
            return this.type.equals(aVMeasure.getMeasureType());
        }
    }
}

