/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.templates.stringexpr.ParamEval;
import oracle.hcs.templates.stringexpr.ParamProperty;
import oracle.hcs.templates.stringexpr.ParamStringExpr;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.stringexpr.ParseException;
import oracle.hcs.templates.stringexpr.StringExprParser;
import oracle.hcs.templates.templatelist.BaseTemplate;
import oracle.hcs.templates.templatelist.Param;
import oracle.hcs.templates.templatelist.TemplateExpression;
import oracle.hcs.templates.templatelist.TemplateGroup;
import oracle.hcs.templates.templatelist.TemplateList;
import oracle.hcs.templates.templateview.ItemElement;
import oracle.hcs.templates.templateview.ParamFinder;
import oracle.hcs.templates.templateview.TemplateContext;
import oracle.hcs.templates.templateview.TemplateHyperContext;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.templates.templateview.TemplateHyperParamFactory;
import oracle.hcs.templates.templateview.TemplateHyperParamFinder;
import oracle.hcs.util.ButtonMenu;
import oracle.hcs.util.Resources;
import oracle.javatools.icons.OracleIcons;

public abstract class BaseTemplateHyperView
implements TemplateHyperParamFinder,
ParamFinder,
ParamValue,
ParamEval,
PropertyChangeListener,
ParamProperty {
    private static final Logger LOG = Logger.getLogger(BaseTemplateHyperView.class.getName());
    public static final String TEMPLATE_ADDED = "TEMPLATE_ADDED";
    public static final String TEMPLATE_REMOVED = "TEMPLATE_REMOVED";
    public static final String TEMPLATE_REORDERED = "TEMPLATE_REORDERED";
    public static final String TEMPLATE_INCLUDE = "TEMPLATE_INCLUDE";
    private static final int VERTICAL_SPACING = 5;
    private static final int PARAM_SPACING = 13;
    private static final String SEXPR_MARK = "$sexpr";
    private static final int SEXPR_MARK_LENGTH = "$sexpr".length();
    private boolean treeStyle;
    private final BaseTemplate baseTemplate;
    private final TemplateGroup templateGroup;
    private final Map<String, String> paramDefaults;
    private final List<TemplateHyperParam> hyperParams;
    private final TemplateContext templateContext;
    private final EventListenerList propertyChangeListeners;
    private final TemplateHyperContext hyperContext;
    private final Map<String, Object> allParams;
    private final ParamValue globalParamValue;
    private DefaultMutableTreeNode parentNode;
    private final BaseTemplateHyperView parentTemplateHyperView;
    private List<AbstractAction> actions;
    protected int ROW_HEIGHT = 12;
    private boolean panelInitialized;
    protected JPanel panel;
    private static final String INCLUDE_PARAM = "include";
    private JCheckBox isIncludedCheckBox;
    private JPopupMenu popupMenu = new JPopupMenu();
    private LinkedList<GuiComponent> components = new LinkedList();
    protected HashMap<String, String> currentParameterValues = new HashMap();
    private final String EXPRESSION_PROPERTY_PARAM = "name";
    private static final Pattern tokenizer = Pattern.compile("((?:\\s*[^{}\\s]+\\s*)|(?:\\s+))|(\\{([^{}]+)\\})");

    public BaseTemplateHyperView(BaseTemplateHyperView baseTemplateHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, BaseTemplate baseTemplate, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) {
        this.baseTemplate = baseTemplate;
        this.templateGroup = templateGroup;
        this.templateContext = templateContext;
        this.hyperContext = templateHyperContext;
        this.treeStyle = bl;
        this.parentTemplateHyperView = baseTemplateHyperView;
        templateHyperContext.setTemplateHyperParamFinder(this);
        this.propertyChangeListeners = new EventListenerList();
        this.hyperParams = new ArrayList<TemplateHyperParam>();
        this.allParams = new HashMap<String, Object>();
        this.panel = new JPanel();
        this.paramDefaults = map;
        this.globalParamValue = paramValue;
    }

    public boolean getTreeStyle() {
        return this.treeStyle;
    }

    public BaseTemplateHyperView getParentTemplateHyperView() {
        return this.parentTemplateHyperView;
    }

    protected void clearAllParamValues() {
        this.currentParameterValues.clear();
        Object object = null;
        if (this.allParams.containsKey(INCLUDE_PARAM)) {
            object = this.allParams.get(INCLUDE_PARAM);
        }
        this.allParams.clear();
        if (object != null) {
            this.allParams.put(INCLUDE_PARAM, object);
        }
    }

    protected Object getAllParamValue(String string) {
        Object object = this.allParams.get(string);
        if (object == null) {
            object = this.currentParameterValues.get(string);
        }
        if (object == null && this.globalParamValue != null) {
            try {
                object = this.globalParamValue.getValue(string);
            }
            catch (IOException | IllegalAccessException | InvocationTargetException | SQLException exception) {
                LOG.log(Level.SEVERE, String.format("Fetching Global Value property %s", string), exception);
            }
        }
        return object;
    }

    protected void putAllParamValue(String string, String string2) {
        Object object = this.allParams.get(string);
        if (object == null) {
            this.allParams.put(string, string2);
        } else {
            ArrayList<String> arrayList = null;
            if (object instanceof String) {
                arrayList = new ArrayList<String>();
                arrayList.add(object.toString());
                this.allParams.put(string, arrayList);
            } else {
                arrayList = (ArrayList<String>)object;
            }
            if (string2 != null) {
                arrayList.add(string2);
            }
        }
    }

    public void putGlobalAllParamValue(String string, String string2) {
        this.putAllParamValue(string, string2);
    }

    public List<AbstractAction> getActions() {
        return this.actions;
    }

    public void setActions(List<AbstractAction> list) {
        this.actions = list;
    }

    public abstract TemplateList getTemplateList();

    public abstract String getName();

    public TemplateGroup getTemplateGroup() {
        return this.templateGroup;
    }

    public BaseTemplate getTemplate() {
        return this.baseTemplate;
    }

    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    public TemplateHyperContext getTemplateHyperContext() {
        return this.hyperContext;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.propertyChangeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public Object getProperty(String string) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = this.getHyperParamForName(string);
        if (templateHyperParam == null) {
            templateHyperParam = this.getHyperParamForType(string);
        }
        if (templateHyperParam != null) {
            Object object = templateHyperParam.getValue(string);
            if (object instanceof ItemElement) {
                object = ((ItemElement)object).getExpression();
            }
            return object;
        }
        return null;
    }

    protected abstract String getUi();

    protected Object getTemplateValue(String string) throws SQLException, IOException {
        return null;
    }

    protected int indexOf(BaseTemplateHyperView baseTemplateHyperView) {
        return 0;
    }

    @Override
    public Object getValue(String string) {
        Object object = null;
        try {
            object = this.getTemplateValue(string);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, String.format("Fetching Template Value property %s", string), exception);
        }
        return object;
    }

    @Override
    public Object getValue(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            ParamEval paramEval;
            Object object;
            block11: {
                object = objectArray[0];
                if (object instanceof BaseTemplateHyperView) {
                    paramEval = (BaseTemplateHyperView)object;
                    if (string.equalsIgnoreCase("expression$")) {
                        try {
                            return ((BaseTemplateHyperView)paramEval).getExpression();
                        }
                        catch (Exception exception) {
                            LOG.log(Level.SEVERE, "Error fetching Template Value Expressions", exception);
                            break block11;
                        }
                    }
                    Object object2 = ((BaseTemplateHyperView)paramEval).getAllParamValue(string);
                    if (object2 == null) {
                        try {
                            object2 = ((BaseTemplateHyperView)paramEval).getProperty(string);
                        }
                        catch (Exception exception) {
                            LOG.log(Level.SEVERE, String.format("Error fetching Template Property %s", string), exception);
                        }
                    }
                    return object2;
                }
            }
            if (object instanceof NamedObject) {
                paramEval = (NamedObject)object;
                try {
                    return paramEval.getValue(string);
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, String.format("Error fetching NamedObject %s", string), exception);
                }
            }
        }
        return null;
    }

    public int getSelectedCount() {
        if (this.isIncluded() && this.getTemplate().getIncludeCondition() != null) {
            return 1;
        }
        return 0;
    }

    public abstract String getExpression() throws SQLException, IOException;

    public boolean isIncluded() {
        Object object = this.allParams.get(INCLUDE_PARAM);
        boolean bl = true;
        if (object != null) {
            bl = Boolean.valueOf(object.toString());
        }
        return bl;
    }

    public void setIsIncluded(boolean bl) {
        if (this.isIncludedCheckBox != null) {
            this.isIncludedCheckBox.setSelected(bl);
            this.allParams.put(INCLUDE_PARAM, new Boolean(bl));
        }
    }

    String evaluateStringExpr(String string) throws SQLException, IOException {
        String string2 = null;
        int n = SEXPR_MARK_LENGTH;
        if (string.charAt(n) == ':') {
            n = string.indexOf(91, n);
            string2 = string.substring(SEXPR_MARK_LENGTH + 1, n);
        }
        if (string.startsWith(SEXPR_MARK) && string.endsWith("]$")) {
            string = string.substring(n + 1, string.length() - 2);
        }
        String string3 = string;
        try {
            ParamValue paramValue = StringExprParser.getParamValue();
            string3 = StringExprParser.getParseTree(string, new ParamValue(){

                @Override
                public Object getValue(String string) throws SQLException, IOException {
                    Object object = BaseTemplateHyperView.this.getProperty(string);
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getAllParamValue(string);
                    }
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getMetadataProperty(string);
                    }
                    if (object == null) {
                        object = BaseTemplateHyperView.this.getTemplateValue(string);
                    }
                    return object;
                }
            });
            StringExprParser.setParamValue(paramValue);
            if (string2 != null) {
                this.currentParameterValues.put(string2, string3);
            }
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
            string3 = String.format(" \"%s\"->%s\n", string, parseException.getMessage());
        }
        return string3;
    }

    private String evaluateStringExprs(String string) throws SQLException, IOException {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = -1;
        while ((n2 = string.indexOf(SEXPR_MARK)) != -1 && (n = string.indexOf("]$")) >= 0) {
            String string2 = string.substring(n2, n + 2);
            String string3 = "";
            string3 = this.evaluateStringExpr(string2);
            String string4 = string;
            string = string4.substring(0, n2);
            if (string3 == null) {
                if (string.isEmpty()) {
                    return null;
                }
                string3 = "";
            }
            string = string + string3;
            string = string + string4.substring(n + 2, string4.length());
        }
        return string;
    }

    private Object getMetadataProperty(String string, String string2) {
        if (string != null && string.equalsIgnoreCase("cube")) {
            AnalyticView analyticView = this.getTemplateContext().getAV();
            if (analyticView != null) {
                return this.getMetadataProperty(analyticView, string2);
            }
        } else {
            NamedObject namedObject;
            Object object;
            TemplateHyperParam templateHyperParam = this.getScopedHyperParamForType(string);
            if (templateHyperParam != null && (object = templateHyperParam.getValue(string2)) instanceof NamedObject && (namedObject = (NamedObject)object) != null) {
                return this.getMetadataProperty(namedObject, string2);
            }
        }
        return this.getMetadataProperty(string2);
    }

    private Object getMetadataProperty(String string) {
        Object object = string;
        AbstractMappableSchemaObjectWithDesc abstractMappableSchemaObjectWithDesc = null;
        if (!this.getTemplateContext().isAV()) {
            abstractMappableSchemaObjectWithDesc = this.getTemplateContext().getBaseDimension();
        } else {
            if (this.getTemplateContext().getBaseDimensionality() != null && string.equals("name")) {
                AVDimensionality aVDimensionality = this.getTemplateContext().getBaseDimensionality();
                return aVDimensionality.getDimensionAlias();
            }
            abstractMappableSchemaObjectWithDesc = this.getTemplateContext().getAV();
        }
        if (abstractMappableSchemaObjectWithDesc != null) {
            object = this.getMetadataProperty(abstractMappableSchemaObjectWithDesc, string);
        }
        return object;
    }

    private Object getMetadataProperty(NamedObject namedObject, String string) {
        Object object = null;
        if (string != null && string.length() > 0) {
            try {
                object = namedObject.getValue(string);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Exception getMetadataProperty for property=" + string, exception);
            }
        }
        return object;
    }

    public String getExpression(String string, AVBaseMeasure aVBaseMeasure) throws SQLException, IOException {
        return this.getExpression(string, aVBaseMeasure, null);
    }

    public String getExpression(String string, AVBaseMeasure aVBaseMeasure, ItemElement itemElement) throws SQLException, IOException {
        ParamStringExpr paramStringExpr = ParamStringExpr.getInstance();
        ParamValue paramValue = new ParamValue(){

            @Override
            public Object getValue(String string) throws SQLException, IOException {
                Object object = BaseTemplateHyperView.this.getProperty(string);
                if (object == null) {
                    object = BaseTemplateHyperView.this.getAllParamValue(string);
                }
                if (object == null) {
                    object = BaseTemplateHyperView.this.getMetadataProperty(string);
                }
                if (object == null) {
                    object = BaseTemplateHyperView.this.getTemplateValue(string);
                }
                return object;
            }
        };
        string = paramStringExpr.getExpression(string, paramValue, this, aVBaseMeasure, itemElement, this.currentParameterValues);
        return string;
    }

    @Override
    public String getParamPropertyValue(String string, String string2, AVBaseMeasure aVBaseMeasure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        TemplateHyperParam templateHyperParam = itemElement != null && itemElement.getOptional() != null && itemElement.getOptional().getName().equals(string) ? itemElement.getOptional() : this.getHyperParamForName(string);
        if (templateHyperParam == null) {
            templateHyperParam = this.getHyperParamForType(string);
        }
        String string3 = "{" + string + "}";
        string3 = string;
        if (templateHyperParam != null) {
            Object object = templateHyperParam.getValue();
            if (string2 != null && object != null && object instanceof NamedObject) {
                NamedObject namedObject = (NamedObject)object;
                Object object2 = this.getMetadataProperty(namedObject, string2);
                if (object2 != null) {
                    string3 = object2.toString();
                }
            } else {
                string3 = templateHyperParam.getExpression(string2);
                string3 = object instanceof ItemElement ? this.getExpression(string3, aVBaseMeasure, (ItemElement)object) : this.getExpression(string3, aVBaseMeasure);
            }
        } else if (string.equalsIgnoreCase("measure")) {
            if (aVBaseMeasure != null) {
                string3 = aVBaseMeasure.getName();
            }
        } else {
            Object object;
            Object object3;
            String string4 = string2;
            String string5 = null;
            if (string4 == null) {
                string4 = string;
            }
            if (string != null) {
                string5 = string;
            }
            string3 = (object3 = this.getAllParamValue(string4)) != null ? object3.toString() : ((object = this.getMetadataProperty(string5, string4)) != null ? object.toString() : null);
        }
        if (templateHyperParam != null) {
            hashMap.put(string, string3);
        }
        return string3;
    }

    public BaseTemplateHyperView addNewTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) throws SQLException, IOException {
        return null;
    }

    public BaseTemplateHyperView createTemplateView(BaseTemplate baseTemplate, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) throws SQLException, IOException {
        return null;
    }

    public boolean removeTemplateView(BaseTemplateHyperView baseTemplateHyperView, boolean bl) {
        return false;
    }

    public void setParentNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.parentNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getParentNode() {
        return this.parentNode;
    }

    public Component getNodePanel() throws SQLException, IOException {
        return this.getPanel(0);
    }

    public JPanel getPanel(int n) throws SQLException, IOException {
        if (!this.panelInitialized) {
            Object object;
            Object object2;
            Object object4;
            ArrayList<JMenuItem> arrayList2;
            this.panelInitialized = true;
            String string = this.getUi();
            int n2 = 0;
            if (this.getTemplate() != null && string == null) {
                return null;
            }
            Resources resources = this.hyperContext.getResources();
            this.panel.removeAll();
            this.panel.setLayout(new FlowLayout(0, 4, 2));
            if (this.getTemplate() != null && (arrayList2 = this.getTemplate().getLayout()) != null && ((String)((Object)arrayList2)).equals("BoxLayout")) {
                this.panel.setLayout(new BoxLayout(this.panel, 0));
                this.panel.add(Box.createRigidArea(new Dimension(5, 0)));
            }
            if (resources != null && string != null && this.getTemplateList() != null) {
                string = resources.getXLIFFResource(this.getTemplateList().getFileName(), string);
            }
            if (this.getTemplate() != null && this.getTemplate().getIncludeCondition() != null) {
                boolean bl = false;
                object4 = this.getTemplate().getIncludeCondition();
                if (object4 != null) {
                    String arrayList3 = this.evaluateStringExpr((String)object4);
                    bl = Boolean.parseBoolean(arrayList3);
                }
                this.isIncludedCheckBox = new JCheckBox();
                this.isIncludedCheckBox.setSelected(bl);
                this.allParams.put(INCLUDE_PARAM, new Boolean(bl));
                this.isIncludedCheckBox.setToolTipText(HCSArb.get("CALC_TEMPLATE_INCLUDE_STEP_TOOL_TIP"));
                this.isIncludedCheckBox.addChangeListener(changeEvent -> {
                    boolean bl = this.isIncludedCheckBox.isSelected();
                    this.allParams.put(INCLUDE_PARAM, new Boolean(bl));
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, TEMPLATE_INCLUDE, bl, !bl);
                    this.propertyChange(propertyChangeEvent);
                });
                this.panel.add(this.isIncludedCheckBox);
                if (this.panel.getLayout() instanceof BoxLayout) {
                    this.panel.add(Box.createRigidArea(new Dimension(5, 0)));
                }
            }
            if (this.parentTemplateHyperView != null && this.parentTemplateHyperView.getTemplate() != null && this.parentTemplateHyperView.getTemplate().isList()) {
                if (!this.treeStyle) {
                    if (this.getTemplate() != null) {
                        arrayList2 = new JButton(OracleIcons.getIcon((String)"delete.png"));
                        ((JComponent)((Object)arrayList2)).setToolTipText(HCSArb.get("CALC_TEMPLATE_REMOVE_STEP_TOOL_TIP"));
                        ((JComponent)((Object)arrayList2)).setPreferredSize(new Dimension(25, 17));
                        this.panel.add((Component)((Object)arrayList2));
                        ((AbstractButton)((Object)arrayList2)).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                BaseTemplateHyperView.this.parentTemplateHyperView.removeTemplateView(BaseTemplateHyperView.this, BaseTemplateHyperView.this.treeStyle);
                            }
                        });
                    } else {
                        this.popupMenu = new JPopupMenu();
                        arrayList2 = new ArrayList<JMenuItem>();
                        for (BaseTemplate baseTemplate : this.templateGroup.getTemplates()) {
                            object2 = baseTemplate.getMenu();
                            object2 = this.getExpression((String)object2, null);
                            JMenuItem jMenuItem = new JMenuItem((String)object2);
                            this.popupMenu.add(jMenuItem);
                            arrayList2.add(jMenuItem);
                            jMenuItem.addActionListener(actionEvent -> {
                                try {
                                    this.parentTemplateHyperView.addNewTemplateView((BaseTemplate)((Object)arrayList3), this.getTemplateContext(), this.getTemplateHyperContext(), this.getTreeStyle(), this.templateGroup, this.paramDefaults, this.globalParamValue);
                                }
                                catch (Exception exception) {
                                    LOG.log(Level.SEVERE, "Exception adding a child template", exception);
                                }
                            });
                        }
                        if (!this.getTreeStyle()) {
                            object4 = ButtonMenu.createButtonMenu(null, OracleIcons.getIcon((String)"add.png"), arrayList2);
                            ((JComponent)object4).setToolTipText(HCSArb.get("CALC_TEMPLATE_ADD_STEP_TOOL_TIP"));
                            ((JComponent)object4).setPreferredSize(new Dimension(50, 17));
                            this.panel.add((Component)object4);
                        }
                    }
                } else {
                    arrayList2 = new AbstractAction(HCSArb.get("CALC_TEMPLATE_MENU_REMOVE_STEP")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            BaseTemplateHyperView.this.parentTemplateHyperView.removeTemplateView(BaseTemplateHyperView.this, BaseTemplateHyperView.this.treeStyle);
                            BaseTemplateHyperView.this.getTemplateHyperContext().getTemplateTree().removeChild(BaseTemplateHyperView.this.parentTemplateHyperView.parentNode, BaseTemplateHyperView.this);
                        }
                    };
                    ((AbstractAction)((Object)arrayList2)).putValue("REMOVE", true);
                    object4 = new ArrayList();
                    object4.add(arrayList2);
                    this.setActions((List<AbstractAction>)object4);
                    ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
                    for (final BaseTemplate baseTemplate : this.templateGroup.getTemplates()) {
                        String string3 = baseTemplate.getMenu();
                        string3 = this.getExpression(string3, null);
                        object = new AbstractAction(string3){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    BaseTemplateHyperView baseTemplateHyperView = BaseTemplateHyperView.this.parentTemplateHyperView.addNewTemplateView(baseTemplate, BaseTemplateHyperView.this.getTemplateContext(), BaseTemplateHyperView.this.getTemplateHyperContext(), BaseTemplateHyperView.this.getTreeStyle(), BaseTemplateHyperView.this.templateGroup, BaseTemplateHyperView.this.paramDefaults, BaseTemplateHyperView.this.globalParamValue);
                                    BaseTemplateHyperView.this.getTemplateHyperContext().getTemplateTree().addChild(BaseTemplateHyperView.this.parentTemplateHyperView.parentNode, baseTemplateHyperView);
                                }
                                catch (Exception exception) {
                                    LOG.log(Level.SEVERE, "Exception adding a child template", exception);
                                }
                            }
                        };
                        arrayList.add((AbstractAction)object);
                    }
                    if (this.parentTemplateHyperView.getUi() != null) {
                        this.parentTemplateHyperView.setActions(arrayList);
                    } else {
                        object2 = this.parentTemplateHyperView.getParentTemplateHyperView();
                        if (object2 != null) {
                            ((BaseTemplateHyperView)object2).setActions(arrayList);
                        }
                        ArrayList<AbstractAction> arrayList3 = new ArrayList<AbstractAction>();
                        arrayList3.addAll(arrayList);
                        arrayList3.addAll((Collection<AbstractAction>)object4);
                        this.setActions(arrayList3);
                    }
                }
            }
            arrayList2 = new Resizer(this.hyperContext.getResizeMode());
            if (string != null) {
                object4 = new JLabel();
                this.ROW_HEIGHT = ((JComponent)object4).getFontMetrics(((Component)object4).getFont()).getMaxAscent() + 5;
                Matcher matcher = tokenizer.matcher(string);
                while (matcher.find()) {
                    object2 = matcher.group(1);
                    if (object2 != null) {
                        JLabel jLabel = new JLabel((String)object2);
                        n2 += ((String)object2).length();
                        this.panel.add(jLabel);
                        this.components.add(new GuiComponent(jLabel));
                        continue;
                    }
                    object2 = matcher.group(3);
                    n2 += 40;
                    Object var9_21 = null;
                    TemplateHyperParam templateHyperParam = TemplateHyperParamFactory.getInstance().getHyperParam(this, this.hyperContext, this.templateContext, this, (String)object2);
                    if (templateHyperParam != null) {
                        templateHyperParam.getComponent().setName(this.baseTemplate.getName() + "." + (String)object2);
                        this.addParameterComponents(templateHyperParam);
                        continue;
                    }
                    this.panel.add(new JLabel("PARAM:" + (String)object2));
                }
                object2 = this.getTemplate().getContext();
                if (object2 != null && ((String)object2).equalsIgnoreCase("DIMENSION") && !string.contains("{dimension}")) {
                    Object var9_24 = null;
                    TemplateHyperParam templateHyperParam = TemplateHyperParamFactory.getInstance().getHyperParam(this, this.hyperContext, this.templateContext, this, "dimension");
                    if (templateHyperParam != null) {
                        templateHyperParam.getComponent().setName(this.baseTemplate.getName() + ".dimension");
                        templateHyperParam.setAddToGUI(false);
                        this.addParameterComponents(templateHyperParam);
                    }
                }
                this.setupAllHyperParamDependencies();
                for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                    templateHyperParam.init();
                }
                for (TemplateHyperParam templateHyperParam : this.hyperParams) {
                    if (this.paramDefaults != null && (object = this.paramDefaults.get(templateHyperParam.getType())) != null) {
                        templateHyperParam.setDefault((String)object);
                    }
                    if (this.hyperContext.getResizeMode() == TemplateHyperContext.ResizeMode.LEGACY) continue;
                    templateHyperParam.addPropertyChangeListener((PropertyChangeListener)((Object)arrayList2));
                }
            }
            if (this.hyperContext.getResizeMode() != TemplateHyperContext.ResizeMode.LEGACY) {
                this.panel.addHierarchyListener((HierarchyListener)((Object)arrayList2));
                this.panel.addAncestorListener((AncestorListener)((Object)arrayList2));
                this.panel.addComponentListener((ComponentListener)((Object)arrayList2));
            } else if (!this.treeStyle) {
                if (this.panel.getLayout() instanceof FlowLayout) {
                    if (n2 > 300) {
                        this.panel.setPreferredSize(new Dimension(400, 72));
                    } else if (n2 > 260) {
                        this.panel.setPreferredSize(new Dimension(400, 72));
                    } else if (n2 > 170) {
                        this.panel.setPreferredSize(new Dimension(400, 60));
                    } else {
                        this.panel.setPreferredSize(new Dimension(400, 24));
                    }
                } else {
                    this.panel.setPreferredSize(new Dimension(400, 24));
                }
            }
        }
        return this.panel;
    }

    private void addParameterComponents(TemplateHyperParam templateHyperParam) {
        templateHyperParam.addPropertyChangeListener(this);
        this.hyperParams.add(templateHyperParam);
        if (templateHyperParam.isAddToGUI()) {
            this.panel.add(templateHyperParam.getComponent());
            this.components.add(new GuiComponent(templateHyperParam));
        }
        for (TemplateHyperParam templateHyperParam2 : templateHyperParam.getOptionalHyperParams()) {
            templateHyperParam2.setIsOptional(true);
            this.addParameterComponents(templateHyperParam2);
        }
    }

    public void setupAllHyperParamDependencies() {
        this.setupHyperParamDependencies(this.hyperParams);
    }

    public abstract boolean setupTemplateHyperParamDependencies(List<TemplateHyperParam> var1);

    /*
     * WARNING - void declaration
     */
    public boolean setupHyperParamDependencies(List<TemplateHyperParam> list) {
        void var3_7;
        for (TemplateHyperParam propertyChangeListener2 : list) {
            propertyChangeListener2.setUpDependencies(list);
        }
        boolean bl = false;
        BaseTemplateHyperView baseTemplateHyperView = this.getParentTemplateHyperView();
        if (baseTemplateHyperView != null) {
            BaseTemplateHyperView baseTemplateHyperView2 = baseTemplateHyperView.getParentTemplateHyperView();
        }
        while (!bl && var3_7 != null) {
            bl = var3_7.setupTemplateHyperParamDependencies(list);
            if (bl) continue;
            BaseTemplateHyperView baseTemplateHyperView3 = var3_7.getParentTemplateHyperView();
        }
        return bl;
    }

    public List<String> getVisibleParamNames() throws SQLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            if (!templateHyperParam.getComponent().isVisible()) continue;
            if (templateHyperParam.getName() != null) {
                arrayList.add(templateHyperParam.getName());
                continue;
            }
            arrayList.add(templateHyperParam.getType().toString());
        }
        return arrayList;
    }

    @Override
    public TemplateHyperParam getHyperParamForName(String string) {
        TemplateHyperParam templateHyperParam = null;
        for (TemplateHyperParam templateHyperParam2 : this.getHyperParams()) {
            String string2 = templateHyperParam2.getName();
            if (string2 == null) continue;
            if (string2.equalsIgnoreCase(string)) {
                templateHyperParam = templateHyperParam2;
            }
            if ((string2 + "_name").equalsIgnoreCase(string)) {
                templateHyperParam = templateHyperParam2;
            }
            if (!(string2 + "_description").equalsIgnoreCase(string)) continue;
            templateHyperParam = templateHyperParam2;
        }
        BaseTemplateHyperView baseTemplateHyperView = this.getParentTemplateHyperView();
        if (templateHyperParam == null && baseTemplateHyperView != null) {
            templateHyperParam = baseTemplateHyperView.getHyperParamForName(string);
        }
        return templateHyperParam;
    }

    public TemplateHyperParam getScopedHyperParamForType(String string) {
        TemplateHyperParam templateHyperParam = this.getHyperParamForType(string);
        BaseTemplateHyperView baseTemplateHyperView = this.parentTemplateHyperView;
        while (templateHyperParam == null && baseTemplateHyperView != null) {
            templateHyperParam = baseTemplateHyperView.getHyperParamForType(string);
            baseTemplateHyperView = baseTemplateHyperView.parentTemplateHyperView;
        }
        return templateHyperParam;
    }

    @Override
    public TemplateHyperParam getHyperParamForType(String string) {
        for (TemplateHyperParam templateHyperParam : this.getHyperParams()) {
            if (!templateHyperParam.getType().toString().equalsIgnoreCase(string)) continue;
            return templateHyperParam;
        }
        return null;
    }

    public ParamValue getGlobalParamValue() {
        return this.globalParamValue;
    }

    @Override
    public Param getParam(String string) {
        for (Param param : this.templateGroup.getParams()) {
            if (param.getName() == null || !param.getName().equals(string)) continue;
            return param;
        }
        if (this.getTemplateList() != null) {
            for (Param param : this.getTemplateList().getParams()) {
                if (param.getName() == null || !param.getName().equals(string)) continue;
                return param;
            }
        }
        return null;
    }

    public List<TemplateHyperParam> getHyperParams() {
        return this.hyperParams;
    }

    public List<String> getParamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateHyperParam templateHyperParam : this.hyperParams) {
            if (templateHyperParam.getName() != null) {
                arrayList.add(templateHyperParam.getName());
                continue;
            }
            arrayList.add(templateHyperParam.getType().toString());
        }
        return arrayList;
    }

    protected Map<String, String> getParamDefaults() {
        return this.paramDefaults;
    }

    public HashMap<String, String> getCurrentParameterValues() {
        return this.currentParameterValues;
    }

    public Map<String, String> getTemplateExpressions() throws SQLException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TemplateExpression templateExpression : this.baseTemplate.getTemplateExpressions()) {
            String string;
            String string2 = templateExpression.getName();
            String string3 = templateExpression.getExpression();
            String string4 = templateExpression.getCondition();
            boolean bl = true;
            if (string4 != null && (string = this.evaluateStringExpr(string4)) != null) {
                bl = Boolean.valueOf(string);
            }
            if (string3 == null && (templateExpression = this.getTemplateList().findTemplateExpression(string2)) != null) {
                string3 = templateExpression.getExpression();
            }
            if (!bl) continue;
            string = this.getExpression(string3, null);
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private class Resizer
    extends ComponentAdapter
    implements PropertyChangeListener,
    HierarchyListener,
    AncestorListener {
        private TemplateHyperContext.ResizeMode mode;
        private Component container;

        public Resizer(TemplateHyperContext.ResizeMode resizeMode) {
            this.mode = resizeMode;
        }

        private void findContainer() {
            String string;
            int n;
            this.container = BaseTemplateHyperView.this.panel;
            for (n = 10; this.container != null && n > 0 && !"TEMPLATEGUI_CONTAINER".equals(string = this.container.getName()); --n) {
                this.container = this.container.getParent();
            }
            if (n == 0 || this.container == null) {
                this.container = BaseTemplateHyperView.this.panel;
            } else {
                BaseTemplateHyperView.this.panel.removeComponentListener(this);
                this.container.addComponentListener(this);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.calculateSize();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.calculateSize();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this.calculateSize();
        }

        private void calculateSize() {
            try {
                if (this.container == null || BaseTemplateHyperView.this.panel == this.container) {
                    this.findContainer();
                }
                int n = this.container.getWidth() - 6;
                int n2 = BaseTemplateHyperView.this.panel.getWidth();
                int n3 = BaseTemplateHyperView.this.panel.getHeight();
                boolean bl = false;
                if (n > 0) {
                    int n4 = 0;
                    for (Container container = this.container.getParent(); container != null; container = container.getParent()) {
                        n4 = container.getWidth();
                        if (n4 >= n) continue;
                        n = n4 - 50;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = BaseTemplateHyperView.this.ROW_HEIGHT;
                    boolean bl2 = true;
                    for (GuiComponent guiComponent : BaseTemplateHyperView.this.components) {
                        int n8 = guiComponent.getWidth(n);
                        n6 += n8;
                        bl2 &= n8 == 0;
                        if ((n5 += n8) < n) continue;
                        n7 += BaseTemplateHyperView.this.ROW_HEIGHT;
                        n5 = n8;
                    }
                    if (bl2) {
                        n7 = 0;
                    } else {
                        while (n5 > n) {
                            n7 += BaseTemplateHyperView.this.ROW_HEIGHT;
                            n5 -= n;
                        }
                    }
                    Object object = null;
                    if (this.mode == TemplateHyperContext.ResizeMode.PARAMETER && n7 == BaseTemplateHyperView.this.ROW_HEIGHT) {
                        object = new Dimension(n5, n7);
                        bl = n5 != n2 || n7 != n3;
                    } else {
                        object = new Dimension(n, n7);
                        bl = n != n2 || n7 != n3;
                    }
                    BaseTemplateHyperView.this.panel.setPreferredSize((Dimension)object);
                    BaseTemplateHyperView.this.panel.setMinimumSize((Dimension)object);
                    BaseTemplateHyperView.this.panel.setSize((Dimension)object);
                    if (bl) {
                        BaseTemplateHyperView.this.panel.revalidate();
                        BaseTemplateHyperView.this.panel.repaint();
                    }
                    if (BaseTemplateHyperView.this.panel.getParent() != null) {
                        BaseTemplateHyperView.this.panel.getParent().invalidate();
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Error calculating template size", throwable);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.calculateSize();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private static class GuiComponent {
        private TemplateHyperParam param;
        private int width;

        GuiComponent(TemplateHyperParam templateHyperParam) {
            this.param = templateHyperParam;
        }

        GuiComponent(JLabel jLabel) {
            this.width = jLabel.getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
        }

        int getWidth(int n) {
            if (this.param == null) {
                return this.width + 13;
            }
            if (this.param.isVisible()) {
                this.width = this.param.getPixelSize(n);
                return this.width == 0 ? this.width : this.width + 13;
            }
            return 0;
        }
    }
}

