/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor.plugins;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.phighlight.TooltipPlugin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.calcs.DockableSpecTree;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.hcs.syntaxbuilder.HCSSpec;
import oracle.hcs.syntaxbuilder.HCSSpecTimeoutConnectionCache;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.editor.EditorActions;
import oracle.hcs.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.CalculatedMeasureDebugPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.CalculatedMeasureDropPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.CalculatedMeasureEditorHelp;
import oracle.hcs.syntaxbuilder.editor.plugins.CalculatedMeasureFoldingPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.CalculatedMeasureToolbar;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.TemplateHandlerEmbedEditorPlugin;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.templates.syntaxparser.SyntaxParserStateListener;
import oracle.hcs.templates.templatedialog.TemplateHelperFactoryImpl;
import oracle.hcs.util.FetchIcon;
import oracle.hcs.util.HCSErrorDisplay;
import oracle.hcs.util.HCSFetchIcon;
import oracle.hcs.util.HCSResources;
import oracle.ide.Context;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class CalculatedMeasurePluginsFactory
implements EditorPluginsFactory {
    Logger LOG = Logger.getLogger(CalculatedMeasurePluginsFactory.class.getName());
    public static final String CONTEXT = "MEASURE_EXPRESSION";
    private HCSSyntaxParser parser;

    public List<?> createPlugins(Context context) {
        long l = System.currentTimeMillis();
        this.LOG.finest("creating plugins?" + context.getNode().getClass().getName());
        if (context.getNode() instanceof CalculatedMeasureNode) {
            final CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)context.getNode();
            this.LOG.finest(String.format("creating plugins for: %s.%s", calculatedMeasureNode.getAVName(), calculatedMeasureNode.getMeasureName()));
            ArrayList<Object> arrayList = new ArrayList<Object>(3);
            final DockableSpecTree dockableSpecTree = DockableSpecTree.getInstance();
            Properties properties = this.buildProperties(calculatedMeasureNode);
            boolean bl = false;
            try {
                Connection connection = Connections.getInstance().getConnection(calculatedMeasureNode.getConnectionName());
            }
            catch (DBException dBException) {
                this.LOG.log(Level.SEVERE, "Error fetching connection for calculated measure plugins.", dBException);
                return Collections.emptyList();
            }
            try {
                HCSSpecTimeoutConnectionCache hCSSpecTimeoutConnectionCache;
                Spec spec;
                String string = calculatedMeasureNode.getSchemaName();
                boolean bl2 = HCSMetadataCache.hasForConnection(calculatedMeasureNode.getConnectionName(), string);
                HCSSchema hCSSchema = HCSMetadataCache.getSchema(calculatedMeasureNode.getConnectionName(), string);
                this.parser = bl2 ? new HCSSyntaxParser(calculatedMeasureNode.getConnectionName(), hCSSchema, properties) : new HCSSyntaxParser(calculatedMeasureNode.getConnectionName(), string, properties);
                InsertionHandlerEditorPlugin insertionHandlerEditorPlugin = new InsertionHandlerEditorPlugin(this.parser, calculatedMeasureNode, bl2);
                this.LOG.finest(String.format("simple init variables: %s%n", System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                if (dockableSpecTree.hasTreeForURL(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getAVName())) {
                    dockableSpecTree.setURL(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getAVName());
                    spec = dockableSpecTree.getSpec();
                    this.LOG.finest(String.format("reutilizing spec: %s%n", System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                } else {
                    try {
                        bl = true;
                        spec = this.buildSpecParser(properties, this.parser, new HCSFetchIcon(), calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), (OracleDatabaseImpl)calculatedMeasureNode.getProvider());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.LOG.log(Level.SEVERE, "Error creating spec parser for calculated measure plugins.", unsupportedEncodingException);
                        return Collections.emptyList();
                    }
                    this.LOG.finest(String.format("built spec for cube %s in %s%n", calculatedMeasureNode.getAVName(), System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                }
                insertionHandlerEditorPlugin.setSpec(spec);
                properties.setProperty("ONECLICK_TEMPLATE_DISPLAY", Boolean.toString(true));
                TemplateHandlerEmbedEditorPlugin templateHandlerEmbedEditorPlugin = new TemplateHandlerEmbedEditorPlugin(insertionHandlerEditorPlugin, spec, string, calculatedMeasureNode.getConnectionName());
                CalcSelectionEditorPlugin calcSelectionEditorPlugin = new CalcSelectionEditorPlugin(spec, this.parser, properties);
                EditorActions editorActions = new EditorActions(new HCSFetchIcon(), insertionHandlerEditorPlugin, calcSelectionEditorPlugin, null, spec, this.parser, null, calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getAVName());
                editorActions.setView(context.getView());
                this.LOG.finest(String.format("built plugins: %s%n", System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                if (bl) {
                    if (bl2) {
                        hCSSpecTimeoutConnectionCache = HCSSpecTimeoutConnectionCache.getInstance("Start_Initialization");
                        spec.initialize();
                        hCSSpecTimeoutConnectionCache.shutdown();
                        dockableSpecTree.setSpecParser(spec, calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getAVName());
                        this.LOG.finest(String.format("initialized spec: %s%n", System.currentTimeMillis() - l));
                    } else {
                        this.parser.addSyntaxParserStateListener(new SyntaxParserStateListener(){

                            @Override
                            public void stateChanged(boolean bl) {
                                final 1 var2_2 = this;
                                if (bl) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            CalculatedMeasurePluginsFactory.this.parser.removeSyntaxParserStateListener(var2_2);
                                            long l = System.currentTimeMillis();
                                            HCSSpecTimeoutConnectionCache hCSSpecTimeoutConnectionCache = HCSSpecTimeoutConnectionCache.getInstance("Start_Initialization");
                                            spec.initialize();
                                            hCSSpecTimeoutConnectionCache.shutdown();
                                            CalculatedMeasurePluginsFactory.this.LOG.finest(String.format("initialized spec in call back: %s%n", System.currentTimeMillis() - l));
                                            dockableSpecTree.setSpecParser(spec, calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getAVName());
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
                l = System.currentTimeMillis();
                arrayList.add(new CalculatedMeasureToolbar(insertionHandlerEditorPlugin, spec, this.parser, calcSelectionEditorPlugin, editorActions));
                arrayList.add((Object)new CalculatedMeasureDropPlugin(templateHandlerEmbedEditorPlugin, insertionHandlerEditorPlugin));
                arrayList.add(insertionHandlerEditorPlugin);
                arrayList.add(calcSelectionEditorPlugin);
                arrayList.add(templateHandlerEmbedEditorPlugin);
                calculatedMeasureNode.setTemplateHandler(templateHandlerEmbedEditorPlugin);
                dockableSpecTree.setTemplateHandler(templateHandlerEmbedEditorPlugin);
                calcSelectionEditorPlugin.addCodeSelectionListener(templateHandlerEmbedEditorPlugin);
                arrayList.add(new CalculatedMeasureEditorHelp());
                arrayList.add((Object)new CalculatedMeasureFoldingPlugin(this.parser, insertionHandlerEditorPlugin));
                if (Boolean.parseBoolean(System.getProperty("sqldev.debug", "false"))) {
                    arrayList.add(new CalculatedMeasureDebugPlugin(insertionHandlerEditorPlugin, spec, this.parser));
                }
                hCSSpecTimeoutConnectionCache = new TooltipPlugin();
                arrayList.add(hCSSpecTimeoutConnectionCache);
                hCSSpecTimeoutConnectionCache.addTooltip(insertionHandlerEditorPlugin);
                this.LOG.finest(String.format("plugin setup: %s%n", System.currentTimeMillis() - l));
            }
            catch (Throwable throwable) {
                this.LOG.log(Level.SEVERE, String.format("Failed to instantiate plugins for %s", calculatedMeasureNode.getObjectName()));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private Spec buildSpecParser(Properties properties, HCSSyntaxParser hCSSyntaxParser, FetchIcon fetchIcon, String string, String string2, OracleDatabaseImpl oracleDatabaseImpl) throws UnsupportedEncodingException {
        HCSErrorDisplay hCSErrorDisplay = new HCSErrorDisplay();
        HCSResources hCSResources = new HCSResources("/oracle/hcs/av/calcfactory/calcs.xml");
        InputStreamReader inputStreamReader = new InputStreamReader(CalculatedMeasurePluginsFactory.class.getResourceAsStream("/oracle/hcs/measureexpression/HCSExpressionSpec.xml"), "UTF-8");
        hCSResources.addXLIFFTranslationResource("HCSExpressionSpec.xml", "/oracle/hcs/measureexpression/HCSExpressionSpec.xml");
        TemplateHelperFactoryImpl templateHelperFactoryImpl = new TemplateHelperFactoryImpl(properties, string, string2, hCSSyntaxParser, hCSResources, fetchIcon, oracleDatabaseImpl);
        HCSSpec hCSSpec = new HCSSpec(properties, inputStreamReader, "HCSExpressionSpec.xml", hCSSyntaxParser, templateHelperFactoryImpl, hCSErrorDisplay, hCSResources, fetchIcon, null);
        return hCSSpec;
    }

    private Properties buildProperties(CalculatedMeasureNode calculatedMeasureNode) {
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", calculatedMeasureNode.getSchemaName());
        properties.setProperty("CUBE", calculatedMeasureNode.getAVName());
        properties.setProperty("CONTEXT", CONTEXT);
        return properties;
    }
}

