/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.QuickAVMetadataObjectEditorPanel;
import oracle.hcs.quickav.QuickAVTableCellEditor;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.table.GenericTable;

public class QuickAVMeasureEditor
extends QuickAVMetadataObjectEditorPanel {
    private MeasuresTableModel model;
    private static final int AGGREGATION_METHOD_COL = 3;

    public QuickAVMeasureEditor(List<AVMeasure> list, QuickAVDataTableHelper quickAVDataTableHelper, DBObjectProvider dBObjectProvider) {
        super(list, quickAVDataTableHelper, dBObjectProvider);
        GenericTable genericTable = this.getMetadataObjectsTable();
        genericTable.getColumnModel().getColumn(3).setCellEditor(new AggMethodCellEditor(quickAVDataTableHelper));
        genericTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)true);
    }

    @Override
    protected void refreshTableModel(Object object) {
        List list = (List)object;
        this.model.setMeasures(list);
    }

    @Override
    protected TableModel initTableModel() {
        List list = (List)this.getMetadataObjectList();
        this.model = new MeasuresTableModel(list);
        return this.model;
    }

    @Override
    protected int getComboBoxIndexColumn() {
        return 3;
    }

    @Override
    protected String getMetadataObjectType() {
        return "MEASURE2";
    }

    @Override
    protected List<QuickAVMetadataObjectEditorPanel.ComboTranslationPairs> getTranslationsList() {
        ArrayList<QuickAVMetadataObjectEditorPanel.ComboTranslationPairs> arrayList = new ArrayList<QuickAVMetadataObjectEditorPanel.ComboTranslationPairs>();
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_SUM"), "SUM"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_AVG"), "AVG"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_COUNT"), "COUNT"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_MAX"), "MAX"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_MIN"), "MIN"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_STDDEV"), "STDDEV"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_STDDEV_POP"), "STDDEV_POP"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_STDDEV_SAMP"), "STDDEV_SAMP"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_VAR"), "VARIANCE"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_VAR_POP"), "VAR_POP"));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("MEASURE_AGGREGATION_VAR_SAMP"), "VAR_SAMP"));
        return arrayList;
    }

    @Override
    protected String getDuplicateNameErrorMessage(String string) {
        return HCSArb.format("ATTRIBUTE_DIMENSION_ERROR_DUPLICATE_MEASURE_NAME", string);
    }

    private class AggMethodCellEditor
    extends QuickAVTableCellEditor {
        public AggMethodCellEditor(QuickAVDataTableHelper quickAVDataTableHelper) {
            super(quickAVDataTableHelper);
        }

        @Override
        protected void populateComboBoxModel(DefaultComboBoxModel defaultComboBoxModel) {
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_SUM"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_AVG"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_COUNT"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_MAX"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_MIN"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_STDDEV"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_STDDEV_POP"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_STDDEV_SAMP"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_VAR"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_VAR_POP"));
            defaultComboBoxModel.addElement(HCSArb.getString("MEASURE_AGGREGATION_VAR_SAMP"));
        }
    }

    private class MeasuresTableModel
    extends AbstractTableModel {
        private final int SOURCE_COLUMN_COL = 0;
        private final int DATA_TYPE_COL = 1;
        private final int NAME_COLUMN = 2;
        private final int AGG_COL = 3;
        private final String[] columns = new String[]{HCSArb.getString("QUICK_AV_DIALOG_TABLE_SOURCE_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_DATA_TYPE_COLUMN"), HCSArb.getString("QUICK_AV_MEASURE_EDITOR_NAME_COL"), HCSArb.getString("QUICK_AV_MEASURE_EDITOR_AGG_METHOD_COL")};
        private List<AVMeasure> measures;

        public MeasuresTableModel(List<AVMeasure> list) {
            this.measures = list;
        }

        public void setMeasures(List<AVMeasure> list) {
            this.measures = list;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.measures != null) {
                return this.measures.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 1;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AVMeasure aVMeasure = this.measures.get(n);
            if (aVMeasure != null) {
                Object object = null;
                switch (n2) {
                    case 0: {
                        String string = QuickAVMeasureEditor.this.prov.getExternalName((String)aVMeasure.getProperty("VIEW_NAME"));
                        object = string;
                        break;
                    }
                    case 1: {
                        object = aVMeasure.getProperty("DATA_TYPE_KEY");
                        break;
                    }
                    case 2: {
                        String string = QuickAVMeasureEditor.this.prov.getExternalName(aVMeasure.getName());
                        object = string;
                        break;
                    }
                    case 3: {
                        object = QuickAVMeasureEditor.this.getTranslationKey(aVMeasure.getConsistentSolveSpec());
                    }
                }
                if (object != null) {
                    QuickAVMeasureEditor.this.getQuickAVTableDataHelper().quickAVMetadataChanged();
                    return object;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AVMeasure aVMeasure = this.measures.get(n);
            if (aVMeasure != null) {
                switch (n2) {
                    case 2: {
                        String string = QuickAVMeasureEditor.this.prov.getInternalName((String)object);
                        aVMeasure.setName(string);
                        break;
                    }
                    case 3: {
                        aVMeasure.setConsistentSolveSpec(QuickAVMeasureEditor.this.getTranslationValue((String)object));
                    }
                }
            }
        }
    }
}

