/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.dimension.model.JoinPath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class JoinTablePanel
extends JPanel {
    private GenericTable joinTable;
    private DefaultTableModel tableModel;
    private AbstractAction addJoinCondition;
    private AbstractAction removeJoinCondition;
    private List<DatabaseSource> sources;
    private Map<String, String> joins;
    private static final int JOIN_NAME = 0;
    private static final int DIMENSION_SOURCE_COLUMN_1 = 1;
    private static final int DIMENSION_SOURCE_COLUMN_2 = 2;
    private int minJoinConditions = 0;

    public JoinTablePanel() {
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.joins = new HashMap<String, String>();
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_COLUMN_NAME_LABEL"));
        this.tableModel.addColumn(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_COLUMN_LABEL"));
        this.tableModel.addColumn(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_COLUMN_LABEL"));
        this.joinTable = new GenericTable((TableModel)this.tableModel);
        this.initActions();
    }

    private void initActions() {
        this.addJoinCondition = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{"", "", ""};
                JoinTablePanel.this.tableModel.addRow(objectArray);
            }
        };
        this.removeJoinCondition = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JoinTablePanel.this.joinTable.getRowCount() > JoinTablePanel.this.minJoinConditions) {
                    int n = JoinTablePanel.this.joinTable.getSelectedRow();
                    if (n >= 0) {
                        JoinTablePanel.this.addJoinCondition.setEnabled(true);
                        JoinTablePanel.this.tableModel.removeRow(n);
                    }
                    if (JoinTablePanel.this.tableModel.getRowCount() == 0) {
                        JoinTablePanel.this.removeJoinCondition.setEnabled(false);
                    }
                }
            }
        };
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.joinTable);
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = new ReorderableTableWithTitleBar((JTable)this.joinTable, (JComponent)jScrollPane, true, true);
        TableToolbar tableToolbar = reorderableTableWithTitleBar.getTableToolbar();
        tableToolbar.setLabel(HCSArb.getString("ATTRIBUTE_DIMENSION_JOIN_TABLE_LABEL"));
        tableToolbar.addActionControl((Action)this.addJoinCondition);
        tableToolbar.addActionControl((Action)this.removeJoinCondition);
        this.add((Component)reorderableTableWithTitleBar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setTableCellEditorAndRenderer() {
        this.joinTable.getColumnModel().getColumn(1).setCellEditor(new SourceColumnCellEditor(this.sources));
        this.joinTable.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRenderer());
        this.joinTable.getColumnModel().getColumn(2).setCellEditor(new SourceColumnCellEditor(this.sources));
        this.joinTable.getColumnModel().getColumn(2).setCellRenderer(new ComboBoxRenderer());
    }

    public void setSources(List<DatabaseSource> list) {
        this.sources = list;
        this.setTableCellEditorAndRenderer();
        if (list != null && !list.isEmpty()) {
            this.minJoinConditions = list.size() - 1;
            this.defaultJoinConditions();
        }
    }

    public void setSources(List<DatabaseSource> list, JoinPath[] joinPathArray) {
        this.sources = list;
        this.setTableCellEditorAndRenderer();
        if (list != null && !list.isEmpty()) {
            this.tableModel.setRowCount(0);
            this.minJoinConditions = list.size() - 1;
            for (JoinPath joinPath : joinPathArray) {
                String string = joinPath.getName();
                String[] stringArray = joinPath.getCondition().split("AND");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String[] stringArray2 = string2.split(" = ");
                    Object[] objectArray = new Object[]{string, stringArray2[0].trim(), stringArray2[1].trim()};
                    this.tableModel.addRow(objectArray);
                }
            }
        }
    }

    private void defaultJoinConditions() {
        for (int i = 0; i < this.minJoinConditions; ++i) {
            this.addJoinCondition.actionPerformed(null);
        }
    }

    public JoinPath[] getJoinPaths() {
        this.joins.clear();
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.tableModel.getValueAt(i, 0);
            if (this.joins.containsKey(string)) {
                stringBuffer.append(this.joins.get(string));
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.tableModel.getValueAt(i, 1));
            stringBuffer.append(" = ");
            stringBuffer.append(this.tableModel.getValueAt(i, 2));
            this.joins.put(string, stringBuffer.toString());
        }
        JoinPath[] joinPathArray = new JoinPath[this.joins.size()];
        int n2 = 0;
        for (Map.Entry<String, String> entry : this.joins.entrySet()) {
            joinPathArray[n2] = new JoinPath(entry.getKey(), entry.getValue());
            ++n2;
        }
        return joinPathArray;
    }

    private class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public ComboBoxRenderer() {
            this.setUI(new BasicComboBoxUI(){

                @Override
                protected JButton createArrowButton() {
                    return new BasicArrowButton(5, Color.white, Color.white, Color.black, Color.white);
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.removeAllItems();
                this.addItem(object);
            }
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }

    private class SourceColumnCellEditor
    extends DefaultCellEditor {
        private List<DatabaseSource> sources;

        public SourceColumnCellEditor(List<DatabaseSource> list) {
            super(new JComboBox());
            this.sources = list;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (component instanceof JComboBox) {
                this.populateComboBox((JComboBox)component);
                return component;
            }
            return null;
        }

        private void populateComboBox(JComboBox jComboBox) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            jComboBox.setModel(defaultComboBoxModel);
            for (DatabaseSource databaseSource : this.sources) {
                for (Column column : databaseSource.getColumns()) {
                    String string = databaseSource.getAlias() + "." + column.getName();
                    defaultComboBoxModel.addElement(string);
                }
            }
        }
    }
}

