/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.db.panels.ChildObjectEditorPanel2;
import oracle.hcs.db.panels.HCSLanguageExpressionBuilder;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.model.OrderByClause;
import oracle.hcs.dimension.panels.CompletionAttributeMatchProvider;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.SyntaxBuilderLauncher;
import oracle.hcs.util.ButtonMenu;
import oracle.hcs.util.CompletionCellEditor;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;

public class DimensionLevelObjectEditorPanel<T extends DimensionLevel, P extends AbstractMappableSchemaObjectWithDesc>
extends ChildObjectEditorPanel2<T, P> {
    private DBObjectProvider prov;
    private TreeSet<DimensionLevel> invalidLevels = new TreeSet(new DBObjectComparator());
    private String origLevelName;
    private DefaultTableModel keyTableModel;
    private JTable keyTable;
    private JButton removeButton;
    private JCheckBox skipNullValuesCheckBox;
    private List<OrderByPanel> clausePanels;
    JPanel orderByPanel;
    private HCSLanguageExpressionBuilder languageEditor;
    private int lastAlternateKeyRow;
    private int memberNameRow;
    private int memberCaptionRow;
    private int memberDescriptionRow;
    private int determinesRow;
    private boolean enableDetermines;
    private static final String NONE = HCSArb.get("NONE");
    private static final String MEMBER_NAME_LABEL = HCSArb.getString("DIMENSION_LEVEL_MEMBER_NAME_LABEL");
    private static final String MEMBER_CAPTION_LABEL = HCSArb.getString("DIMENSION_LEVEL_MEMBER_CAPTION_LABEL");
    private static final String MEMBER_DESC_LABEL = HCSArb.getString("DIMENSION_LEVEL_MEMBER_DESC_LABEL");
    private static final String ALTERNATE_KEY_LABEL = HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL");
    private static final String ORDER_BY_LABEL = HCSArb.getString("DIMENSION_LEVEL_ORDER_BY");
    private static final String NULL_VALUES_LABEL = HCSArb.getString("DIMENSION_LEVEL_NULL_VALUES");
    private static final String USING_LABEL = HCSArb.getString("DIMENSION_LEVEL_USING");
    private static final String[] ORDER_BY_CRITERIA = new String[]{"ASC", "DESC"};
    private static final String[] ORDER_BY_AGGREGATION = new String[]{"MIN", "MAX"};
    private static final String[] NULL_POSITIONS_VALUES = new String[]{"FIRST", "LAST"};
    private static final String[] NULL_POSITIONS_VALUE_TRANSLATIONS = new String[]{HCSArb.getString("DIMENSION_LEVEL_NULL_VALUES_FIRST"), HCSArb.getString("DIMENSION_LEVEL_NULL_VALUES_LAST")};
    private final String TO_CHAR = "TO_CHAR(\"%s\")";
    private static final int KEY_TYPE_COLUMN = 0;
    private static final int KEY_COLUMN = 1;
    private Map<String, Boolean> propagateLevelMemberNameCache = new HashMap<String, Boolean>();
    private boolean initialized;
    private static final Logger LOG = Logger.getLogger(DimensionLevelObjectEditorPanel.class.getName());
    private LanguageCellEditor languageCellEditor1;
    private LanguageCellEditor languageCellEditor2;

    public DimensionLevelObjectEditorPanel() {
        super("DimensionLevelTableEditorPanel", "DIMENSION LEVEL");
        this.clausePanels = new ArrayList<OrderByPanel>();
        this.layoutComponents();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        if (!this.initialized) {
            this.initLevelMemberNameCache();
            this.initialized = true;
        }
        this.initLanguageExpressionBuilder();
        this.loadLevelData();
        this.origLevelName = null;
        if (this.getChildObject() != null) {
            this.origLevelName = ((DimensionLevel)this.getChildObject()).getName();
        }
    }

    private void initLevelMemberNameCache() {
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
            if (!dimensionLevel.isNewObject()) continue;
            this.propagateLevelMemberNameCache.put(dimensionLevel.getName(), true);
        }
    }

    private void initLanguageExpressionBuilder() {
        Properties properties = new Properties();
        properties.put("DIMENSION", ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getName());
        properties.setProperty("VISIBLE_DOCS", Boolean.toString(false));
        properties.setProperty("VISIBLE_SYNTAXDETAIL", Boolean.toString(false));
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        String string = attributeDimension.getSchema().getName();
        HCSSchema hCSSchema = null;
        String string2 = Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)this.getProvider()));
        try {
            if (!this.isEditing()) {
                hCSSchema = HCSMetadataCache.getSchemaCopy(string2, string);
                hCSSchema.addDimension(attributeDimension);
            } else {
                hCSSchema = HCSMetadataCache.getUpdatedSchema(string2, string);
            }
            this.languageEditor = new HCSLanguageExpressionBuilder((OracleDatabaseImpl)this.getProvider(), "/oracle/hcs/dimension/panels/LevelMemberLanguageSnippet.xml", hCSSchema, properties, attributeDimension.getAttributes());
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void loadLevelData() {
        DimensionLevel dimensionLevel = (DimensionLevel)this.getChildObject();
        this.keyTableModel.setRowCount(0);
        if (dimensionLevel != null) {
            String[] stringArray;
            CompletionTextField completionTextField = new CompletionTextField();
            CompletionTextField completionTextField2 = new CompletionTextField();
            ArrayList<DimensionAttribute> arrayList = new ArrayList<DimensionAttribute>();
            ArrayList<DimensionAttribute> arrayList2 = new ArrayList<DimensionAttribute>();
            arrayList.addAll(this.encloseAttributes(Arrays.asList(dimensionLevel.getDimension().getAttributes())));
            arrayList2.addAll(Arrays.asList(dimensionLevel.getDimension().getAttributes()));
            arrayList.add(0, new DimensionAttribute(NONE));
            arrayList2.add(0, new DimensionAttribute(NONE));
            CompletionAttributeMatchProvider completionAttributeMatchProvider = new CompletionAttributeMatchProvider(completionTextField.getPopupHandler().getInsightList(), arrayList);
            CompletionAttributeMatchProvider completionAttributeMatchProvider2 = new CompletionAttributeMatchProvider(completionTextField2.getPopupHandler().getInsightList(), arrayList2);
            completionTextField.getPopupHandler().registerInsightProvider((CompletionProvider)completionAttributeMatchProvider);
            completionTextField2.getPopupHandler().registerInsightProvider((CompletionProvider)completionAttributeMatchProvider2);
            this.languageCellEditor1 = new LanguageCellEditor(completionTextField, completionAttributeMatchProvider);
            this.languageCellEditor2 = new LanguageCellEditor(completionTextField2, completionAttributeMatchProvider2);
            String string = dimensionLevel.getLevelMemberName();
            if (string == null) {
                string = NONE;
            }
            this.keyTableModel.addRow(new Object[]{MEMBER_NAME_LABEL, string});
            String string2 = dimensionLevel.getLevelMemberCaption();
            if (string2 == null) {
                string2 = NONE;
            }
            this.keyTableModel.addRow(new Object[]{MEMBER_CAPTION_LABEL, string2});
            String string3 = dimensionLevel.getLevelMemberDescription();
            if (string3 == null) {
                string3 = NONE;
            }
            this.keyTableModel.addRow(new Object[]{MEMBER_DESC_LABEL, string3});
            if (this.enableDetermines) {
                stringArray = dimensionLevel.getLevelDeterminesKeys();
                if (stringArray != null) {
                    if (stringArray.length > 0) {
                        for (String string4 : ((DimensionLevel)this.getChildObject()).getLevelDeterminesKeys()) {
                            this.keyTableModel.addRow(new Object[]{HCSArb.getString("DIMENSION_LEVEL_DETERMINES_LABEL"), string4});
                        }
                    } else {
                        this.keyTableModel.addRow(new Object[]{HCSArb.getString("DIMENSION_LEVEL_DETERMINES_LABEL"), NONE});
                    }
                } else {
                    this.keyTableModel.addRow(new Object[]{HCSArb.getString("DIMENSION_LEVEL_DETERMINES_LABEL"), NONE});
                }
            }
            if ((stringArray = dimensionLevel.getLevelAlternateKeys()) != null) {
                if (stringArray.length > 0) {
                    for (String string5 : stringArray) {
                        this.keyTableModel.addRow(new Object[]{HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL"), string5});
                    }
                } else {
                    this.keyTableModel.addRow(new Object[]{HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL"), NONE});
                }
            } else {
                this.keyTableModel.addRow(new Object[]{HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL"), NONE});
            }
            this.clausePanels.clear();
            this.orderByPanel.removeAll();
            if (dimensionLevel.getLevelOrderByClauses() == null || dimensionLevel.getLevelOrderByClauses().length == 0) {
                OrderByPanel orderByPanel = new OrderByPanel(new OrderByClause());
                this.clausePanels.add(orderByPanel);
                this.orderByPanel.add(orderByPanel);
            } else {
                for (OrderByClause orderByClause : dimensionLevel.getLevelOrderByClauses()) {
                    OrderByPanel orderByPanel = new OrderByPanel(orderByClause);
                    this.clausePanels.add(orderByPanel);
                    this.orderByPanel.add(orderByPanel);
                }
            }
            this.reloadOrderBy();
            this.skipNullValuesCheckBox.setSelected(dimensionLevel.getLevelSkipNullValues());
        }
        this.validate();
        this.repaint();
    }

    private void reloadOrderBy() {
        for (int i = 0; i <= this.clausePanels.size() - 1; ++i) {
            this.clausePanels.get(i).setAsFirst(i == 0);
        }
    }

    private int indexOfNullsPositionValue(String string) {
        for (int i = 0; i < NULL_POSITIONS_VALUES.length; ++i) {
            if (!string.equals(NULL_POSITIONS_VALUES[i])) continue;
            return i;
        }
        return 0;
    }

    public void commit(DimensionLevel dimensionLevel) throws TraversalException {
        Object object;
        String[] stringArray;
        String string = dimensionLevel.getName();
        String string2 = this.prov.getExternalName(string);
        DimensionLevel dimensionLevel2 = (DimensionLevel)dimensionLevel.copyTo(null);
        try {
            this.prov.validateName("DIMENSION LEVEL", string2);
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidLevels.add(dimensionLevel);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidLevels.contains(dimensionLevel)) {
            this.invalidLevels.remove(dimensionLevel);
        }
        String string3 = string;
        dimensionLevel2.setName(string3);
        dimensionLevel2.copyTo(dimensionLevel);
        if (dimensionLevel.isNewObject() && !this.propagateLevelMemberNameCache.containsKey(dimensionLevel.getName())) {
            this.propagateLevelMemberNameCache.put(dimensionLevel.getName(), true);
        }
        if (!this.isEditing()) {
            dimensionLevel.setOriginalLevelName(string3);
            dimensionLevel2.setOriginalLevelName(string3);
        } else if (!dimensionLevel.isNewObject()) {
            dimensionLevel2.setOriginalLevelName(dimensionLevel.getOriginalLevelName());
        } else {
            dimensionLevel.setOriginalLevelName(string3);
            dimensionLevel2.setOriginalLevelName(string3);
        }
        dimensionLevel.setLevelMemberName(null);
        dimensionLevel.setLevelMemberCaption(null);
        if (this.enableDetermines) {
            dimensionLevel.setLevelDeterminesKeys(null);
        }
        dimensionLevel.setLevelSkipNullValues(this.skipNullValuesCheckBox.isSelected());
        dimensionLevel.removeLevelOrderByClauses();
        for (OrderByPanel serializable2 : this.clausePanels) {
            if (serializable2.getAttribute() == null || serializable2.getAttribute().isEmpty()) continue;
            OrderByClause i = new OrderByClause();
            i.setAggregation(serializable2.getAggregation());
            i.setOrderByKey(serializable2.getAttribute());
            i.setCriteria(serializable2.getCriteria());
            i.setNullsPosition(serializable2.getOrderByNulls());
            dimensionLevel.addLevelOrderByClause(i);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int stringArray2 = 0; stringArray2 < this.keyTableModel.getRowCount(); ++stringArray2) {
            stringArray = (String[])this.keyTableModel.getValueAt(stringArray2, 0);
            object = (String)this.keyTableModel.getValueAt(stringArray2, 1);
            if (object == null) continue;
            if (stringArray.equals(HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL")) && !((String)object).isEmpty() && !((String)object).equals(NONE)) {
                arrayList.add(object);
            }
            if (stringArray.equals(MEMBER_NAME_LABEL)) {
                if (((String)object).isEmpty() || ((String)object).equals(NONE)) {
                    dimensionLevel.setLevelMemberName(null);
                } else {
                    dimensionLevel.setLevelMemberName((String)object);
                }
            }
            if (stringArray.equals(MEMBER_CAPTION_LABEL)) {
                if (((String)object).isEmpty() || ((String)object).equals(NONE)) {
                    dimensionLevel.setLevelMemberCaption(null);
                } else {
                    dimensionLevel.setLevelMemberCaption((String)object);
                }
            }
            if (stringArray.equals(MEMBER_DESC_LABEL)) {
                if (((String)object).isEmpty() || ((String)object).equals(NONE)) {
                    dimensionLevel.setLevelMemberDescription(null);
                } else {
                    dimensionLevel.setLevelMemberDescription((String)object);
                }
            }
            if (!stringArray.equals(HCSArb.getString("DIMENSION_LEVEL_DETERMINES_LABEL")) || ((String)object).isEmpty() || ((String)object).equals(NONE)) continue;
            arrayList2.add(object);
        }
        String[] stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        dimensionLevel.setLevelAlternateKeys(stringArray);
        if (this.enableDetermines) {
            if (stringArray2 != null && stringArray2.length == 0) {
                stringArray2 = null;
            }
            dimensionLevel.setLevelDeterminesKeys(stringArray2);
        }
        if (((AttributeDimension)(object = dimensionLevel.getDimension())).findLevel(dimensionLevel2.getName()) == null) {
            ((AttributeDimension)object).addLevel(dimensionLevel2);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        this.stopCellEditing();
        super.commitPanel();
        DimensionLevel dimensionLevel = (DimensionLevel)this.getChildObject();
        this.commit(dimensionLevel);
        AttributeDimension attributeDimension = (AttributeDimension)dimensionLevel.getParent();
        if (attributeDimension.findLevel(dimensionLevel.getName()) == null) {
            attributeDimension.addLevel(dimensionLevel);
        }
    }

    private void stopCellEditing() {
        Enumeration<TableColumn> enumeration = this.keyTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n = tableColumn.getModelIndex();
            if (n != 1) continue;
            for (int i = 0; i < this.keyTable.getRowCount(); ++i) {
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.keyTable.getCellEditor(i, n);
                defaultCellEditor.stopCellEditing();
            }
        }
    }

    private void removeKey() {
        int n = this.keyTable.getEditingRow();
        if (n == -1) {
            n = this.keyTable.getSelectedRow();
        }
        if (this.keyTable.isEditing()) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        this.computeRowReferences();
        if (n == this.lastAlternateKeyRow && n == 0 || n == this.memberNameRow || n == this.memberCaptionRow || n == this.memberDescriptionRow || n == this.determinesRow && n == this.memberCaptionRow + 1) {
            this.keyTableModel.setValueAt(NONE, n, 1);
        } else {
            this.keyTableModel.removeRow(n);
            if (n < this.keyTable.getRowCount() && n > -1) {
                this.keyTable.addRowSelectionInterval(n, n);
            } else if (this.keyTable.getRowCount() > 0) {
                this.keyTable.addRowSelectionInterval(this.keyTable.getRowCount() - 1, this.keyTable.getRowCount() - 1);
            }
        }
        this.computeRowReferences();
    }

    private void addKey(KeyType keyType) {
        Object[] objectArray;
        this.computeRowReferences();
        if (keyType == KeyType.ALTERNATE_KEY) {
            objectArray = new Object[]{HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL"), NONE};
            this.keyTableModel.insertRow(++this.lastAlternateKeyRow, objectArray);
        }
        if (keyType == KeyType.DETERMINES) {
            objectArray = new Object[]{HCSArb.getString("DIMENSION_LEVEL_DETERMINES_LABEL"), NONE};
            this.keyTableModel.insertRow(++this.determinesRow, objectArray);
        }
        this.computeRowReferences();
        this.removeButton.setEnabled(true);
    }

    private void computeRowReferences() {
        this.memberNameRow = 0;
        this.memberCaptionRow = 0;
        this.memberDescriptionRow = 0;
        this.lastAlternateKeyRow = 0;
        this.determinesRow = 0;
        for (int i = 0; i < this.keyTableModel.getRowCount(); ++i) {
            String string = (String)this.keyTableModel.getValueAt(i, 0);
            if (string.equals(HCSArb.getString("DIMENSION_LEVEL_ALTERNATE_KEY_LABEL"))) {
                this.lastAlternateKeyRow = i;
            }
            if (string.equals(MEMBER_NAME_LABEL)) {
                this.memberNameRow = i;
            }
            if (string.equals(MEMBER_CAPTION_LABEL)) {
                this.memberCaptionRow = i;
            }
            if (string.equals(MEMBER_DESC_LABEL)) {
                this.memberDescriptionRow = i;
            }
            if (!string.equals(HCSArb.getString("DIMENSION_LEVEL_DETERMINES_LABEL"))) continue;
            this.determinesRow = i;
        }
        if (this.lastAlternateKeyRow == 0) {
            this.lastAlternateKeyRow = this.memberDescriptionRow;
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"levels"});
        this.keyTableModel = new DefaultTableModel();
        this.keyTable = new JTable(this.keyTableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                TableColumnModel tableColumnModel = this.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                int n3 = tableColumn.getModelIndex();
                return n3 != 0;
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                int n3 = this.convertColumnIndexToModel(n2);
                if (n3 == 1) {
                    if (DimensionLevelObjectEditorPanel.this.keyTable.getValueAt(n, 0).equals(ALTERNATE_KEY_LABEL)) {
                        return DimensionLevelObjectEditorPanel.this.languageCellEditor2;
                    }
                    return DimensionLevelObjectEditorPanel.this.languageCellEditor1;
                }
                return super.getCellEditor(n, n2);
            }
        };
        this.keyTableModel.setColumnIdentifiers(new String[]{HCSArb.getString("DIMENSION_LEVEL_KEY_TYPE_COLUMN_LABEL"), HCSArb.getString("DIMENSION_LEVEL_KEY_LABEL")});
        ControlBar controlBar = new ControlBar();
        JPopupMenu jPopupMenu = new JPopupMenu();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem = new JMenuItem(HCSArb.getString("DIMENSION_LEVEL_ADD_ALTERNATE_KEY_LABEL"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionLevelObjectEditorPanel.this.addKey(KeyType.ALTERNATE_KEY);
            }
        });
        arrayList.add(jMenuItem);
        if (this.enableDetermines) {
            jMenuItem = new JMenuItem(HCSArb.getString("DIMENSION_LEVEL_ADD_DETERMINES_LABEL"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionLevelObjectEditorPanel.this.addKey(KeyType.DETERMINES);
                }
            });
            arrayList.add(jMenuItem);
        }
        ButtonMenu buttonMenu = ButtonMenu.createButtonMenu(null, OracleIcons.getIcon((String)"add.png"), arrayList);
        buttonMenu.setToolTipText(HCSArb.getString("DIMENSION_LEVEL_ADD_BUTTON_TOOLTIP"));
        controlBar.add((Component)buttonMenu);
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(HCSArb.getString("DIMENSION_LEVEL_REMOVE_BUTTON_TOOLTIP"));
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        controlBar.add((Component)this.removeButton);
        this.removeButton.setEnabled(true);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionLevelObjectEditorPanel.this.removeKey();
            }
        });
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("DIMENSION_LEVEL_KEY_TABLE_LABEL")));
        componentWithTitlebar.setControlBar(controlBar);
        JScrollPane jScrollPane = new JScrollPane(this.keyTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
        this.orderByPanel = new JPanel();
        this.orderByPanel.setLayout(new BoxLayout(this.orderByPanel, 1));
        this.add(this.orderByPanel, new GridBagConstraints(0, ++n, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.skipNullValuesCheckBox = new JCheckBox(HCSArb.getString("DIMENSION_LEVEL_SKIP_NULL_VALUES"));
        this.add(this.skipNullValuesCheckBox, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 12), 0, 0));
        this.keyTableModel.addTableModelListener(tableModelEvent -> {
            int n;
            int n2 = tableModelEvent.getColumn();
            if (n2 == 1 && (n = tableModelEvent.getFirstRow()) == tableModelEvent.getLastRow()) {
                boolean bl;
                String string = (String)this.keyTableModel.getValueAt(n, 0);
                String string2 = (String)this.keyTableModel.getValueAt(n, 1);
                DimensionLevel dimensionLevel = (DimensionLevel)this.getChildObject();
                if (string.equals(MEMBER_NAME_LABEL) && this.propagateLevelMemberNameCache.containsKey(dimensionLevel.getName()) && (bl = this.propagateLevelMemberNameCache.get(dimensionLevel.getName()).booleanValue())) {
                    for (int i = 0; i < this.keyTableModel.getRowCount() - 1; ++i) {
                        string = (String)this.keyTableModel.getValueAt(i, 0);
                        if (string.equals(MEMBER_CAPTION_LABEL)) {
                            this.keyTableModel.setValueAt(string2, i, 1);
                        }
                        if (!string.equals(MEMBER_DESC_LABEL)) continue;
                        this.keyTableModel.setValueAt(string2, i, 1);
                    }
                    this.propagateLevelMemberNameCache.put(dimensionLevel.getName(), false);
                }
            }
        });
    }

    protected boolean shouldValidateOnExit() {
        return true;
    }

    protected void validateObject() throws TraversalException {
        Object object;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (ColumnIdentifier object2 : ((DimensionLevel)this.getChildObject()).getDimension().getSourceColumns()) {
            object = object2.getColumn();
            if (((Column)object).isString()) {
                hashMap.put(((Column)object).getName(), Boolean.TRUE);
                continue;
            }
            hashMap.put(((Column)object).getName(), Boolean.FALSE);
        }
        for (int i = 0; i < this.keyTableModel.getRowCount(); ++i) {
            Boolean bl;
            String string = (String)this.keyTableModel.getValueAt(i, 0);
            object = UIStringUtils.stripDoubleQuotes((String)this.keyTableModel.getValueAt(i, 1));
            if (object == null || !string.equals(HCSArb.getString("DIMENSION_LEVEL_MEMBER_NAME_LABEL")) && !string.equals(HCSArb.getString("DIMENSION_LEVEL_MEMBER_CAPTION_LABEL")) && !string.equals(HCSArb.getString("DIMENSION_LEVEL_MEMBER_DESC_LABEL")) || (bl = (Boolean)hashMap.get(object)) == null || bl.booleanValue()) continue;
            throw new TraversalException(HCSArb.format("DIMENSION_LEVEL_PROPERTY_VALIDATION_ERROR_MSG", object), HCSArb.getString("DIMENSION_LEVEL_PROPERTY_VALIDATION_ERROR_TITLE"));
        }
    }

    private List<DimensionAttribute> encloseAttributes(List<DimensionAttribute> list) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (ColumnIdentifier object : ((DimensionLevel)this.getChildObject()).getDimension().getSourceColumns()) {
            Column column = object.getColumn();
            if (column.isString()) {
                hashMap.put(column.getName(), Boolean.TRUE);
                continue;
            }
            hashMap.put(column.getName(), Boolean.FALSE);
        }
        ArrayList arrayList = new ArrayList();
        for (DimensionAttribute dimensionAttribute : list) {
            DimensionAttribute dimensionAttribute2 = new DimensionAttribute();
            dimensionAttribute2.setName(dimensionAttribute.getName());
            dimensionAttribute2.setDataType(dimensionAttribute.getDataType());
            dimensionAttribute2.setExternalName(dimensionAttribute.getExternalName());
            Boolean bl = (Boolean)hashMap.get(dimensionAttribute.getMapExpression());
            if (bl != null && !bl.booleanValue()) {
                dimensionAttribute2.setExternalName(String.format("TO_CHAR(\"%s\")", dimensionAttribute2.getName()));
            }
            arrayList.add(dimensionAttribute2);
        }
        return arrayList;
    }

    class OrderByPanel
    extends JPanel {
        private JComboBox aggregationCombo;
        private JComboBox attributeCombo;
        private JComboBox nullsPositionCombo;
        private JComboBox criteriaCombo;
        private JButton addButton;
        private JButton removeButton;

        public OrderByPanel(OrderByClause orderByClause) {
            super(new GridBagLayout());
            this.layoutComponents();
            this.init(orderByClause);
        }

        private void layoutComponents() {
            this.add((Component)new JLabel(ORDER_BY_LABEL), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.attributeCombo = new JComboBox();
            this.attributeCombo.setName("orderByAttributes");
            this.add((Component)this.attributeCombo, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.criteriaCombo = new JComboBox<String>(ORDER_BY_CRITERIA);
            this.add((Component)this.criteriaCombo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.add((Component)new JLabel(NULL_VALUES_LABEL), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.nullsPositionCombo = new JComboBox<String>(NULL_POSITIONS_VALUE_TRANSLATIONS);
            this.add((Component)this.nullsPositionCombo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.add((Component)new JLabel(USING_LABEL), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.aggregationCombo = new JComboBox<String>(ORDER_BY_AGGREGATION);
            this.aggregationCombo.setName("aggregationCombo");
            this.add((Component)this.aggregationCombo, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
            this.addButton.setToolTipText(HCSArb.getString("DIMENSION_LEVEL_ORDER_BY_ADD_BUTTON_TOOLTIP"));
            this.addButton.setVisible(true);
            this.addButton.setPreferredSize(new Dimension(22, 20));
            this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
            this.removeButton.setToolTipText(HCSArb.getString("DIMENSION_LEVEL_ORDER_BY_REMOVE_BUTTON_TOOLTIP"));
            this.removeButton.setVisible(false);
            this.removeButton.setPreferredSize(new Dimension(22, 20));
            this.add((Component)this.addButton, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.add((Component)this.removeButton, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        }

        private void init(OrderByClause orderByClause) {
            Object object;
            DimensionLevel dimensionLevel = (DimensionLevel)DimensionLevelObjectEditorPanel.this.getChildObject();
            List<DimensionAttribute> list = Arrays.asList(dimensionLevel.getDimension().getAttributes());
            String string = orderByClause.getOrderByKey();
            if (string == null) {
                Object object2;
                object = dimensionLevel.getLevelKey();
                if (object != null && ((String)object).contains(",") && (object2 = ((String)(object = ((String)object).replaceAll("[()]", ""))).split(",")) != null & ((String[])object2).length > 0) {
                    object = object2[0];
                }
                string = object;
                this.aggregationCombo.setSelectedIndex(0);
                this.criteriaCombo.setSelectedIndex(0);
                this.nullsPositionCombo.setSelectedIndex(0);
            } else {
                this.aggregationCombo.setSelectedItem(orderByClause.getAggregation());
                this.criteriaCombo.setSelectedItem(orderByClause.getCriteria());
                this.nullsPositionCombo.setSelectedIndex(DimensionLevelObjectEditorPanel.this.indexOfNullsPositionValue(orderByClause.getNullsPosition()));
            }
            object = new ArrayList();
            for (DimensionAttribute dimensionAttribute : list) {
                object.add(dimensionAttribute.getName());
            }
            this.attributeCombo.setModel(new DefaultComboBoxModel<Object>(object.toArray()));
            this.attributeCombo.setSelectedItem(string);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OrderByPanel orderByPanel = new OrderByPanel(new OrderByClause());
                    DimensionLevelObjectEditorPanel.this.clausePanels.add(orderByPanel);
                    DimensionLevelObjectEditorPanel.this.orderByPanel.add(orderByPanel);
                    DimensionLevelObjectEditorPanel.this.reloadOrderBy();
                }
            });
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionLevelObjectEditorPanel.this.clausePanels.remove(OrderByPanel.this);
                    OrderByPanel.this.setVisible(false);
                    DimensionLevelObjectEditorPanel.this.reloadOrderBy();
                }
            });
        }

        public String getAttribute() {
            return (String)this.attributeCombo.getSelectedItem();
        }

        public String getCriteria() {
            return (String)this.criteriaCombo.getSelectedItem();
        }

        public String getOrderByNulls() {
            return NULL_POSITIONS_VALUES[this.nullsPositionCombo.getSelectedIndex()];
        }

        public String getAggregation() {
            return (String)this.aggregationCombo.getSelectedItem();
        }

        public void setAsFirst(boolean bl) {
            this.addButton.setVisible(bl);
            this.removeButton.setVisible(!bl);
        }
    }

    private class LanguageCellEditor
    extends CompletionCellEditor {
        private CompletionTextField ctf;
        protected int row;
        protected int column;
        protected JTable jtable;

        public LanguageCellEditor(CompletionTextField completionTextField, CompletionAttributeMatchProvider completionAttributeMatchProvider) {
            super(completionTextField, completionAttributeMatchProvider);
            this.ctf = completionTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, final int n, int n2) {
            this.row = n;
            this.column = n2;
            this.jtable = jTable;
            String string = String.valueOf(jTable.getModel().getValueAt(n, 0));
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            int n3 = tableColumn.getModelIndex();
            if (n3 == 1 && (string.equalsIgnoreCase(MEMBER_NAME_LABEL) || string.equalsIgnoreCase(MEMBER_CAPTION_LABEL) || string.equalsIgnoreCase(MEMBER_DESC_LABEL) || string.equalsIgnoreCase(ALTERNATE_KEY_LABEL))) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                this.ctf.setText(String.valueOf(object));
                this.ctf.selectAll();
                super.setCompletionPopupHandlerStatus(this.ctf.getText());
                jPanel.add(this.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
                JButton jButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.launchEditLevelMemberLanguageDialog(n);
                    }

                    private void launchEditLevelMemberLanguageDialog(int n2) {
                        String string = LanguageCellEditor.this.ctf.getText();
                        DimensionLevelObjectEditorPanel.this.languageEditor.clearEditorText();
                        DimensionLevelObjectEditorPanel.this.languageEditor.setText(string);
                        String string2 = SyntaxBuilderLauncher.spawnDialog(DimensionLevelObjectEditorPanel.this.languageEditor.getEditorPanel());
                        if (string2 != null) {
                            LanguageCellEditor.this.ctf.setText(string2);
                        } else {
                            LanguageCellEditor.this.ctf.setText(string);
                        }
                        if (LanguageCellEditor.this.ctf.getText().length() > 0) {
                            LanguageCellEditor.super.setCompletionPopupHandlerStatus(LanguageCellEditor.this.ctf.getText());
                        }
                    }
                });
                jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
                return jPanel;
            }
            return this.getComponent();
        }

        @Override
        public boolean stopCellEditing() {
            TableColumnModel tableColumnModel;
            TableColumn tableColumn;
            int n;
            if (this.jtable != null && (n = (tableColumn = (tableColumnModel = this.jtable.getColumnModel()).getColumn(this.column)).getModelIndex()) == 1) {
                String string = this.ctf.getText();
                if (string.isEmpty()) {
                    this.ctf.setText(NONE);
                } else if (string.indexOf(" ") > -1) {
                    String string2 = string.trim();
                    if (string2.isEmpty()) {
                        this.ctf.setText(NONE);
                    } else if (!(UIStringUtils.isCharTypeExpressionBasedOnCaseOrFunction(string2) || UIStringUtils.isQuotedName(string.trim()) || UIStringUtils.isSingleQuotedLiteral(string.trim()))) {
                        if (!(string = string.trim()).startsWith("'")) {
                            string = "'" + string;
                        }
                        if (!string.endsWith("'")) {
                            string = string + "'";
                        }
                        String string3 = string.substring(1, string.length() - 1);
                        string3 = string3.replace("'", "''");
                        string = "'" + string3 + "'";
                        this.ctf.setText(string);
                    }
                }
            }
            return super.stopCellEditing();
        }
    }

    static enum KeyType {
        KEY,
        ALTERNATE_KEY,
        MEMBER_NAME,
        MEMBER_CAPTION,
        MEMBER_DESCRIPTION,
        DETERMINES;

    }
}

