/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension;

import java.util.HashMap;
import oracle.hcs.HCSArb;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.util.SourceValidator;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class DimensionValidator
extends SchemaObjectValidator<AttributeDimension>
implements SourceValidator {
    private String schemaName;
    private String objectName;
    private String objectType;
    private SourceMetadata sourceMetaData;
    private final String SOURCE_QUERY_XML_FILE = "sourcequeries.xml";
    private OracleDatabaseImpl db = (OracleDatabaseImpl)this.getProvider();

    public DimensionValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObjectProperty(AttributeDimension attributeDimension, AttributeDimension attributeDimension2, String string) throws ValidationException {
        if (attributeDimension2.isSkipValidation()) {
            return;
        }
        if (string.equalsIgnoreCase("caption")) {
            return;
        }
        if (string.toLowerCase().indexOf("description") != -1) {
            return;
        }
        super.validateObjectProperty((DBObject)attributeDimension, (DBObject)attributeDimension2, string);
    }

    @DBObjectValidator.PropertyValidator(value={"attributes"})
    public void validateAttributes(AttributeDimension attributeDimension, AttributeDimension attributeDimension2) throws ValidationException {
        int n = attributeDimension2.getAttributes().length;
        if (n == 0) {
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATION_ERROR_NO_ATTRIBUTES"));
        }
        for (DimensionAttribute dimensionAttribute : attributeDimension2.getAttributes()) {
            if (dimensionAttribute.getMapExpression() != null && !dimensionAttribute.getMapExpression().trim().isEmpty()) continue;
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.format("VALIDATION_ERROR_INVALID_ATTRIBUTE_MAPPING", dimensionAttribute.getName()));
        }
        HashMap hashMap = new HashMap();
        for (DimensionAttribute dimensionAttribute : attributeDimension2.getAttributes()) {
            if (hashMap.containsKey(dimensionAttribute.getName())) {
                throw new ValidationException((DBObject)attributeDimension2, HCSArb.format("VALIDATION_ERROR_DUPLICATE_ATTRIBUTE_NAME_MSG", dimensionAttribute.getName()));
            }
            hashMap.put(dimensionAttribute.getName(), dimensionAttribute.getName());
        }
        boolean bl = false;
        int n2 = 0;
        for (DimensionAttribute dimensionAttribute : attributeDimension2.getAttributes()) {
            String string = dimensionAttribute.getRole();
            if (string == null) continue;
            if (string.equalsIgnoreCase("LONG_DESCRIPTION")) {
                if (bl) {
                    throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATE_ATTRIBUTE_ERROR_TOO_MANY_LONG_DESC"));
                }
                bl = true;
                continue;
            }
            if (!string.equalsIgnoreCase("SHORT_DESCRIPTION")) continue;
            if (n2 == 1) {
                throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATE_ATTRIBUTE_ERROR_TOO_MANY_SHORT_DESC"));
            }
            n2 = 1;
        }
    }

    @DBObjectValidator.PropertyValidator(value={"levels"})
    public void validateLevels(AttributeDimension attributeDimension, AttributeDimension attributeDimension2) throws ValidationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (DimensionLevel dimensionLevel : attributeDimension2.getLevels()) {
            if (hashMap.containsKey(dimensionLevel.getName())) {
                throw new ValidationException((DBObject)attributeDimension2, HCSArb.format("VALIDATION_ERROR_DUPLICATE_LEVEL_NAME_MSG", dimensionLevel.getName()));
            }
            hashMap.put(dimensionLevel.getName(), dimensionLevel.getName());
        }
        for (DimensionLevel dimensionLevel : attributeDimension2.getLevels()) {
            String object;
            if (dimensionLevel.getLevelKey() == null || !dimensionLevel.getLevelKey().matches(".*[a-zA-Z]+.*")) {
                throw new ValidationException((DBObject)attributeDimension2, HCSArb.format("VALIDATION_ERROR_MAPPING_EXPRESSION_MSG", dimensionLevel.getName()));
            }
            if (!attributeDimension2.isTime() || (object = dimensionLevel.getLevelType()) != null && !object.isEmpty() && !object.equalsIgnoreCase("STANDARD")) continue;
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.format("VALIDATION_ERROR_INVALID_LEVEL_TYPE", dimensionLevel.getName()));
        }
        boolean bl = false;
        for (DimensionLevel dimensionLevel : attributeDimension2.getLevels()) {
            if (dimensionLevel.getLevelSkipNullValues()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATION_ERROR_SKIP_NULL_VALUES"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"sources"})
    public void validateDimensionSources(AttributeDimension attributeDimension, AttributeDimension attributeDimension2) throws ValidationException {
        DatabaseSource[] databaseSourceArray = attributeDimension2.getSources();
        boolean bl = attributeDimension2.isForceCreate();
        if (databaseSourceArray == null || databaseSourceArray.length == 0) {
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATION_ERROR_DIMENSION_MISSING_SOURCE_TABLE"));
        }
        this.setSchemaName(attributeDimension2.getSchema().getName());
        this.setObjectName(attributeDimension2.getName());
        this.setObjectType(attributeDimension2.getType());
        this.setSourceMetadata();
        String string = databaseSourceArray[0].getQualifiedName();
        String string2 = this.validateSource(string);
        if (!bl && string2 != null) {
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATION_ERROR_DIMENSION_INVALID_SOURCE_TABLE"));
        }
    }

    private void setSchemaName(String string) {
        this.schemaName = string;
    }

    private void setObjectName(String string) {
        this.objectName = string;
    }

    private void setObjectType(String string) {
        this.objectType = string;
    }

    private void setSourceMetadata() {
        this.sourceMetaData = new SourceMetadata("sourcequeries.xml", this.db.getConnection());
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getUpdObjectName() {
        return this.objectName;
    }

    @Override
    public String getUpdObjectType() {
        return this.objectType;
    }

    @Override
    public SourceMetadata getSourceMetadata() {
        return this.sourceMetaData;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    @DBObjectValidator.PropertyValidator(value={"allMemberName"})
    public void validateDimensionAllMemberName(AttributeDimension attributeDimension, AttributeDimension attributeDimension2) throws ValidationException {
        String string = attributeDimension2.getAllMemberName();
        if (string == null || string.isEmpty()) {
            throw new ValidationException((DBObject)attributeDimension2, HCSArb.getString("VALIDATION_ERROR_DIMENSION_ALL_MEMBER_NAME_REQUIRED_MSG"));
        }
    }

    private boolean isAllMemberNameValid(String string) {
        return string.startsWith("'") && string.endsWith("'");
    }
}

