/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.model.cache;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AbstractAVNavigatorCacheModelNode;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.javatools.db.DBObjectProvider;

public class AVCacheLevelGroupNode
extends AbstractAVNavigatorCacheModelNode {
    private DBObjectProvider prov;
    private AnalyticView analyticView;
    private List<String> levelTuple = new ArrayList<String>();
    private String levelGroupProcessMode = "MATERIALIZED";
    public static final String MATERIALIZED = "MATERIALIZED";
    public static final String DYNAMIC = "DYNAMIC";

    public AVCacheLevelGroupNode(DBObjectProvider dBObjectProvider, Object object, AnalyticView analyticView) {
        super("LevelsNodeType", object);
        this.prov = dBObjectProvider;
        this.analyticView = analyticView;
        this.setLevelTuple(this.getInitialLevelTuple());
    }

    public void setLevelTuple(List<String> list) {
        this.levelTuple = list;
    }

    public List<String> getLevelTuple() {
        return this.levelTuple;
    }

    public void setLevelGroupProcessMode(String string) {
        this.levelGroupProcessMode = string;
    }

    public String getLevelGroupProcessMode() {
        return this.levelGroupProcessMode;
    }

    public static String getDimensionHierarchyAlias(String string) {
        String string2 = null;
        IdentifierElement identifierElement = new IdentifierElement(string, true);
        string2 = identifierElement.getFirst() + "." + identifierElement.getSecond();
        return string2;
    }

    public static String getLevelName(String string) {
        String string2 = null;
        IdentifierElement identifierElement = new IdentifierElement(string, true);
        if (identifierElement.getCount() == 3) {
            string2 = identifierElement.getThird();
        }
        return string2;
    }

    public List<String> getLevelNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IdentifierElement identifierElement = new IdentifierElement(string, false);
        String string2 = identifierElement.getFirst();
        String string3 = identifierElement.getSecond();
        AVDimensionality aVDimensionality = this.analyticView.findDimensionalityForAlias(string2);
        AVHierarchy aVHierarchy = aVDimensionality.findHierarchyByAlias(string3);
        Hierarchy hierarchy = aVHierarchy.getHierarchy();
        for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
            String string4 = hierarchyLevel.getLevelName();
            string4 = this.prov.getExternalName(string4);
            arrayList.add(string4);
        }
        return arrayList;
    }

    private List<String> getInitialLevelTuple() {
        String string = this.getNextAvailableDimensionHierarchyAlias() + "." + this.getNextAvailableLevelName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return arrayList;
    }

    public String getNextAvailableDimensionHierarchyAlias() {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AVDimensionality aVDimensionality : this.analyticView.getDimensions()) {
            String string2 = aVDimensionality.getDimensionAlias();
            string2 = this.prov.getExternalName(string2);
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                String string3 = aVHierarchy.getHierarchyAlias();
                string3 = this.prov.getExternalName(string3);
                arrayList.add(string2 + "." + string3);
            }
        }
        for (String string4 : this.levelTuple) {
            String string5 = AVCacheLevelGroupNode.getDimensionHierarchyAlias(string4);
            arrayList.remove(string5);
        }
        if (arrayList.size() > 0) {
            string = (String)arrayList.get(0);
        }
        return string;
    }

    public String getNextAvailableLevelName() {
        List<String> list = this.getLevelNames(this.getNextAvailableDimensionHierarchyAlias());
        String string = list.get(0);
        return string;
    }
}

