/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.model;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.db.DBStringUtils;
import oracle.hcs.db.model.Classification;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.dimension.DimensionLevelsSorter;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.property.Internal;

public class AVDimensionality
extends AbstractChildDBObject
implements NamedObject,
Descriptions {
    public static final String TYPE = "HDIMENSIONALITY";

    public AVDimensionality() {
        this.setSparse(true);
    }

    public AVDimensionality(AttributeDimension attributeDimension) {
        super(attributeDimension.getName());
        this.setDimension(attributeDimension);
        this.setDimensionalityName(attributeDimension.getName());
        this.setDimensionAlias(attributeDimension.getName());
        this.setSparse(true);
    }

    public String getType() {
        return TYPE;
    }

    public void setDimensionalityName(String string) {
        this.setProperty("dimensionalityName", string);
    }

    public String getDimensionalityName() {
        return (String)this.getProperty("dimensionalityName");
    }

    @Internal
    public void setDimension(AttributeDimension attributeDimension) {
        this.setProperty("dimension", attributeDimension);
    }

    @Internal
    public AttributeDimension getDimension() {
        return (AttributeDimension)this.getProperty("dimension");
    }

    public void addMapExpression(String string) {
        this.getChildSupport("mapExpression").addChild((Object)string);
    }

    public void setMapExpressions(String[] stringArray) {
        this.getChildSupport("mapExpression").setChildArray((Object[])stringArray);
    }

    public String[] getMapExpressions() {
        return (String[])this.getChildSupport("mapExpression").getChildArray(String.class);
    }

    public String getMapExpressionClause() {
        String[] stringArray = this.getMapExpressions();
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string = "(";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    public void setMappedDimensions(String[] stringArray) {
        this.getChildSupport("mappedDimension").setChildArray((Object[])stringArray);
    }

    public void addMappedDimension(String string) {
        this.getChildSupport("mappedDimension").addChild((Object)string);
    }

    public String[] getMappedDimensions() {
        return (String[])this.getChildSupport("mappedDimension").getChildArray(String.class);
    }

    public String getMappedDimensionClause() {
        String[] stringArray = this.getMappedDimensions();
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string = "(";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    public void setMapJoinCondition(String string) {
        this.setProperty("mapJoinCondition", string);
    }

    public String getMapJoinCondition() {
        return (String)this.getProperty("mapJoinCondition");
    }

    public Integer getPhysicalOrder() {
        Integer n = (Integer)this.getProperty("dimOrder");
        return n;
    }

    public void setPhysicalOrder(int n) {
        this.setProperty("dimOrder", n);
    }

    public boolean isSparse() {
        return (Boolean)this.getProperty("dimIsSparse");
    }

    public void setSparse(boolean bl) {
        this.setProperty("dimIsSparse", bl);
    }

    public void setDimensionAlias(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        this.setProperty("dimensionAlias", string);
    }

    public String getDimensionAlias() {
        Object object = this.getProperty("dimensionAlias");
        return (String)object;
    }

    public AVHierarchy[] getHierarchies() {
        return (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class);
    }

    public void removeHierarchy(AVHierarchy aVHierarchy) {
        this.getChildSupport("hierarchies").removeChild((Object)aVHierarchy);
    }

    public void removeAllHierarchies() {
        this.getChildSupport("hierarchies").clearChildren();
    }

    public void setHierarchies(AVHierarchy[] aVHierarchyArray) {
        this.getChildSupport("hierarchies").setChildArray((Object[])aVHierarchyArray);
    }

    public void addHierarchy(AVHierarchy aVHierarchy) {
        this.getChildSupport("hierarchies").addChild((Object)aVHierarchy);
    }

    public AVHierarchy findHierarchy(String string) {
        AVHierarchy[] aVHierarchyArray;
        for (AVHierarchy aVHierarchy : aVHierarchyArray = (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class)) {
            if (!aVHierarchy.getName().equals(string)) continue;
            return aVHierarchy;
        }
        return null;
    }

    public AVHierarchy findHierarchyByAlias(String string) {
        AVHierarchy[] aVHierarchyArray;
        for (AVHierarchy aVHierarchy : aVHierarchyArray = (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class)) {
            if (!aVHierarchy.getHierarchyAlias().equals(string) || !aVHierarchy.isHierarchyIncluded()) continue;
            return aVHierarchy;
        }
        return null;
    }

    public String getHierarchyAlias(String string) {
        AVHierarchy[] aVHierarchyArray;
        for (AVHierarchy aVHierarchy : aVHierarchyArray = (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class)) {
            if (!aVHierarchy.getName().equals(string)) continue;
            return aVHierarchy.getHierarchyAlias();
        }
        return null;
    }

    public boolean isValidHierarchyAlias(String string) {
        AVHierarchy[] aVHierarchyArray;
        for (AVHierarchy aVHierarchy : aVHierarchyArray = (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class)) {
            if (!aVHierarchy.getHierarchyAlias().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultHierarchyName() {
        AVHierarchy[] aVHierarchyArray;
        for (AVHierarchy aVHierarchy : aVHierarchyArray = (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class)) {
            if (!aVHierarchy.isHierarchyDefault()) continue;
            return aVHierarchy.getHierarchyName();
        }
        return null;
    }

    public AVHierarchy getDefaultHierarchy() {
        AVHierarchy[] aVHierarchyArray;
        for (AVHierarchy aVHierarchy : aVHierarchyArray = (AVHierarchy[])this.getChildSupport("hierarchies").getChildArray(AVHierarchy.class)) {
            if (!aVHierarchy.isHierarchyDefault()) continue;
            return aVHierarchy;
        }
        return null;
    }

    public DimensionLevel[] getSortedLevels(List<Hierarchy> list) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        String string = this.getName();
        ArrayList<Hierarchy> arrayList2 = new ArrayList<Hierarchy>();
        for (AVHierarchy object : this.getHierarchies()) {
            HierarchyLevel[] hierarchyLevelArray = object.getHierarchyName();
            Hierarchy hierarchy = null;
            for (Hierarchy hierarchy2 : list) {
                String string2;
                String string3 = hierarchy2.getName();
                String string4 = string2 = hierarchy2.getDimension() != null ? hierarchy2.getDimension().getName() : "";
                if (!string3.equals(hierarchyLevelArray) && !string.equals(string2)) continue;
                hierarchy = hierarchy2;
                arrayList2.add(hierarchy);
            }
        }
        for (Hierarchy hierarchy : arrayList2) {
            int n = 1;
            if (n == 0) continue;
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                arrayList3.add(hierarchyLevel.getLevel().getName());
            }
            arrayList.add(arrayList3);
        }
        DimensionLevel[] dimensionLevelArray = DimensionLevelsSorter.getSortedLevels(arrayList, arrayList2);
        return dimensionLevelArray;
    }

    public DimensionAttribute[] getSortedAttributes(DimensionLevel[] dimensionLevelArray) {
        AttributeDimension attributeDimension = null;
        if (dimensionLevelArray.length > 0) {
            attributeDimension = this.getDimension();
        }
        List<Object> list = new ArrayList();
        if (attributeDimension != null) {
            list = this.findDimensionAttributes(attributeDimension, dimensionLevelArray);
            for (DimensionAttribute dimensionAttribute : attributeDimension.getAttributes()) {
                if (list.contains(dimensionAttribute)) continue;
                list.add(dimensionAttribute);
            }
        }
        return list.toArray(new DimensionAttribute[list.size()]);
    }

    public DimensionAttribute getLeafAttribute(DimensionLevel[] dimensionLevelArray) {
        AttributeDimension attributeDimension = null;
        if (dimensionLevelArray.length > 0) {
            attributeDimension = this.getDimension();
        }
        List<Object> list = new ArrayList();
        if (attributeDimension != null) {
            list = this.findDimensionAttributes(attributeDimension, dimensionLevelArray);
        }
        if (list.size() > 0) {
            return (DimensionAttribute)list.get(list.size() - 1);
        }
        return null;
    }

    private List<DimensionAttribute> findDimensionAttributes(AttributeDimension attributeDimension, DimensionLevel[] dimensionLevelArray) {
        ArrayList<DimensionAttribute> arrayList = new ArrayList<DimensionAttribute>();
        for (DimensionLevel dimensionLevel : dimensionLevelArray) {
            String[] stringArray;
            if ((dimensionLevel = attributeDimension.findLevel(dimensionLevel.getName())) == null) continue;
            String string = dimensionLevel.getLevelKey();
            string = string.replaceAll("[()]", "");
            for (String string2 : stringArray = string.split(",")) {
                DimensionAttribute dimensionAttribute = attributeDimension.findAttribute(string2);
                if (dimensionAttribute == null) continue;
                arrayList.add(dimensionAttribute);
            }
        }
        return arrayList;
    }

    @Override
    public String getExternalName() {
        return DBStringUtils.externalizeName(this.getName());
    }

    @Override
    public void addClassification(Classification classification) {
        this.getChildSupport("classifications").addChild((Object)classification);
    }

    @Override
    public Classification[] getClassifications() {
        return (Classification[])this.getChildSupport("classifications").getChildArray(Classification.class);
    }

    public void setClassifications(Classification[] classificationArray) {
        this.getChildSupport("classifications").setChildArray((Object[])classificationArray);
    }

    @Override
    public void removeClassifications(Classification classification) {
        this.getChildSupport("classifications").removeChild((Object)classification);
    }

    @Override
    public void setDescription(String string) {
        this.setProperty("description", string);
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty("description");
    }

    @Override
    public void setCaption(String string) {
        this.setProperty("caption", string);
    }

    @Override
    public String getCaption() {
        return (String)this.getProperty("caption");
    }
}

