/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.db.model.Classification;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.NamedObject;
import oracle.javatools.db.DBObjectProvider;

public class DescriptionsNode {
    private List<Object> children;
    private DBObjectProvider prov;
    private Classification classification;
    private Descriptions descriptionObject;
    private String parentDescObjName;
    private boolean isRoot;
    private boolean isTopObject;
    private boolean isParent;
    private boolean isObjectNew;

    public DescriptionsNode(DBObjectProvider dBObjectProvider, Classification classification, Descriptions descriptions) {
        this.prov = dBObjectProvider;
        this.classification = classification;
        this.descriptionObject = descriptions;
        this.setParentDescObjName();
        this.children = new ArrayList<Object>();
    }

    public DescriptionsNode addDescriptionsNode(Descriptions descriptions, boolean bl) {
        DescriptionsNode descriptionsNode = new DescriptionsNode(this.prov, null, descriptions);
        descriptionsNode.setIsTopObject(bl);
        descriptionsNode.setIsParent(true);
        this.children.add(descriptionsNode);
        return descriptionsNode;
    }

    public void addDescriptionsNode(Classification classification, Descriptions descriptions, boolean bl) {
        DescriptionsNode descriptionsNode = new DescriptionsNode(this.prov, classification, descriptions);
        descriptionsNode.setIsParent(false);
        descriptionsNode.setIsObjectNew(bl);
        this.children.add(descriptionsNode);
    }

    public void removeDescriptionsNode(DescriptionsNode descriptionsNode) {
        this.getChildren().remove(descriptionsNode);
    }

    protected List<Object> getChildren() {
        return this.children;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public String getParentObjName() {
        return this.parentDescObjName;
    }

    public void setParentDescObjName() {
        if (this.descriptionObject != null) {
            NamedObject namedObject = (NamedObject)((Object)this.descriptionObject);
            this.parentDescObjName = namedObject.getName();
        }
    }

    public Descriptions getParentDescriptionObject() {
        return this.descriptionObject;
    }

    public String getClassificationType() {
        if (this.classification != null) {
            return this.classification.getClassificationType();
        }
        return "";
    }

    public String getClassificationValue() {
        if (this.classification != null) {
            return this.classification.getValue();
        }
        return "";
    }

    public Classification getClassification() {
        return this.classification;
    }

    private void setIsParent(boolean bl) {
        this.isParent = bl;
    }

    public boolean isParent() {
        return this.isParent;
    }

    private void setIsTopObject(boolean bl) {
        this.isTopObject = bl;
    }

    public boolean isTopObject() {
        return this.isTopObject;
    }

    public boolean isObjectNew() {
        return this.isObjectNew;
    }

    public void setIsObjectNew(boolean bl) {
        this.isObjectNew = bl;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setIsRoot(boolean bl) {
        this.isRoot = bl;
    }

    public String toString() {
        if (!this.isRoot && !this.isParent()) {
            return this.getClassificationType();
        }
        return this.parentDescObjName;
    }
}

