/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.CompilationResultsDialog;
import oracle.hcs.actions.CompilationResultsPanel;
import oracle.hcs.actions.CompileHCSObjectAction;
import oracle.hcs.actions.CompileMultipleObjectsConfirmPanel;
import oracle.hcs.actions.XMLMultipleObjectsQueryBasedActionHelper;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.NamedObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.Database;

public class CompileMultipleObjectsAction
extends CompileHCSObjectAction {
    private static final String COMPILE_OBJECT_SQL = "compileObject";
    private List<DBObject> selection;
    private String compilePaneTitleLabel;
    private String compileResultsPaneTitle;
    private String confirmCompileTableTitle;
    private String objectType;
    private String owner;
    private List<NamedObjectWithDesc> namedObjects;

    private void initObjectsForCompileAction(HCSSchema hCSSchema) {
        block4: {
            block5: {
                block3: {
                    this.namedObjects = new ArrayList<NamedObjectWithDesc>();
                    if (!this.objectType.equals("ATTRIBUTE DIMENSION")) break block3;
                    this.confirmCompileTableTitle = HCSArb.get("MULTIPLE_ATTRIBUTE_DIMENSIONS_CONFIRM_TABLE_TITLE");
                    this.compileResultsPaneTitle = HCSArb.get("COMPILE_MULTIPLE_ATTR_DIMS_DIALOG_TITLE");
                    this.compilePaneTitleLabel = HCSArb.get("COMPILE_MULTIPLE_ATTR_DIMS_CONFIRM_TITLE");
                    for (DBObject dBObject : this.selection) {
                        AttributeDimension attributeDimension = hCSSchema.findDimension(dBObject.getObjectName());
                        if (attributeDimension == null) continue;
                        this.namedObjects.add(attributeDimension);
                    }
                    break block4;
                }
                if (!this.objectType.equals("HIERARCHY")) break block5;
                this.confirmCompileTableTitle = HCSArb.get("MULTIPLE_HIERARCHIES_CONFIRM_TABLE_TITLE");
                this.compileResultsPaneTitle = HCSArb.get("COMPILE_MULTIPLE_HIERS_DIALOG_TITLE");
                this.compilePaneTitleLabel = HCSArb.get("COMPILE_MULTIPLE_HIERS_CONFIRM_TITLE");
                for (DBObject dBObject : this.selection) {
                    Hierarchy hierarchy = hCSSchema.findHierarchy(dBObject.getObjectName());
                    if (hierarchy == null) continue;
                    this.namedObjects.add(hierarchy);
                }
                break block4;
            }
            if (!this.objectType.equals("ANALYTIC VIEW")) break block4;
            this.confirmCompileTableTitle = HCSArb.get("MULTIPLE_ANALYTIC_VIEWS_CONFIRM_TABLE_TITLE");
            this.compileResultsPaneTitle = HCSArb.get("COMPILE_MULTIPLE_AVS_DIALOG_TITLE");
            this.compilePaneTitleLabel = HCSArb.get("COMPILE_MULTIPLE_AVS_CONFIRM_TITLE");
            for (DBObject dBObject : this.selection) {
                AnalyticView analyticView = hCSSchema.findAV(dBObject.getObjectName());
                if (analyticView == null) continue;
                this.namedObjects.add(analyticView);
            }
        }
    }

    public void showObjectCompilationResultsPanel() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompilationResultsPanel compilationResultsPanel = new CompilationResultsPanel(((DBObject)CompileMultipleObjectsAction.this.selection.get(0)).getSchemaName(), CompileMultipleObjectsAction.this.selection, HCSArb.getString("COMPILE_RESULTS_LABEL"));
                CompilationResultsDialog compilationResultsDialog = new CompilationResultsDialog(CompileMultipleObjectsAction.this.compileResultsPaneTitle, compilationResultsPanel, ((DBObject)CompileMultipleObjectsAction.this.selection.get(0)).getSchemaName(), CompileMultipleObjectsAction.this.selection);
                compilationResultsDialog.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    protected void actionPostProcess() {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.refreshNavigator(this.selection.get(0));
        }
        this.showObjectCompilationResultsPanel();
    }

    protected void refreshNavigator(DBObject dBObject) {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReloadParent(true);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        objectActionPostProcess.run();
    }

    protected void setSelection(List<DBObject> list) {
        this.selection = list;
    }

    @Override
    protected AlterHCSObjectHelper getHelper() throws Exception {
        if (this.selection != null && !this.selection.isEmpty()) {
            DBObject dBObject = this.selection.get(0);
            Connection connection = dBObject.getConnection();
            Database database = dBObject.getDatabase();
            this.objectType = dBObject.getObjectType();
            this.owner = dBObject.getSchemaName();
            HCSSchema hCSSchema = this.getSchema();
            this.initObjectsForCompileAction(hCSSchema);
            this.actionHelper = new CompileMultipleObjectsHelper(this.selection, database, connection, this.objectType);
        }
        return this.actionHelper;
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        CompileMultipleObjectsConfirmPanel compileMultipleObjectsConfirmPanel = null;
        if (this.namedObjects != null && !this.namedObjects.isEmpty()) {
            compileMultipleObjectsConfirmPanel = new CompileMultipleObjectsConfirmPanel(this.namedObjects, this.owner, this.objectType, this.confirmCompileTableTitle);
        }
        return compileMultipleObjectsConfirmPanel;
    }

    private class CompileMultipleObjectsHelper
    extends XMLMultipleObjectsQueryBasedActionHelper {
        public CompileMultipleObjectsHelper(List<DBObject> list, Database database, Connection connection, String string) {
            super(list, connection, database, string);
        }

        @Override
        public String getTitle() {
            return CompileMultipleObjectsAction.this.compilePaneTitleLabel;
        }

        @Override
        protected List<String> initSQLStatements() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DBObject dBObject : this.getDBObjectsList()) {
                String string = dBObject.getObjectName();
                String string2 = String.format(this.getQuery(CompileMultipleObjectsAction.COMPILE_OBJECT_SQL), this.getObjectType(), CompileMultipleObjectsAction.this.owner, string);
                arrayList.add(string2);
            }
            return arrayList;
        }
    }
}

