/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.navigator.db.EditableTypesRegistry;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.hcs.HCSArb;
import oracle.hcs.HCSObjectCheck;
import oracle.hcs.av.AVBuilder;
import oracle.hcs.av.AVLister;
import oracle.hcs.av.AVPanelLibrary;
import oracle.hcs.av.AVValidator;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.HCSBundleDDLGenerator;
import oracle.hcs.db.model.Classification;
import oracle.hcs.ddl.AnalyticViewDDL;
import oracle.hcs.ddl.AttributeDimensionDDL;
import oracle.hcs.ddl.HierarchyDDL;
import oracle.hcs.dimension.DimensionBuilder;
import oracle.hcs.dimension.DimensionLister;
import oracle.hcs.dimension.DimensionPanelLibrary;
import oracle.hcs.dimension.DimensionValidator;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.model.DimensionMap;
import oracle.hcs.dimension.model.OrderByClause;
import oracle.hcs.hierarchy.HierarchyBuilder;
import oracle.hcs.hierarchy.HierarchyLister;
import oracle.hcs.hierarchy.HierarchyPanelLibrary;
import oracle.hcs.hierarchy.HierarchyValidator;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.ide.Addin;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBTypeDisplayRegistryEntry;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.db.ora.Oracle12c;

public final class HCSAddin
implements Addin {
    private static final String ORACLE = "Oracle";

    public void initialize() {
        HCSAddin.registerDBObjects();
        EditableTypesRegistry.addEditableType((String)"ATTRIBUTE DIMENSION");
        EditableTypesRegistry.addEditableType((String)"HIERARCHY");
        EditableTypesRegistry.addEditableType((String)"ANALYTIC VIEW");
        PermissionRegistry.registerHandler((String)ORACLE, (String)"ATTRIBUTE DIMENSION", HCSObjectCheck.class);
        PermissionRegistry.registerHandler((String)ORACLE, (String)"HIERARCHY", HCSObjectCheck.class);
        PermissionRegistry.registerHandler((String)ORACLE, (String)"ANALYTIC VIEW", HCSObjectCheck.class);
        DDLTypes.registerDDLType((String)"ATTRIBUTE DIMENSION", (String)HCSArb.getString("EXPORT_LABEL_ATTRIBUTE_DIMENSION"), (boolean)true);
        DDLTypes.registerDDLType((String)"HIERARCHY", (String)HCSArb.getString("EXPORT_LABEL_HIERARCHY"), (boolean)true);
        DDLTypes.registerDDLType((String)"ANALYTIC VIEW", (String)HCSArb.getString("EXPORT_LABEL_ANALYTIC_VIEW"), (boolean)true);
        String string = "ATTRIBUTE DIMENSION";
        DDLRegistry.registerHandler((String)ORACLE, (String)string.replaceAll(" ", "_"), AttributeDimensionDDL.class);
        DDLRegistry.registerHandler((String)ORACLE, (String)"HIERARCHY", HierarchyDDL.class);
        string = "ANALYTIC VIEW";
        DDLRegistry.registerHandler((String)ORACLE, (String)string.replaceAll(" ", "_"), AnalyticViewDDL.class);
    }

    public static void registerDBObjects() {
        DatabaseMatcher databaseMatcher = new DatabaseMatcher("Oracle Database", 120, DatabaseMatcher.Comparison.MINIMUM);
        DBObjectRegistry.getInstance().registerClass("ATTRIBUTE DIMENSION", AttributeDimension.class);
        DBObjectRegistry.getInstance().registerClass("DIMENSION LEVEL", DimensionLevel.class);
        DBObjectRegistry.getInstance().registerClass("HIERARCHY", Hierarchy.class);
        DBObjectRegistry.getInstance().registerClass("DIMENSION ATTRIBUTE", DimensionAttribute.class);
        DBObjectRegistry.getInstance().registerClass("DIMENSION MAP", DimensionMap.class);
        DBObjectRegistry.getInstance().registerObject("ATTRIBUTE DIMENSION", databaseMatcher, DimensionValidator.class, DimensionBuilder.class, DimensionLister.class, HCSBundleDDLGenerator.class);
        DBObjectRegistry.getInstance().registerObject("HIERARCHY", databaseMatcher, HierarchyValidator.class, HierarchyBuilder.class, HierarchyLister.class, HCSBundleDDLGenerator.class);
        DBObjectRegistry.getInstance().registerClass("ANALYTIC VIEW", AnalyticView.class);
        DBObjectRegistry.getInstance().registerClass("HDIMENSIONALITY", AVDimensionality.class);
        DBObjectRegistry.getInstance().registerClass("MEASURE2", AVMeasure.class);
        DBObjectRegistry.getInstance().registerClass("CALCULATED_MEASURE2", AVCalculatedMeasure.class);
        DBObjectRegistry.getInstance().registerClass("LEVEL_ORDER_BY_CLAUSE", OrderByClause.class);
        DBObjectRegistry.getInstance().registerClass("CLASSIFICATION", Classification.class);
        DBObjectRegistry.getInstance().registerObject("ANALYTIC VIEW", databaseMatcher, AVValidator.class, AVBuilder.class, AVLister.class, HCSBundleDDLGenerator.class);
        OracleDBEditorFactory oracleDBEditorFactory = (OracleDBEditorFactory)DBEditorFactoryRegistry.findFactory(Oracle12c.class);
        if (oracleDBEditorFactory == null) {
            Logger.getLogger(HCSAddin.class.getClass().getName()).log(Level.WARNING, "OracleDBEditorFactory not found.");
        } else {
            oracleDBEditorFactory.registerLibrary("ATTRIBUTE DIMENSION", DimensionPanelLibrary.class);
            oracleDBEditorFactory.registerLibrary("HIERARCHY", HierarchyPanelLibrary.class);
            oracleDBEditorFactory.registerLibrary("ANALYTIC VIEW", AVPanelLibrary.class);
            DBTypeDisplayRegistry.addDBTypeRegistry((DBTypeDisplayRegistryEntry)new DBTypeDisplayRegistryEntry(){

                protected void populateEntries() {
                    this.registerType("ATTRIBUTE DIMENSION", null, null, HCSArb.get("DIMENSION_NEW_MENU_TEXT"), null, HCSNavigatorResource.getIcon("DIMENSION_ICON"));
                    this.registerType("HIERARCHY", null, null, HCSArb.get("HIERARCHY_NEW_MENU_TEXT"), null, HCSNavigatorResource.getIcon("HIERARCHY_ICON"));
                    this.registerType("ANALYTIC VIEW", null, null, HCSArb.get("AV_NEW_MENU_TEXT"), null, HCSNavigatorResource.getIcon("AV_ICON"));
                }
            });
        }
    }
}

