/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.headless;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployCloudUtil;
import oracle.dbtools.dbcart.config.DbCartUserCloudConfig;
import oracle.dbtools.dbcart.headless.DbCartCommand;
import oracle.dbtools.dbcart.headless.DbCartHeadlessResources;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.sftp.SftpUtil;

public class DbCartDeployCloudCommand
extends DbCartCommand {
    private DDLFormat _ddlFormat = new DDLFormat();
    private ExtractDataFormat _dataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD);
    private TargetFormat _targetFormat = new TargetFormat(2, 1, false);
    private String _connName;
    private String _title;

    public DbCartDeployCloudCommand(HeadlessCore headlessCore) {
        super(DbCartCommand.Type.CLOUD, headlessCore);
    }

    @Override
    public String getHelpKey() {
        return "HELP_STRING_CART_CLOUD";
    }

    @Override
    public boolean processToolItem(String string, List<String> list) throws InvalidCommandArgumentException {
        if ("TARGET".equalsIgnoreCase(string) || "TGT".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this.setTgtFile(list.get(0));
            return true;
        }
        return false;
    }

    @Override
    public void getConfig() throws InvalidCommandArgumentException {
        try {
            URL uRL = new File(this.getConfigXML()).toURI().toURL();
            this._config = new DbCartUserCloudConfig(DbCartUserCloudConfig.importFrom(uRL));
            this.validateConfig(uRL, "deploy_cloud_tool");
            DbCartUserCloudConfig dbCartUserCloudConfig = (DbCartUserCloudConfig)this._config;
            this._connName = dbCartUserCloudConfig.getString("CLOUD_CONN");
            String string = DbCartDeployCloudUtil.validateCloudConn(this._connName);
            if (string != null) {
                throw new InvalidCommandArgumentException(string);
            }
            this._title = this._config.getString("CLOUD_TITLE");
            string = DbCartDeployCloudUtil.validateTitle(this._title);
            if (string != null) {
                throw new InvalidCommandArgumentException(string);
            }
            this._ddlFormat = DbCartDeployCloudUtil.getDDLFormat();
            Boolean bl = dbCartUserCloudConfig.getBoolean("EXPORT_DROP");
            if (bl != null) {
                this._ddlFormat.setDrop(bl.booleanValue());
            }
            if ((bl = dbCartUserCloudConfig.getBoolean("EXPORT_CASCADE")) != null) {
                this._ddlFormat.setCascade(bl.booleanValue());
            }
            FormatRegistry.setLineTerminator((String)System.getProperty("line.separator"));
            FormatRegistry.registerFormater((IResultFormatter)new LoaderFormatter());
            this._dataFormat = DbCartDeployCloudUtil.getDataFormat();
            IFormatOptions iFormatOptions = this._dataFormat.getOptions();
            String string2 = BaseDataFormat.getDelimiterFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getDelimiterConfigKey()));
            if (string2 == null || string2.length() == 0) {
                string2 = iFormatOptions.getDefaultDelimiter();
            }
            boolean bl2 = (bl = dbCartUserCloudConfig.getBoolean(iFormatOptions.getEnclosuresConfigKey())) != null ? bl : false;
            this._dataFormat.setEnclosureLeft(BaseDataFormat.getEnclosureFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getEnclosureLeftConfigKey())));
            this._dataFormat.setEnclosureRight(BaseDataFormat.getEnclosureFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getEnclosureRightConfigKey())));
            this._dataFormat.isEnclosureRightDouble(true);
            String string3 = BaseDataFormat.getRecordTerminatorFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getLineTerminatorConfigKey()));
            if (string3 == null || string3.length() == 0) {
                string3 = DataToolsArb.getString((String)"TERM_OTHER");
            }
            this._targetFormat = DbCartDeployCloudUtil.getTargetFormat();
            this._targetFormat.setSaveAs(this.getTgtFile() != null && this.getTgtFile().length() > 0 ? this.getTgtFile() : this._config.getString("CLOUD_TRANSFER_FILE"));
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            throw new InvalidCommandArgumentException(DbCartAddinArb.format("UNABLE_TO_OPEN_FILE", this.getConfigXML()));
        }
    }

    @Override
    public void validate() throws InvalidCommandArgumentException {
        Object object;
        ResultsFormatter resultsFormatter;
        int n;
        this.validateCart();
        this._ddlFormat.isExtractEnabled(this.isAnyDDLRows());
        this._dataFormat.isExportEnabled(this.isAnyDataRows());
        String string = DbCartDeployCloudUtil.validateForDeploy(this._extractObjects);
        if (string != null) {
            throw new InvalidCommandArgumentException(string);
        }
        if (this._dataFormat.isExportEnabled() && (n = (resultsFormatter = (ResultsFormatter)FormatRegistry.getFormatter((String)this._dataFormat.getFormat())).validateOptions()) != 0) {
            throw new InvalidCommandArgumentException(resultsFormatter.getValidationMessage());
        }
        int n2 = this._targetFormat.validateSaveAs();
        if (n2 != 0) {
            throw new InvalidCommandArgumentException(this._targetFormat.getValidationMessage());
        }
        SftpParms sftpParms = new SftpParms();
        sftpParms.setCloudConnection(this._connName);
        sftpParms.setImportName(this._title);
        sftpParms.setKeyFile(null);
        sftpParms.setLocalFile(this._targetFormat.getSaveAs());
        SessionInfo.SftpInfo sftpInfo = DbCartDeployCloudUtil.getSftpInfo(this._connName);
        if (sftpInfo != null) {
            sftpParms.setUser(sftpInfo.getSftpUser());
            sftpParms.setPass(sftpInfo.getSftpPass());
            sftpParms.setHost(sftpInfo.getSftpHost());
            object = sftpInfo.getSftpHost();
            sftpParms.setPort(sftpInfo.getSftpPort());
        }
        this._targetFormat.setSftpParms(sftpParms);
        object = new SftpUtil();
        boolean bl = object.SftpTestConnection(sftpParms);
        if (!bl) {
            throw new InvalidCommandArgumentException(DbCartAddinArb.format(DbCartAddinArb.getString("BAD_CONN_MESSAGE"), new Object[0]));
        }
    }

    @Override
    public void doCommand() {
        DbCartDeployOptions dbCartDeployOptions = new DbCartDeployOptions();
        dbCartDeployOptions.setSourceExtractObjectList(this._extractObjects);
        dbCartDeployOptions.setTargetFormat(this._targetFormat);
        dbCartDeployOptions.setDDLFormat(this._ddlFormat);
        dbCartDeployOptions.setDataFormat(this._dataFormat);
        ExportAPI exportAPI = new ExportAPI();
        exportAPI.setDeploy(dbCartDeployOptions);
        exportAPI.writeExportHeadless();
    }
}

