/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartController;
import oracle.dbtools.dbcart.DbCartMapConnectionPanel;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.ui.panels.PredicatePanel;
import oracle.dbtools.raptor.extract.ui.panels.ScriptPanel;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.table.ListReorderableTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.TableToolbar;

public class DBCartReorderableTableModel
extends ListReorderableTableModel<ExtractObject> {
    private static final long serialVersionUID = 1L;
    private static final int INCLUDE = 0;
    private static final int TYPE = 1;
    private static final int OWNER = 2;
    private static final int NAME = 3;
    private static final int DDL = 4;
    private static final int DATA = 5;
    private static final int WHERE = 6;
    private static final int SCRIPTS = 7;
    private static final int CONNECTION = 8;
    private static final String[] COL_NAMES = new String[]{DbCartAddinArb.getString("INCLUDE"), DbCartAddinArb.getString("TYPE"), DbCartAddinArb.getString("OWNER"), DbCartAddinArb.getString("NAME"), DbCartAddinArb.getString("DDL"), DbCartAddinArb.getString("DATA"), DbCartAddinArb.getString("WHERE"), DbCartAddinArb.getString("SCRIPTS"), DbCartAddinArb.getString("CONNECTION")};
    private static final String[] COL_TIPS = new String[]{DbCartAddinArb.getString("INCLUDE_TIP"), DbCartAddinArb.getString("TYPE_TIP"), DbCartAddinArb.getString("OWNER_TIP"), DbCartAddinArb.getString("NAME_TIP"), DbCartAddinArb.getString("DDL_TIP"), DbCartAddinArb.getString("DATA_TIP"), DbCartAddinArb.getString("WHERE_TIP"), DbCartAddinArb.getString("SCRIPTS_TIP"), DbCartAddinArb.getString("CONNECTION_TIP")};
    public static final String SCRIPT_FILE_PATH = "DBCART_FILE_PATH";
    private ExtractListModel _extractListModel;
    private TableToolbar _toolbar;
    private GenericTable _table;
    private CheckBoxHeader _includeCheckBoxHeader = new CheckBoxHeader(DbCartAddinArb.getString("INCLUDE"));
    private CheckBoxHeader _ddlCheckBoxHeader = new CheckBoxHeader(DbCartAddinArb.getString("DDL"));
    private CheckBoxHeader _dataCheckBoxHeader = new CheckBoxHeader(DbCartAddinArb.getString("DATA"));
    private IncludeCheckBoxRenderer _includeCheckBoxRenderer = new IncludeCheckBoxRenderer();
    private DdlCheckBoxRenderer _ddlCheckBoxRenderer = new DdlCheckBoxRenderer();
    private DataCheckBoxRenderer _dataCheckBoxRenderer = new DataCheckBoxRenderer();
    private ScriptCellRenderer _scriptCellRenderer = new ScriptCellRenderer();
    private ConnectionCellRenderer _connectionCellRenderer = new ConnectionCellRenderer();
    private StringCellRenderer _stringCellRenderer = new StringCellRenderer();
    private String _saveAs = "";
    private String _saveAsEncoding = "";
    private boolean _deferHandleButtons = false;

    public DBCartReorderableTableModel(ExtractListModel extractListModel) {
        super(COL_NAMES, COL_TIPS);
        this._extractListModel = extractListModel;
        this.setRowList(this._extractListModel.getList(0));
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        this._table = (GenericTable)jTable;
        this.setEditable(true);
        jTable.setDefaultRenderer(URL.class, new URLCellRenderer());
        jTable.setDefaultEditor(String.class, new CustomCellEditor());
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setSelectionMode(2);
        jTable.setCellSelectionEnabled(false);
        jTable.setRowSelectionAllowed(true);
        if (jTable instanceof GenericTable) {
            GenericTable genericTable = (GenericTable)jTable;
            genericTable.setSelectAllEnabled(true);
            genericTable.setColumnSelectorAvailable(true);
        }
        jTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        jTable.getColumnModel().getColumn(3).setPreferredWidth(125);
        jTable.getColumnModel().getColumn(6).setPreferredWidth(125);
        jTable.getColumnModel().getColumn(7).setPreferredWidth(75);
        jTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        jTable.getColumnModel().getColumn(5).setPreferredWidth(50);
        jTable.getColumnModel().getColumn(8).setPreferredWidth(125);
        jTable.getColumnModel().getColumn(0).setHeaderRenderer(this._includeCheckBoxHeader);
        jTable.getTableHeader().addMouseListener(this._includeCheckBoxHeader);
        jTable.getColumnModel().getColumn(4).setHeaderRenderer(this._ddlCheckBoxHeader);
        jTable.getTableHeader().addMouseListener(this._ddlCheckBoxHeader);
        jTable.getColumnModel().getColumn(5).setHeaderRenderer(this._dataCheckBoxHeader);
        jTable.getTableHeader().addMouseListener(this._dataCheckBoxHeader);
        jTable.getColumnModel().getColumn(0).setCellRenderer(this._includeCheckBoxRenderer);
        jTable.getColumnModel().getColumn(4).setCellRenderer(this._ddlCheckBoxRenderer);
        jTable.getColumnModel().getColumn(5).setCellRenderer(this._dataCheckBoxRenderer);
        jTable.getColumnModel().getColumn(7).setCellRenderer(this._scriptCellRenderer);
        jTable.getColumnModel().getColumn(6).setCellRenderer(this._stringCellRenderer);
        jTable.getColumnModel().getColumn(8).setCellRenderer(this._connectionCellRenderer);
    }

    protected Object getValueAt(ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                return new Boolean(extractObject.isPreSelected());
            }
            case 1: {
                return extractObject.getUrl();
            }
            case 2: {
                return extractObject.getUrl();
            }
            case 3: {
                return extractObject.getUrl();
            }
            case 4: {
                return new Boolean(extractObject.isExtractMetaData());
            }
            case 5: {
                return ExtractListModel.isDataObject((DBObject)extractObject.getDBObject()) ? new Boolean(extractObject.isSelectedData()) : new Boolean(false);
            }
            case 6: {
                return ExtractListModel.isDataObject((DBObject)extractObject.getDBObject()) ? extractObject.getWhereString() : "";
            }
            case 7: {
                return "";
            }
            case 8: {
                String string;
                if (extractObject.getSourceConnName() != null && extractObject.getSourceConnName().length() > 0) {
                    Connections.getInstance();
                    string = Connections.getDisplayName((String)Connections.getConnectionName((String)extractObject.getSourceConnName()));
                } else {
                    string = "";
                }
                return string;
            }
        }
        return null;
    }

    protected boolean isCellEditable(ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                return extractObject.getType() != 0 || extractObject.isExistsSource() & (extractObject.isExtractMetaData() || extractObject.isExtractData());
            }
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return !extractObject.isTypeScript();
            }
            case 5: {
                return ExtractListModel.isDataObject((DBObject)extractObject.getDBObject());
            }
            case 6: {
                return extractObject.isExistsSource() && ExtractListModel.isDataObject((DBObject)extractObject.getDBObject());
            }
            case 7: {
                return extractObject.isExistsSource();
            }
            case 8: {
                return extractObject.getType() == 0;
            }
        }
        return false;
    }

    protected void setValueAt(Object object, ExtractObject extractObject, int n) {
        switch (n) {
            case 0: {
                extractObject.isPreSelected(((Boolean)object).booleanValue());
                this.handleButtons();
                this.handleIncludeCheckBoxHeader();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                extractObject.isSelectedMetaData(((Boolean)object).booleanValue());
                extractObject.isExtractMetaData(((Boolean)object).booleanValue());
                this.handleDDLCheckBoxHeader();
                break;
            }
            case 5: {
                if (!ExtractListModel.isDataObject((DBObject)extractObject.getDBObject())) break;
                extractObject.isSelectedData(((Boolean)object).booleanValue());
                extractObject.isExtractData(((Boolean)object).booleanValue());
                extractObject.isDataObject(true);
                this.handleDataCheckBoxHeader();
                break;
            }
            case 6: {
                extractObject.setWhere((String)object);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    public int rowExists(URL uRL) {
        List list = this.getRowList();
        for (int i = 0; i < list.size(); ++i) {
            URL uRL2 = ((ExtractObject)list.get(i)).getUrl();
            if (!uRL.equals(uRL2)) continue;
            return i;
        }
        return -1;
    }

    public ExtractObject getRow(URL uRL) {
        List list = this.getRowList();
        for (int i = 0; i < list.size(); ++i) {
            URL uRL2 = ((ExtractObject)list.get(i)).getUrl();
            if (!uRL.equals(uRL2)) continue;
            return (ExtractObject)list.get(i);
        }
        return null;
    }

    public ExtractObject getRow(int n) {
        List list = this.getRowList();
        for (ExtractObject extractObject : list) {
            if (extractObject.getType() != n) continue;
            return extractObject;
        }
        return null;
    }

    private boolean getScript(ExtractObject extractObject) {
        ScriptPanel scriptPanel = new ScriptPanel(extractObject);
        HelpSystem.getHelpSystem().registerTopic((JComponent)scriptPanel, "f1_cartscripts_html");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)scriptPanel, null, (String)ExtractResources.getString((String)"EO_TITLE_SCRIPTS"), (int)7);
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(true);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            extractObject.clearScripts();
            if (scriptPanel.isInitial()) {
                extractObject.addScript(scriptPanel.getInitial(), scriptPanel.getInitialEncoding(), 114, scriptPanel.isInitial());
            }
            if (scriptPanel.isFinal()) {
                extractObject.addScript(scriptPanel.getFinal(), scriptPanel.getFinalEncoding(), 115, scriptPanel.isFinal());
            }
            return true;
        }
        return false;
    }

    public List<ExtractObject> addRow(DBObject dBObject, String string) {
        Object[] objectArray = new Object[1];
        ExtractObject extractObject = new ExtractObject(dBObject, this._extractListModel);
        extractObject.setSourceConnName(string);
        extractObject.isExistsSource(true);
        extractObject.isExtractMetaData(true);
        extractObject.isSelectedMetaData(true);
        extractObject.isPreSelected(true);
        if (!extractObject.isInList(this.getRowList())) {
            objectArray[0] = extractObject;
            if (this.getRow(3) == null) {
                super.addRow(objectArray);
            } else {
                super.insertRow(super.getRowCount() - 1, objectArray);
            }
            this._toolbar.setDeleteEnabled(true);
            this.handleIncludeCheckBoxHeader();
            this.handleDDLCheckBoxHeader();
            this.handleDataCheckBoxHeader();
        }
        return this._extractListModel.getList(0);
    }

    public void addRows(List<ExtractObject> list) {
        this._deferHandleButtons = true;
        for (ExtractObject extractObject : list) {
            Object[] objectArray = new Object[1];
            extractObject.setListModel(this._extractListModel);
            if (extractObject.isInList(this.getRowList())) continue;
            objectArray[0] = extractObject;
            if (extractObject.getType() == 2) {
                if (this.getRow(2) != null) {
                    super.removeRow(0);
                }
                super.insertRow(0, objectArray);
                this.enableAddButton("ADD_INITIAL_SCRIPT", false);
                continue;
            }
            if (extractObject.getType() == 3) {
                if (this.getRow(3) != null) {
                    super.removeRow(super.getRowCount() - 1);
                }
                super.addRow(objectArray);
                this.enableAddButton("ADD_FINAL_SCRIPT", false);
                continue;
            }
            if (this.getRow(3) == null) {
                super.addRow(objectArray);
                continue;
            }
            super.insertRow(super.getRowCount() - 1, objectArray);
        }
        this._deferHandleButtons = false;
        DbCartController.getInstance().toggleToolbar();
        this._toolbar.setDeleteEnabled(true);
        this.handleIncludeCheckBoxHeader();
        this.handleDDLCheckBoxHeader();
        this.handleDataCheckBoxHeader();
        this.handleButtons();
    }

    public ExtractObject addPreScriptRow() {
        return this.addScriptRow(0, 2, 114, true);
    }

    public ExtractObject addPreScriptRow(boolean bl) {
        return this.addScriptRow(0, 2, 114, bl);
    }

    public ExtractObject addPostScriptRow() {
        return this.addScriptRow(super.getRowCount(), 3, 115, true);
    }

    public ExtractObject addPostScriptRow(boolean bl) {
        return this.addScriptRow(super.getRowCount(), 3, 115, bl);
    }

    public ExtractObject addScriptRow(int n, int n2, int n3, boolean bl) {
        try {
            TargetFormat targetFormat = new TargetFormat(1, 4);
            String string = targetFormat.getDefaultDirectory();
            File file = new File(string);
            URL uRL = file.toURI().toURL();
            ExtractObject extractObject = new ExtractObject(uRL, this._extractListModel);
            extractObject.setType(n2);
            extractObject.isPreSelected(true);
            if (bl) {
                extractObject.addScript(string, targetFormat.getEncoding(), n3, true);
                if (this.getScript(extractObject)) {
                    Object[] objectArray = new Object[]{extractObject};
                    super.insertRow(n, objectArray);
                    DbCartController.getInstance().toggleToolbar();
                    this._toolbar.setDeleteEnabled(true);
                } else {
                    extractObject = null;
                }
            } else {
                Object[] objectArray = new Object[]{extractObject};
                super.insertRow(n, objectArray);
                DbCartController.getInstance().toggleToolbar();
                this._toolbar.setDeleteEnabled(true);
            }
            return extractObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void removeRow(int n) {
        super.removeRow(n);
        if (this.isIncludedEmpty()) {
            DbCartController.getInstance().toggleToolbar();
        }
        if (this.getRow(2) == null) {
            this.enableAddButton("ADD_INITIAL_SCRIPT", true);
        }
        if (this.getRow(3) == null) {
            Action[] actionArray;
            this.enableAddButton("ADD_FINAL_SCRIPT", true);
            for (Action action : actionArray = this._toolbar.getAddMenuActions()) {
                if (!action.getValue("Name").equals("ADD_FINAL_SCRIPT")) continue;
                action.setEnabled(true);
                break;
            }
        }
        this.handleButtons();
        this.handleIncludeCheckBoxHeader();
        this.handleDDLCheckBoxHeader();
        this.handleDataCheckBoxHeader();
    }

    public void removeAll() {
        super.removeAll();
        DbCartController.getInstance().toggleToolbar();
        this.handleButtons();
        this.handleIncludeCheckBoxHeader();
        this.handleDDLCheckBoxHeader();
        this.handleDataCheckBoxHeader();
    }

    public ExtractListModel getExtractListModel() {
        return this._extractListModel;
    }

    public boolean isEmpty() {
        return this._rowList.isEmpty();
    }

    public boolean isIncludedEmpty() {
        return this.getIncludedRows().isEmpty();
    }

    public ArrayList<ExtractObject> getIncludedRows() {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : this._rowList) {
            if (!extractObject.isPreSelected() || !extractObject.isExistsSource()) continue;
            arrayList.add(extractObject);
        }
        return arrayList;
    }

    public ArrayList<ExtractObject> getIncludedDBORows() {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.getType() != 0 || !extractObject.isPreSelected() || !extractObject.isExistsSource()) continue;
            arrayList.add(extractObject);
        }
        return arrayList;
    }

    public ArrayList<ExtractObject> getDBORows() {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.getType() != 0) continue;
            arrayList.add(extractObject);
        }
        return arrayList;
    }

    public ArrayList<ExtractObject> getAllRows() {
        return (ArrayList)this._rowList;
    }

    public boolean isAnyDDLOrDataRows() {
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.getType() != 0 || !extractObject.isPreSelected() || !extractObject.isExistsSource() || !extractObject.isExtractMetaData() && !extractObject.isExtractData()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyDDLRows() {
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.getType() != 0 || !extractObject.isPreSelected() || !extractObject.isExistsSource() || !extractObject.isExtractMetaData()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyDataRows() {
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.getType() != 0 || !extractObject.isPreSelected() || !extractObject.isExistsSource() || !extractObject.isExtractData()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaved() {
        return this._saveAs.length() > 0;
    }

    public void setSaveAs(String string) {
        this._saveAs = string;
    }

    public String getSaveAs() {
        return this._saveAs;
    }

    public String getSaveAsTabName() {
        if (this._saveAs.length() > 0) {
            File file = new File(this._saveAs);
            String string = file.getName();
            int n = string.lastIndexOf(".");
            return n == -1 ? string : string.substring(0, n);
        }
        return "";
    }

    public void setSaveAsEncoding(String string) {
        this._saveAsEncoding = string;
    }

    public String getSaveAsEncoding() {
        return this._saveAsEncoding;
    }

    public void setToolbar(TableToolbar tableToolbar) {
        this._toolbar = tableToolbar;
    }

    private void handleButtons() {
        if (!this._deferHandleButtons) {
            for (ExtractObject extractObject : this.getIncludedRows()) {
                this._toolbar.setDeleteEnabled(true);
                if (!extractObject.isExtractMetaData() && !extractObject.isExtractData() && extractObject.getType() == 0) continue;
                DbCartController.getInstance().toggleToolbar();
                return;
            }
            DbCartController.getInstance().toggleToolbar();
        }
    }

    private void enableAddButton(String string, boolean bl) {
        Action action = this._toolbar.getDefaultAddAction();
        if (action.getValue("Name").equals(DbCartAddinArb.getString(string))) {
            action.setEnabled(bl);
        } else {
            Action[] actionArray;
            for (Action action2 : actionArray = this._toolbar.getAddMenuActions()) {
                if (!action2.getValue("Name").equals(DbCartAddinArb.getString(string))) continue;
                action2.setEnabled(bl);
                break;
            }
        }
    }

    private void handleIncludeCheckBoxHeader() {
        boolean bl = false;
        boolean bl2 = true;
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.isPreSelected()) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2 && bl) {
            this._includeCheckBoxHeader.setState(TriStateCheckBox.State.TRUE);
        } else if (bl) {
            this._includeCheckBoxHeader.setState(TriStateCheckBox.State.PARTIAL);
        } else {
            this._includeCheckBoxHeader.setState(TriStateCheckBox.State.FALSE);
        }
        this._table.getTableHeader().repaint();
    }

    public void handleDataCheckBoxHeader() {
        boolean bl = false;
        boolean bl2 = true;
        for (ExtractObject extractObject : this._rowList) {
            if (!ExtractListModel.isDataObject((DBObject)extractObject.getDBObject())) continue;
            if (extractObject.isSelectedData()) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2 && bl) {
            this._dataCheckBoxHeader.setState(TriStateCheckBox.State.TRUE);
        } else if (bl) {
            this._dataCheckBoxHeader.setState(TriStateCheckBox.State.PARTIAL);
        } else {
            this._dataCheckBoxHeader.setState(TriStateCheckBox.State.FALSE);
        }
        this._table.getTableHeader().repaint();
    }

    public void handleDDLCheckBoxHeader() {
        boolean bl = false;
        boolean bl2 = true;
        for (ExtractObject extractObject : this._rowList) {
            if (extractObject.isExtractMetaData()) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        if (bl2 && bl) {
            this._ddlCheckBoxHeader.setState(TriStateCheckBox.State.TRUE);
        } else if (bl) {
            this._ddlCheckBoxHeader.setState(TriStateCheckBox.State.PARTIAL);
        } else {
            this._ddlCheckBoxHeader.setState(TriStateCheckBox.State.FALSE);
        }
        this._table.getTableHeader().repaint();
    }

    private class ErrorTextField
    extends CompletionTextField {
        private static final long serialVersionUID = 1L;
        private int[][] _ranges;

        private ErrorTextField() {
        }

        public boolean isTextValid() {
            return false;
        }

        protected int[][] getInvalidCharacterRanges() {
            Object object;
            if (this._ranges != null) {
                object = this._ranges;
            } else {
                int[][] nArrayArray = new int[1][];
                object = nArrayArray;
                nArrayArray[0] = new int[]{0, this.getText().length() - 1};
            }
            return object;
        }

        protected void setInvalidCharacterRanges(int[][] nArray) {
            this._ranges = nArray;
        }
    }

    class CheckBoxHeader
    extends TriStateCheckBox
    implements TableCellRenderer,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected CheckBoxHeader rendererComponent = this;
        protected int column;
        protected boolean mousePressed = false;
        String colName;

        public CheckBoxHeader(String string) {
            this.colName = string;
            this.setCanUserSetPartial(false);
            this.setDirection(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setBorderPainted(true);
            this.setBorder(jTableHeader.getBorder());
            this.setFont(jTableHeader.getFont());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setColumn(n2);
            this.rendererComponent.setText(this.colName);
            this.rendererComponent.setHorizontalAlignment(0);
            this.rendererComponent.setEnabled(true);
            return this.rendererComponent;
        }

        protected void setColumn(int n) {
            this.column = n;
        }

        public int getColumn() {
            return this.column;
        }

        protected void handleClickEvent(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n == this.column && mouseEvent.getClickCount() == 1 && n2 != -1) {
                this.doClick();
                boolean bl = true;
                if (this.rendererComponent.getState().equals((Object)TriStateCheckBox.State.FALSE)) {
                    bl = false;
                }
                int n3 = DBCartReorderableTableModel.this._table.getRowCount();
                for (int i = 0; i < n3; ++i) {
                    DBCartReorderableTableModel.this._table.getModel().setValueAt(bl, i, n2);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleClickEvent(mouseEvent);
            ((JTableHeader)mouseEvent.getSource()).repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class DataCheckBoxRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        DataCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            Component component = jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!ExtractListModel.isDataObject((DBObject)extractObject.getDBObject())) {
                component.setVisible(false);
                component = new JLabel();
                ((JLabel)component).setEnabled(extractObject.isExistsSource() || extractObject.getType() != 0);
            } else {
                ((JCheckBox)component).setEnabled(extractObject.isExistsSource());
            }
            DBCartReorderableTableModel.this.handleButtons();
            return component;
        }
    }

    class DdlCheckBoxRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        DdlCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            JComponent jComponent = (JCheckBox)jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jComponent.setSelected(extractObject.isExtractMetaData());
            if (extractObject.isTypeScript()) {
                ((Component)jComponent).setVisible(false);
                jComponent = new JLabel();
                ((JLabel)jComponent).setEnabled(extractObject.isExistsSource() || extractObject.getType() != 0);
            } else {
                jComponent.setEnabled(extractObject.isExistsSource());
            }
            DBCartReorderableTableModel.this.handleButtons();
            return jComponent;
        }
    }

    class IncludeCheckBoxRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        IncludeCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            JCheckBox jCheckBox = (JCheckBox)jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jCheckBox.setSelected(extractObject.isPreSelected());
            if (extractObject.getType() == 0) {
                jCheckBox.setEnabled(extractObject.isExistsSource() && (extractObject.isExtractMetaData() || extractObject.isExtractData()));
                if (extractObject.isScriptError()) {
                    jCheckBox.setEnabled(false);
                }
            } else {
                jCheckBox.setEnabled(!extractObject.isScriptError());
            }
            return jCheckBox;
        }
    }

    class StringCellRenderer
    extends Component
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            Component component = jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JLabel)component).setEnabled(extractObject.isExistsSource());
            return component;
        }
    }

    class ConnectionCellRenderer
    extends Component
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ErrorTextField _errorField;

        ConnectionCellRenderer() {
            this._errorField = new ErrorTextField();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            Component component = jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!extractObject.isExistsSource() && extractObject.getSourceConn() == null) {
                this._errorField.setText(object.toString());
                this._errorField.setBackground(component.getBackground());
                this._errorField.setBorder(BorderFactory.createEmptyBorder());
                this._errorField.setToolTipText(DbCartAddinArb.getString("NOT_EXISTS_CONN"));
                return this._errorField;
            }
            return component;
        }
    }

    class ScriptCellRenderer
    extends Component
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ErrorTextField _errorField;
        private JLabel _scriptLabel;

        ScriptCellRenderer() {
            this._errorField = new ErrorTextField();
            this._scriptLabel = new JLabel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ExtractObject extractObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            Component component = jTable.getDefaultRenderer(jTable.getColumnClass(n2)).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (extractObject.isIncludeScripts()) {
                if (extractObject.isScriptError()) {
                    this._scriptLabel.setIcon(OracleIcons.getIcon((String)"exception.png"));
                } else {
                    this._scriptLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
                }
            } else {
                this._scriptLabel.setIcon(null);
            }
            if (extractObject.getType() == 0) {
                this._scriptLabel.setEnabled(extractObject.isExistsSource());
            } else {
                this._scriptLabel.setEnabled(true);
            }
            this._scriptLabel.setToolTipText(extractObject.getScriptTip());
            return this._scriptLabel;
        }
    }

    class CustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTable _table;
        ExtractObject _dataObject;
        Object _whereValue;
        Object _scriptValue;
        int _rowIndex;
        int _vColIndex;
        PredicatePanel _whereEditor;
        ScriptPanel _scriptEditor;
        DbCartMapConnectionPanel _mapConnectionEditor;
        JButton _editButton;

        CustomCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this._table = jTable;
            this._rowIndex = n;
            this._vColIndex = n2;
            this._whereValue = "";
            this._scriptValue = "";
            this._dataObject = (ExtractObject)((ListTableModel)jTable.getModel()).getRowList().get(n);
            this._editButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this._editButton.setMargin(new Insets(2, 2, 2, 2));
            this._editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CustomCellEditor.this._vColIndex == 6) {
                        CustomCellEditor.this.handleWhereEdit();
                    } else if (CustomCellEditor.this._vColIndex == 7) {
                        CustomCellEditor.this.handleScriptEdit();
                    } else if (CustomCellEditor.this._vColIndex == 8) {
                        CustomCellEditor.this.handleConnectionEdit();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (CustomCellEditor.this._table.isVisible()) {
                                CustomCellEditor.this._table.requestFocusInWindow();
                            }
                        }
                    });
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setName("CustomCellEditor.Panel" + n2);
            JLabel jLabel = new JLabel(object.toString());
            jPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            jPanel.add("Center", jLabel);
            jPanel.add("East", this._editButton);
            this._editButton.setName("CustomCellEditor.EditButton" + n2);
            this._editButton.setFocusable(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomCellEditor.this._editButton.requestFocusInWindow();
                }
            });
            return jPanel;
        }

        private void handleWhereEdit() {
            this._whereEditor = new PredicatePanel(this._dataObject, (String)this._table.getModel().getValueAt(this._rowIndex, this._vColIndex), false);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._whereEditor, "f1_idedexporttabledata_html");
            this._whereEditor.setVerticalDisplay(false);
            if (WizardLauncher.runDialog((JDialog)this.getDialog((Component)this._whereEditor, ExtractResources.getString((String)"EO_TITLE_WHERE")))) {
                this._dataObject.setTable((JTable)this._whereEditor.getTable());
                this._whereValue = this._whereEditor.toString();
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }

        private void handleScriptEdit() {
            this._scriptEditor = new ScriptPanel(this._dataObject);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._scriptEditor, "f1_cartscripts_html");
            if (WizardLauncher.runDialog((JDialog)this.getDialog((Component)this._scriptEditor, ExtractResources.getString((String)"EO_TITLE_SCRIPTS")))) {
                this._dataObject.clearScripts();
                if (this._scriptEditor.isPreCreate()) {
                    this._dataObject.addScript(this._scriptEditor.getPreCreate(), this._scriptEditor.getPreCreateEncoding(), 110, this._scriptEditor.isPreCreate());
                }
                if (this._scriptEditor.isPostCreate()) {
                    this._dataObject.addScript(this._scriptEditor.getPostCreate(), this._scriptEditor.getPostCreateEncoding(), 111, this._scriptEditor.isPostCreate());
                }
                if (this._scriptEditor.isPreLoad()) {
                    this._dataObject.addScript(this._scriptEditor.getPreLoad(), this._scriptEditor.getPreLoadEncoding(), 112, this._scriptEditor.isPreLoad());
                }
                if (this._scriptEditor.isPostLoad()) {
                    this._dataObject.addScript(this._scriptEditor.getPostLoad(), this._scriptEditor.getPostLoadEncoding(), 113, this._scriptEditor.isPostLoad());
                }
                if (this._scriptEditor.isInitial()) {
                    this._dataObject.addScript(this._scriptEditor.getInitial(), this._scriptEditor.getInitialEncoding(), 114, this._scriptEditor.isInitial());
                }
                if (this._scriptEditor.isFinal()) {
                    this._dataObject.addScript(this._scriptEditor.getFinal(), this._scriptEditor.getFinalEncoding(), 115, this._scriptEditor.isFinal());
                }
                this._scriptValue = this._scriptEditor.toString();
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }

        private void handleConnectionEdit() {
            this._mapConnectionEditor = new DbCartMapConnectionPanel(this._dataObject);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._mapConnectionEditor, "f1_map_connections_html");
            if (WizardLauncher.runDialog((JDialog)this.getDialog(this._mapConnectionEditor, DbCartAddinArb.getString("MAP_CONNECTION_TITLE")))) {
                int n = this._mapConnectionEditor.getMapOption();
                String string = this._mapConnectionEditor.getNewConnName();
                if (string != null && string.length() > 0) {
                    if (n == 0) {
                        this._dataObject.mapSourceConnection(string);
                    } else if (n == 1) {
                        String string2 = this._dataObject.getSourceConnName();
                        for (ExtractObject extractObject : DBCartReorderableTableModel.this._rowList) {
                            if (!extractObject.getSourceConnName().equals(string2)) continue;
                            extractObject.mapSourceConnection(string);
                        }
                    } else {
                        for (ExtractObject extractObject : DBCartReorderableTableModel.this._rowList) {
                            extractObject.mapSourceConnection(string);
                        }
                    }
                    this.stopCellEditing();
                }
            } else {
                this.cancelCellEditing();
            }
        }

        private JEWTDialog getDialog(Component component, String string) {
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, null, (String)string, (int)7);
            jEWTDialog.setResizable(true);
            jEWTDialog.setOKButtonEnabled(true);
            return jEWTDialog;
        }

        @Override
        public Object getCellEditorValue() {
            return this._vColIndex == 6 ? this.notNull(this._whereValue) : this.notNull(this._scriptValue);
        }

        private String notNull(Object object) {
            return object != null ? object.toString() : "";
        }
    }

    class URLCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ErrorTextField _errorField;

        URLCellRenderer() {
            this._errorField = new ErrorTextField();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = null == object ? null : object.toString();
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            URL uRL = null;
            boolean bl3 = true;
            if (object != null && object instanceof URL) {
                uRL = (URL)object;
                ExtractObject extractObject = (ExtractObject)DBCartReorderableTableModel.this._rowList.get(n);
                if (extractObject.getType() == 0) {
                    bl3 = extractObject.isExistsSource();
                    if (n2 == 2) {
                        String string2 = "";
                        String string3 = DBURLFormatHelper.getSchema((URL)uRL);
                        string = string3 != null && string3.length() > 0 ? string3 : string2;
                    } else {
                        string = n2 == 1 ? DBURLFormatHelper.getBaseType((URL)uRL) : DBURLFormatHelper.getName((URL)uRL);
                    }
                } else if (n2 == 2) {
                    File file = new File(extractObject.getScript(extractObject.getType() == 2 ? 114 : 115).getPath());
                    string = file.isDirectory() ? file.getPath() : file.getParent();
                } else if (n2 == 1) {
                    string = DbCartAddinArb.getString("FILE_TYPE");
                } else {
                    File file = new File(extractObject.getScript(extractObject.getType() == 2 ? 114 : 115).getPath());
                    String string4 = string = file.isDirectory() ? "" : file.getName();
                }
                if (!extractObject.isExistsSource()) {
                    if (extractObject.getSourceConn() != null) {
                        this._errorField.setText(string);
                        this._errorField.setBackground(jLabel.getBackground());
                        this._errorField.setBorder(BorderFactory.createEmptyBorder());
                        this._errorField.setToolTipText(DbCartAddinArb.getString("NOT_EXISTS_OBJECT"));
                        return this._errorField;
                    }
                    jLabel.setToolTipText(DbCartAddinArb.getString("NOT_EXISTS_CONN"));
                }
            }
            jLabel.setText(string);
            return jLabel;
        }
    }
}

