/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.tocNavigator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.TocFileTreeNode;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.tocNavigator.TOCUtils;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.IndexedListListener;

public class MergingTopicTreeNode
extends TopicTreeNode {
    private ArrayList _baseNodes;
    private ArrayList _tocViews;
    private boolean _hasMergedChildren = false;
    private Map<String, TopicTreeNode> _locationToParentMap = null;
    private Map<String, Integer> _locationToSortValueMap = null;
    private static final Logger _LOGGER = Logger.getLogger(MergingTopicTreeNode.class.getName(), "oracle.help.share.resource.LoggerBundle");

    public MergingTopicTreeNode() {
    }

    public MergingTopicTreeNode(TopicTreeNode base) {
        this._addBaseNode(base);
        this.setSortValue(base.getSortValue());
    }

    public MergingTopicTreeNode(View[] views) {
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                this.addView(views[i]);
            }
        }
    }

    @Override
    public synchronized ArrayList getChildren() {
        if (!this._hasMergedChildren) {
            int i;
            if (this._baseNodes != null) {
                for (i = 0; i < this._baseNodes.size(); ++i) {
                    this._reallyAddBaseNode((TopicTreeNode)this._baseNodes.get(i));
                }
            }
            if (this._tocViews != null) {
                for (i = 0; i < this._tocViews.size(); ++i) {
                    this._reallyAddView((View)this._tocViews.get(i));
                }
            }
            this._hasMergedChildren = true;
        }
        return this._getRealChildren();
    }

    @Override
    public View getView() {
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getView();
        }
        return null;
    }

    @Override
    public TopicTreeNode getParent() {
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getParent();
        }
        return null;
    }

    @Override
    public void setParent(TopicTreeNode parent) {
        if (this._baseNodes != null) {
            for (int i = 0; i < this._baseNodes.size(); ++i) {
                TopicTreeNode node = (TopicTreeNode)this._baseNodes.get(i);
                node.setParent(parent);
            }
        }
    }

    @Override
    public Topic getTopic() {
        if (this._baseNodes != null) {
            for (int i = 0; i < this._baseNodes.size(); ++i) {
                TopicTreeNode node = (TopicTreeNode)this._baseNodes.get(i);
                Topic topic = node.getTopic();
                if (topic == null || !topic.hasTarget()) continue;
                return topic;
            }
        }
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getTopic();
        }
        return null;
    }

    @Override
    public boolean isTraversable() {
        boolean traversable = true;
        if (this._baseNodes != null) {
            for (int i = 0; i < this._baseNodes.size(); ++i) {
                traversable = traversable && ((TopicTreeNode)this._baseNodes.get(i)).isTraversable();
            }
        }
        return traversable;
    }

    @Override
    public boolean allowsChildMerging() {
        boolean allowsChildMerging = true;
        if (this._baseNodes != null) {
            for (int i = 0; i < this._baseNodes.size(); ++i) {
                allowsChildMerging = allowsChildMerging && ((TopicTreeNode)this._baseNodes.get(i)).allowsChildMerging();
            }
        }
        return allowsChildMerging;
    }

    @Override
    public Object getClientData() {
        if (this._getBaseNode() != null) {
            return this._getBaseNode().getClientData();
        }
        return null;
    }

    @Override
    public void setClientData(Object data) {
        if (this._baseNodes != null) {
            for (int i = 0; i < this._baseNodes.size(); ++i) {
                ((TopicTreeNode)this._baseNodes.get(i)).setClientData(data);
            }
        }
    }

    public void addView(View aView) {
        if (this._tocViews == null) {
            this._tocViews = new ArrayList();
        }
        if (!this._tocViews.contains(aView)) {
            if (aView.isMasterView() && this._tocViews.size() > 0) {
                _LOGGER.log(Level.WARNING, "Error adding master TOC view containing the TOC file: " + aView.getDataLocation().toString() + "; this view will be ignored. " + "A master TOC view must be the first view added, and only one can be added.");
                return;
            }
            this._tocViews.add(aView);
            if (this._hasMergedChildren) {
                this._reallyAddView(aView);
            }
        }
    }

    public void removeView(View aView) {
        if (this._hasMergedChildren) {
            this._reallyRemoveView(aView);
        }
        if (this._tocViews != null && this._tocViews.contains(aView)) {
            this._tocViews.remove(aView);
        }
        if (this._baseNodes != null) {
            for (int i = this._baseNodes.size() - 1; i >= 0; --i) {
                TopicTreeNode baseNode = (TopicTreeNode)this._baseNodes.get(i);
                if (baseNode.getView() != aView) continue;
                this._baseNodes.remove(i);
            }
        }
    }

    public List getContributingViews() {
        if (this._tocViews != null) {
            return this._tocViews;
        }
        if (this._baseNodes != null) {
            ArrayList<View> views = new ArrayList<View>();
            for (int i = 0; i < this._baseNodes.size(); ++i) {
                TopicTreeNode node = (TopicTreeNode)this._baseNodes.get(i);
                View view = node.getView();
                if (view == null) continue;
                views.add(view);
            }
            return views;
        }
        return Collections.EMPTY_LIST;
    }

    private void _fireModelEvent(int index, int type) {
        Enumeration listeners;
        if (this.getListenerManager() != null && this._hasMergedChildren && (listeners = this.getListenerManager().getListeners()) != null) {
            while (listeners.hasMoreElements()) {
                IndexedListListener l = (IndexedListListener)listeners.nextElement();
                if (type == 0) {
                    l.itemAdded(index);
                    continue;
                }
                if (type != 1) continue;
                l.itemRemoved(index);
            }
        }
    }

    private void _fireCurrentEvent() {
        Enumeration listeners = this.getListenerManager().getListeners();
        if (listeners != null) {
            while (listeners.hasMoreElements()) {
                IndexedListListener l = (IndexedListListener)listeners.nextElement();
                l.fireCurrentEvent();
            }
        }
    }

    private void _addBaseNode(TopicTreeNode node) {
        if (this._baseNodes == null) {
            this._baseNodes = new ArrayList();
        }
        if (!this._baseNodes.contains(node)) {
            this._baseNodes.add(node);
            if (this._hasMergedChildren) {
                this._reallyAddBaseNode(node);
            }
        }
    }

    private void _reallyAddBaseNode(TopicTreeNode node) {
        ArrayList topLevelChildren;
        if (node != null && (topLevelChildren = node.getChildren()) != null) {
            for (int nodeIter = 0; nodeIter < topLevelChildren.size(); ++nodeIter) {
                this._addChildNode((TopicTreeNode)topLevelChildren.get(nodeIter));
            }
        }
    }

    private void _reallyAddView(View aView) {
        ArrayList nodes = this._createTopicTreeNodes(aView);
        this._updateSortValue(nodes);
        for (int nodeIter = 0; nodeIter < nodes.size(); ++nodeIter) {
            this._addChildNode((TopicTreeNode)nodes.get(nodeIter));
        }
        this._fireCurrentEvent();
    }

    private void _updateSortValue(ArrayList nodes) {
        ArrayList existingChildren = this._getRealChildren();
        if (!existingChildren.isEmpty()) {
            TopicTreeNode lastChild = (TopicTreeNode)existingChildren.get(existingChildren.size() - 1);
            int lastSortVal = lastChild.getSortValue();
            for (int nodeIter = 0; nodeIter < nodes.size(); ++nodeIter) {
                ((TopicTreeNode)nodes.get(nodeIter)).setSortValue(++lastSortVal);
            }
        }
    }

    private void _reallyRemoveView(View aView) {
        if (this.getContributingViews().contains(aView)) {
            for (int nodeIter = this._getRealChildren().size() - 1; nodeIter >= 0; --nodeIter) {
                MergingTopicTreeNode node = (MergingTopicTreeNode)this._getRealChildren().get(nodeIter);
                if (!node.getContributingViews().contains(aView)) continue;
                node.removeView(aView);
                this._getRealChildren().remove(nodeIter);
                this._fireModelEvent(nodeIter, 1);
                if (node.getContributingViews().size() <= 0) continue;
                this._getRealChildren().add(nodeIter, node);
                this._fireModelEvent(nodeIter, 0);
            }
            this._fireCurrentEvent();
        }
    }

    private void _addChildNode(TopicTreeNode node) {
        if (this.allowsChildMerging() && !this._tryToMergeNode(node)) {
            ArrayList children = this._getRealChildren();
            MergingTopicTreeNode treeNode = new MergingTopicTreeNode(node);
            children.add(treeNode);
            Collections.sort(children);
            int index = children.indexOf(treeNode);
            this._fireModelEvent(index, 0);
        }
    }

    private ArrayList _createTopicTreeNodes(View view) {
        ArrayList<TopicTreeNode> topicTreeNodes = new ArrayList<TopicTreeNode>();
        TopicTree theTree = TOCUtils.getTopicTree(view);
        if (theTree != null) {
            ArrayList viewNodes;
            TopicTreeNode titleNode = null;
            if (view.getTitle() != null) {
                SimpleTopic titleTopic = new SimpleTopic(view.getTitle(), null, view.getTitleImage(), null);
                titleNode = new TopicTreeNode(view, titleTopic);
                topicTreeNodes.add(titleNode);
            }
            if ((viewNodes = theTree.getRoot().getChildren()) != null) {
                for (int iter = 0; iter < viewNodes.size(); ++iter) {
                    TopicTreeNode aNode = (TopicTreeNode)viewNodes.get(iter);
                    if (titleNode != null) {
                        titleNode.addChild(aNode);
                        continue;
                    }
                    topicTreeNodes.add(aNode);
                }
            }
        }
        if (view.isMasterView()) {
            return this._processMasterTreeNodes(topicTreeNodes);
        }
        if (this._locationToParentMap != null) {
            return this._addParentMasterTreeNodes(topicTreeNodes, view);
        }
        return topicTreeNodes;
    }

    private boolean _tryToMergeNode(TopicTreeNode testNode) {
        Topic testTopic = testNode.getTopic();
        if (testTopic != null) {
            for (int i = 0; i < this._getRealChildren().size(); ++i) {
                MergingTopicTreeNode existingNode = (MergingTopicTreeNode)this._getRealChildren().get(i);
                Topic existingTopic = existingNode.getTopic();
                if (existingTopic == null || !this._sameLabel(existingTopic, testTopic) || testTopic.hasTarget() && existingTopic.hasTarget() && !this._sameTarget(existingTopic, testTopic)) continue;
                existingNode._addBaseNode(testNode);
                this._getRealChildren().remove(i);
                this._fireModelEvent(i, 1);
                this._getRealChildren().add(i, existingNode);
                this._fireModelEvent(i, 0);
                return true;
            }
        }
        return false;
    }

    private boolean _sameTarget(Topic a, Topic b) {
        Target aTarget = a.getTarget();
        URL aURL = null;
        if (aTarget != null) {
            try {
                aURL = aTarget.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Target bTarget = b.getTarget();
        URL bURL = null;
        if (bTarget != null) {
            try {
                bURL = bTarget.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (aURL != null && bURL != null) {
            return aURL.sameFile(bURL);
        }
        return aURL == bURL;
    }

    private boolean _sameLabel(Topic a, Topic b) {
        if (a.getLabel() == null && b.getLabel() == null) {
            return true;
        }
        if (a.getLabel() == null) {
            return false;
        }
        return a.getLabel().equals(b.getLabel());
    }

    private ArrayList _getRealChildren() {
        return super.getChildren();
    }

    private TopicTreeNode _getBaseNode() {
        if (this._baseNodes != null && this._baseNodes.size() > 0) {
            return (TopicTreeNode)this._baseNodes.get(0);
        }
        return null;
    }

    private ArrayList _processMasterTreeNodes(ArrayList topicTreeNodes) {
        if (this._locationToParentMap == null) {
            this._locationToParentMap = new HashMap<String, TopicTreeNode>();
            this._locationToSortValueMap = new HashMap<String, Integer>();
        }
        for (int i = 0; i < topicTreeNodes.size(); ++i) {
            this._handleTocFile((TopicTreeNode)topicTreeNodes.get(i));
        }
        return topicTreeNodes;
    }

    private void _handleTocFile(TopicTreeNode node) {
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            TopicTreeNode child = (TopicTreeNode)iter.next();
            if (child instanceof TocFileTreeNode) {
                int sortVal = child.getSortValue();
                String location = ((TocFileTreeNode)child).getLocation();
                String[] locations = location.split(";");
                for (int i = 0; i < locations.length; ++i) {
                    location = locations[i].trim();
                    if ((location = Canonicalizer.resolveConfigURLLocation(location)).length() <= 0) continue;
                    this._locationToParentMap.put(location, node);
                    this._locationToSortValueMap.put(location, sortVal++);
                }
                iter.remove();
                continue;
            }
            this._handleTocFile(child);
        }
    }

    private ArrayList _addParentMasterTreeNodes(ArrayList topicTreeNodes, View view) {
        String tocFileUrl = view.getDataLocation().toString();
        TopicTreeNode parent = this._locationToParentMap.get(tocFileUrl);
        Integer sortVal = this._locationToSortValueMap.get(tocFileUrl);
        if (parent == null) {
            int idx = tocFileUrl.lastIndexOf(47);
            if (idx != -1) {
                idx = tocFileUrl.lastIndexOf(47, idx - 1);
            }
            if (idx != -1) {
                String relativeUrl = tocFileUrl.substring(idx + 1);
                parent = this._locationToParentMap.get(relativeUrl);
                sortVal = this._locationToSortValueMap.get(relativeUrl);
            }
        }
        if (parent == null) {
            _LOGGER.log(Level.WARNING, "The following path was not found in the master toc file: " + tocFileUrl + "; this file will be added to the default toc node.");
            parent = this._locationToParentMap.get("*");
            sortVal = this._locationToSortValueMap.get("*");
        }
        if (parent == null) {
            _LOGGER.log(Level.WARNING, "The master toc file doesn't specify a default toc node for adding toc files; specify this by adding a tocitem node with a child tocfile node having location=\"*\". The toc file will instead be added to the master toc root node.");
            return topicTreeNodes;
        }
        for (int i = 0; i < topicTreeNodes.size(); ++i) {
            ((TopicTreeNode)topicTreeNodes.get(i)).setSortValue(sortVal);
        }
        if (parent.getParent() == null) {
            return topicTreeNodes;
        }
        ArrayList<TopicTreeNode> newTopicTreeNodes = new ArrayList<TopicTreeNode>();
        TopicTreeNode newParent = new TopicTreeNode(parent.getView(), parent.getTopic());
        for (int i = 0; i < topicTreeNodes.size(); ++i) {
            newParent.addChild((TopicTreeNode)topicTreeNodes.get(i));
        }
        TopicTreeNode child = newParent;
        while (true) {
            TopicTreeNode nextParent;
            if ((nextParent = parent.getParent()).getParent() == null) break;
            parent = nextParent;
            newParent = new TopicTreeNode(parent.getView(), parent.getTopic());
            newParent.addChild(child);
            child = newParent;
        }
        newTopicTreeNodes.add(newParent);
        return newTopicTreeNodes;
    }
}

