/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.panels.ConnectionComponentCache;
import oracle.jdevimpl.db.resource.ConnBundle;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class SSHTunnelConfigurationPanel
extends ConnectionComponentCache
implements Traversable {
    private final JPanel m_panel = new JPanel();
    private final JCheckBox m_chkSSH = new JCheckBox();
    private final JTextField m_fldHost = new JTextField();
    private final JTextField m_fldPort = SSHTunnelConfigurationPanel.newPortField();
    private final JLabel m_lblUser = new JLabel();
    private final JTextField m_fldUser = new JTextField();
    private final JCheckBox m_chkCurrUser = new JCheckBox();
    private final JLabel m_lblAuth = new JLabel();
    private final JRadioButton m_rdbPassword = new JRadioButton();
    private final JRadioButton m_rdbKey = new JRadioButton();
    private final URLTextField m_fldKeyFile = new URLTextField();
    private final JButton m_btnBrowse = new JButton();
    private final JCheckBox m_chkSavePass = new JCheckBox();
    private final JLabel m_lblPassword = new JLabel();
    private final JTextField m_fldPassword = new JPasswordField();
    private final JCheckBox m_chkUseProxy = new JCheckBox();
    private final HyperlinkButton m_btnProxySettings = new HyperlinkButton();

    public SSHTunnelConfigurationPanel(String string) {
        super(string, "SSHTunnelConfigurationPanel");
        DBUIResourceHelper dBUIResourceHelper = this.getResourceHelper();
        dBUIResourceHelper.resButton((AbstractButton)this.m_chkSSH, ConnBundle.get("SSH_USE"), "UseSSH");
        dBUIResourceHelper.resButton((AbstractButton)this.m_btnBrowse, ConnBundle.get("SSH_BROWSE"), "KeyBrowse");
        dBUIResourceHelper.resButton((AbstractButton)this.m_chkCurrUser, ConnBundle.get("SSH_CURRENT_USER"), "CurrentUser");
        dBUIResourceHelper.resButton((AbstractButton)this.m_rdbKey, ConnBundle.get("SSH_AUTH_KEY"), "AuthKey");
        dBUIResourceHelper.resButton((AbstractButton)this.m_rdbPassword, ConnBundle.get("SSH_AUTH_PASS"), "AuthPass");
        dBUIResourceHelper.resButton((AbstractButton)this.m_chkSavePass, ConnBundle.format("SSH_SAVE_PASS", ConnBundle.get("SSH_AUTH_PASS")), "SavePass");
        dBUIResourceHelper.resButton((AbstractButton)this.m_chkUseProxy, ConnBundle.get("SSH_USE_PROXY"), "UseProxy");
        dBUIResourceHelper.resButton((AbstractButton)this.m_btnProxySettings, ConnBundle.get("SSH_PROXY_SETTINGS") + "...", "ProxySettings");
        ActionListener actionListener = actionEvent -> this.checkComponents(actionEvent);
        this.m_chkSSH.addActionListener(actionListener);
        this.m_chkSavePass.addActionListener(actionListener);
        this.m_chkCurrUser.addActionListener(actionListener);
        this.m_chkCurrUser.setSelected(true);
        this.m_lblAuth.setText(ConnBundle.get("SSH_AUTH"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdbPassword);
        buttonGroup.add(this.m_rdbKey);
        this.m_rdbPassword.setSelected(true);
        this.m_rdbPassword.addActionListener(actionListener);
        this.m_rdbKey.addActionListener(actionListener);
        this.m_chkUseProxy.addActionListener(actionListener);
        this.m_btnProxySettings.addActionListener(actionEvent -> this.editProxySettings());
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)".ssh");
        this.m_fldKeyFile.setDefaultChooserURL(URLFileSystem.exists((URL)uRL2) ? uRL2 : uRL);
        this.m_fldKeyFile.setDirectoryOnly(false);
        this.m_btnBrowse.addActionListener((ActionListener)this.m_fldKeyFile);
        JLabel jLabel = new JLabel();
        this.registerTextComponent("SSH.Host", jLabel, this.m_fldHost, "Host");
        JLabel jLabel2 = new JLabel();
        this.registerTextComponent("SSH.Port", jLabel2, this.m_fldPort, "Port");
        this.registerTextComponent("SSH.User", this.m_lblUser, this.m_fldUser, "User");
        this.registerTextComponent("SSH.Password", this.m_lblPassword, this.m_fldPassword, "Password");
        JLabel jLabel3 = new JLabel();
        this.registerTextComponent("SSH.LocalFile", jLabel3, (JTextComponent)this.m_fldKeyFile, "KeyFile");
        this.m_panel.setPreferredSize(new Dimension(450, 250));
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_panel);
        DBUILayoutHelper dBUILayoutHelper2 = dBUILayoutHelper.newTitledHelper((JComponent)this.m_chkSSH, 1, 1, true, true);
        dBUILayoutHelper2.add((Component)jLabel);
        dBUILayoutHelper2.add((Component)this.m_fldHost);
        dBUILayoutHelper2.add((Component)jLabel2);
        dBUILayoutHelper2.add((Component)this.m_fldPort, 1, 1, false, false);
        dBUILayoutHelper2.nextRowWithGap();
        dBUILayoutHelper2.add((Component)this.m_lblUser);
        dBUILayoutHelper2.add((Component)this.m_fldUser);
        dBUILayoutHelper2.add((Component)this.m_chkCurrUser, 2, 1);
        dBUILayoutHelper2.nextRow();
        dBUILayoutHelper2.add((Component)this.m_lblAuth);
        DBUILayoutHelper dBUILayoutHelper3 = dBUILayoutHelper2.newChildHelper(3, 1, true, false);
        dBUILayoutHelper3.add((Component)this.m_rdbPassword);
        dBUILayoutHelper3.add((Component)this.m_rdbKey);
        dBUILayoutHelper3.pushLeft();
        dBUILayoutHelper2.nextRow();
        DBUILayoutHelper dBUILayoutHelper4 = dBUILayoutHelper2.newChildHelper(4, 1, true, false);
        dBUILayoutHelper4.setMarginLeft(16);
        dBUILayoutHelper2.getConstraints((Component)dBUILayoutHelper4.getPanel()).insets.top = 0;
        dBUILayoutHelper4.add((Component)jLabel3);
        dBUILayoutHelper4.add((Component)this.m_fldKeyFile);
        dBUILayoutHelper4.add((Component)this.m_btnBrowse);
        dBUILayoutHelper4.nextRow();
        dBUILayoutHelper4.add((Component)this.m_chkSavePass, 2, 1, false, false);
        dBUILayoutHelper4.nextRow();
        dBUILayoutHelper4.add((Component)this.m_lblPassword);
        dBUILayoutHelper4.add((Component)this.m_fldPassword);
        dBUILayoutHelper2.nextRowWithGap();
        dBUILayoutHelper2.add((Component)this.m_chkUseProxy);
        dBUILayoutHelper2.add((Component)this.m_btnProxySettings, 3, 1);
        dBUILayoutHelper2.getConstraints((Component)this.m_btnProxySettings).anchor = 13;
        dBUILayoutHelper2.pushUp();
        dBUILayoutHelper.layout();
        new DBUIMnemonicBuilder(this.m_panel).build();
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return "f1_dbconnectionssh_html";
    }

    public void onEntry(TraversableContext traversableContext) {
        Properties properties = (Properties)traversableContext.get("NewObject");
        boolean bl = Boolean.parseBoolean(properties.getProperty("SSH.Enabled"));
        this.m_chkSSH.setSelected(bl);
        this.populateConnectionDetails(properties);
        if (!ModelUtil.hasLength((String)this.m_fldPort.getText())) {
            this.m_fldPort.setText(String.valueOf(22));
        }
        if (ModelUtil.hasLength((String)properties.getProperty("SSH.LocalFile"))) {
            this.m_rdbKey.setSelected(true);
        } else {
            this.m_rdbPassword.setSelected(true);
        }
        this.m_chkCurrUser.setSelected(!ModelUtil.hasLength((String)properties.getProperty("SSH.User")));
        this.m_chkSavePass.setSelected(ModelUtil.hasLength((String)properties.getProperty("SSH.Password")));
        this.m_chkUseProxy.setSelected(Boolean.valueOf(properties.getProperty("SSH.UseProxy")));
        this.checkComponents(null);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Properties properties = (Properties)traversableContext.get("NewObject");
        if (this.m_chkSSH.isSelected()) {
            MissingDBConnValueException.check(this.m_fldHost.getText(), this.getPropertyLabelText("SSH.Host"));
            properties.setProperty("SSH.Enabled", Boolean.TRUE.toString());
            this.commitConnectionDetails(properties);
            if (this.m_chkCurrUser.isSelected()) {
                properties.remove("SSH.User");
            }
            if (!this.m_chkSavePass.isSelected()) {
                properties.remove("SSH.Password");
            }
            if (!this.m_rdbKey.isSelected()) {
                properties.remove("SSH.LocalFile");
            }
            if (this.m_chkUseProxy.isSelected()) {
                properties.setProperty("SSH.UseProxy", Boolean.TRUE.toString());
            } else {
                properties.remove("SSH.UseProxy");
            }
        } else {
            properties.remove("SSH.Enabled");
            properties.remove("SSH.UseProxy");
            for (String string : this.getRegisteredProperties()) {
                properties.remove(string);
            }
        }
    }

    private void checkComponents(ActionEvent actionEvent) {
        boolean bl = this.m_chkSSH.isSelected();
        this.m_btnBrowse.setEnabled(bl);
        this.m_chkCurrUser.setEnabled(bl);
        this.m_rdbKey.setEnabled(bl);
        this.m_rdbPassword.setEnabled(bl);
        this.m_chkSavePass.setEnabled(bl);
        this.m_lblAuth.setEnabled(bl);
        this.m_chkUseProxy.setEnabled(bl);
        this.m_btnProxySettings.setEnabled(bl && this.m_chkUseProxy.isSelected());
        for (String string : this.getRegisteredProperties()) {
            this.setEnabled(string, bl);
        }
        boolean bl2 = this.m_rdbKey.isSelected();
        this.setVisible("SSH.LocalFile", bl2);
        this.m_btnBrowse.setVisible(bl2);
        this.m_lblPassword.setText(bl2 ? ConnBundle.get("SSH_PASSPHRASE") : StringUtils.stripMnemonic((String)ConnPropsBundle.get("SSH.Password")) + ':');
        this.m_chkSavePass.setText(StringUtils.stripMnemonic((String)ConnBundle.format("SSH_SAVE_PASS", ConnBundle.get(bl2 ? "SSH_PASSPHRASE" : "SSH_AUTH_PASS"))));
        if (bl) {
            if (this.m_chkCurrUser.isSelected()) {
                this.m_fldUser.setText(null);
                this.m_fldUser.setEnabled(false);
                this.m_lblUser.setEnabled(true);
            }
            boolean bl3 = this.m_chkSavePass.isSelected();
            this.setEnabled("SSH.Password", bl3);
            if (!bl3) {
                this.m_fldPassword.setText(null);
            }
        }
        if (actionEvent != null) {
            Object object = actionEvent.getSource();
            if (object == this.m_rdbKey) {
                this.m_fldKeyFile.requestFocusInWindow();
            } else if (object == this.m_rdbPassword) {
                this.m_fldPassword.requestFocusInWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editProxySettings() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        ProxySettingsPanel proxySettingsPanel = new ProxySettingsPanel();
        proxySettingsPanel.setProxyOptions(proxyOptions);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)this.m_panel, (String)ConnBundle.get("SSH_PROXY_SETTINGS"), (int)7);
        jEWTDialog.setName("ProxySettingsDialog");
        jEWTDialog.setContent((Component)proxySettingsPanel);
        try {
            if (jEWTDialog.runDialog()) {
                ProxyOptions.setProxyOptions((ProxyOptions)proxySettingsPanel.getProxyOptions());
            }
        }
        finally {
            jEWTDialog.dispose();
        }
    }

    public static void editSSHConfig(Component component, String string, Properties properties) {
        try {
            SSHTunnelConfigurationPanel sSHTunnelConfigurationPanel = new SSHTunnelConfigurationPanel(string);
            Namespace namespace = new Namespace();
            namespace.put("NewObject", (Object)properties);
            TDialogLauncher tDialogLauncher = new TDialogLauncher(component, ConnBundle.get("SSH_TITLE"), (Traversable)sSHTunnelConfigurationPanel, namespace);
            tDialogLauncher.setPackDialog(true);
            tDialogLauncher.initDialog().setName("SSHTunnelConfigurationDialog");
            tDialogLauncher.showDialog();
        }
        catch (Exception exception) {
            DBLog.getLogger(SSHTunnelConfigurationPanel.class).log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

