/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;
import oracle.jdeveloper.db.adapter.JDBCParametersParser;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class JDBCParametersPanel
implements Traversable {
    private final JDBCParamsTable m_table = new JDBCParamsTable();
    private final Map<String, JDBCParameterInfo> m_infos = new TreeMap<String, JDBCParameterInfo>();
    private final JComboBox m_nameCombo = new JComboBox();
    private ConnectionCreator m_connCreator;

    public Component getComponent() {
        return this.m_table.getComponent();
    }

    public String getHelpID() {
        return "f1_dbconnectionparams_html";
    }

    public void onEntry(TraversableContext traversableContext) {
        Properties properties;
        block7: {
            ConnectionCreator connectionCreator;
            Properties properties2 = (Properties)traversableContext.get("NewObject");
            String string = properties2.getProperty("parameters");
            properties = new Properties();
            if (ModelUtil.hasLength((String)string)) {
                JDBCParametersParser.parseParameterString((String)string, (Properties)properties);
            }
            if ((connectionCreator = (ConnectionCreator)traversableContext.get(ConnectionCreator.class)) != this.m_connCreator) {
                this.m_infos.clear();
                this.m_nameCombo.removeAllItems();
                this.m_connCreator = connectionCreator;
                if (this.m_connCreator != null) {
                    try {
                        Collection collection = this.m_connCreator.listJDBCParameterInfos(properties2);
                        if (collection != null) {
                            for (JDBCParameterInfo jDBCParameterInfo : collection) {
                                this.m_infos.put(jDBCParameterInfo.getName(), jDBCParameterInfo);
                            }
                            this.m_table.setKeys(this.m_infos.keySet());
                        }
                    }
                    catch (SQLException sQLException) {
                        if (sQLException instanceof SQLFeatureNotSupportedException) break block7;
                        DBLog.getLogger((Object)this).warning("Could not populate JDBC parameters: " + sQLException.getMessage());
                    }
                }
            }
        }
        this.m_table.setParameters(properties);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.m_table.stopCellEditing();
        Properties properties = (Properties)traversableContext.get("NewObject");
        String string = JDBCParametersParser.createParameterString((Properties)this.m_table.getParameters());
        if (ModelUtil.hasLength((String)string)) {
            properties.setProperty("parameters", string);
        } else {
            properties.remove("parameters");
        }
    }

    public Object getExitTransition() {
        return null;
    }

    private static Vector createTableDataVector(Properties properties) {
        Vector vector = new Vector(properties.size());
        TreeSet<String> treeSet = new TreeSet<String>(properties.stringPropertyNames());
        for (String string : treeSet) {
            Vector<String> vector2 = new Vector<String>(2);
            vector2.add(string);
            vector2.add(properties.getProperty(string));
            vector.add(vector2);
        }
        return vector;
    }

    private static Vector getColumnNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(ConnBundle.get("JDBC_PARAMS_NAME"));
        vector.add(ConnBundle.get("JDBC_PARAMS_VALUE"));
        return vector;
    }

    public static void editParameters(Component component, ConnectionCreator connectionCreator, Properties properties) {
        JDBCParametersPanel jDBCParametersPanel = new JDBCParametersPanel();
        Namespace namespace = new Namespace();
        namespace.put("NewObject", (Object)properties);
        namespace.put(ConnectionCreator.class.getName(), (Object)connectionCreator);
        TDialogLauncher tDialogLauncher = new TDialogLauncher(component, ConnBundle.get("JDBC_PARAMS"), (Traversable)jDBCParametersPanel, namespace);
        tDialogLauncher.initDialog().setName("JDBCParametersDialog");
        tDialogLauncher.showDialog();
    }

    private class JDBCParamsTable
    extends KeyValueTable {
        JDBCParamsTable() {
            super(ConnBundle.get("JDBC_PARAMS"), "JDBCParametersPanel");
        }

        protected String getAddActionText() {
            return ConnBundle.get("JDBDC_PARAMS_ADD");
        }

        protected String getDeleteActionText() {
            return ConnBundle.get("JDBDC_PARAMS_DEL");
        }

        protected String getDefaultValue(String string) {
            JDBCParameterInfo jDBCParameterInfo;
            String string2 = null;
            if (JDBCParametersPanel.this.m_infos != null && (jDBCParameterInfo = (JDBCParameterInfo)JDBCParametersPanel.this.m_infos.get(string)) != null) {
                string2 = jDBCParameterInfo.getDefaultValue();
            }
            return string2;
        }

        void setParameters(Properties properties) {
            this.setModel(new PropertiesTableModel(properties));
        }

        Properties getParameters() throws TraversalException {
            return ((PropertiesTableModel)this.getModel()).getProperties();
        }

        private class PropertiesTableModel
        extends ExtendedTable.StringTableModel {
            public PropertiesTableModel(Properties properties) {
                super((ExtendedTable)JDBCParamsTable.this, JDBCParametersPanel.createTableDataVector(properties), JDBCParametersPanel.getColumnNames());
            }

            public Properties getProperties() throws TraversalException {
                Properties properties = new Properties();
                HashSet<String> hashSet = new HashSet<String>();
                for (Vector vector : this.getDataVector()) {
                    String string = (String)vector.get(0);
                    if (!ModelUtil.hasLength((String)string)) {
                        throw new TraversalException(ConnBundle.get("JDBC_PARAMS_NULL_NAME_ERR"));
                    }
                    if (hashSet.contains(string)) {
                        throw new TraversalException(ConnBundle.format("JDBC_PARAMS_DUP_ERR", string));
                    }
                    if ("user".equals(string) || "password".equals(string)) {
                        throw new TraversalException(ConnBundle.format("JDBC_PARAMS_ILLEGAL", string));
                    }
                    this.checkChars(string);
                    String string2 = (String)vector.get(1);
                    if (!ModelUtil.hasLength((String)string2)) {
                        throw new TraversalException(ConnBundle.format("JDBC_PARAMS_NULL_VAL_ERR", string));
                    }
                    this.checkChars(string2);
                    properties.setProperty(string, string2);
                    hashSet.add(string);
                }
                return properties;
            }

            private void checkChars(String string) throws TraversalException {
                for (char c : new char[]{'=', ',', ';'}) {
                    if (string.indexOf(c) <= 0) continue;
                    throw new TraversalException(ConnBundle.format("JDBC_PARAMS_CHAR_ERR", string, Character.valueOf(c)));
                }
            }
        }
    }
}

