/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnelManager;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.panels.ConnectionComponentCache;
import oracle.jdevimpl.db.panels.JDBCParametersPanel;
import oracle.jdevimpl.db.panels.SSHTunnelConfigurationPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public abstract class AbstractConnectionDetailsPanel
extends ConnectionComponentCache
implements Traversable {
    private JPanel m_panel;
    private JCheckBox m_chkCustomURL;
    private JTextArea m_txtCustomURL;
    private JScrollPane m_spCustomURL;
    private String m_defaultURL;
    private JButton m_btnSSH;
    private JButton m_btnParams;
    private JPanel m_detailsPanel;
    private Properties m_connectionProps;

    public AbstractConnectionDetailsPanel(String string, String string2) {
        super(string, string2);
    }

    public String getHelpID() {
        return "f1_dbconnection_html";
    }

    public Component getComponent() {
        if (this.m_panel == null) {
            this.m_panel = new JPanel();
            this.m_panel.setName(this.getPanelName());
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_panel);
            dBUILayoutHelper.setMargins(0);
            this.layoutComponents(this.m_panel, dBUILayoutHelper, this.getResourceHelper());
            dBUILayoutHelper.layout();
        }
        return this.m_panel;
    }

    protected void layoutComponents(JPanel jPanel, DBUILayoutHelper dBUILayoutHelper, DBUIResourceHelper dBUIResourceHelper) {
        Object object;
        boolean bl;
        this.m_detailsPanel = this.createDetailsPanel(dBUIResourceHelper);
        final ConnectionCreator connectionCreator = this.getConnectionCreator();
        Collection collection = connectionCreator.listAllowedProperties();
        if (connectionCreator instanceof SSHConnectionCreator && SSHTunnelManager.getInstance() != null) {
            this.m_btnSSH = new JButton();
            dBUIResourceHelper.resButton((AbstractButton)this.m_btnSSH, ConnBundle.get("SSH_BUTTON"), "SSH");
            this.m_btnSSH.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractConnectionDetailsPanel.this.m_connectionProps != null) {
                        SSHTunnelConfigurationPanel.editSSHConfig(AbstractConnectionDetailsPanel.this.m_detailsPanel, AbstractConnectionDetailsPanel.this.getConnectionSubType(), AbstractConnectionDetailsPanel.this.m_connectionProps);
                    }
                }
            });
        }
        if (collection.contains("parameters")) {
            this.m_btnParams = new JButton();
            dBUIResourceHelper.resButton((AbstractButton)this.m_btnParams, this.getPropertyLabelText("parameters").replace(":", "..."), "Parameters");
            this.m_btnParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractConnectionDetailsPanel.this.m_connectionProps != null) {
                        AbstractConnectionDetailsPanel.this.commitConnectionDetails(AbstractConnectionDetailsPanel.this.m_connectionProps, AbstractConnectionDetailsPanel.this.isCustom());
                        JDBCParametersPanel.editParameters(AbstractConnectionDetailsPanel.this.m_detailsPanel, connectionCreator, AbstractConnectionDetailsPanel.this.m_connectionProps);
                        AbstractConnectionDetailsPanel.this.populateConnectionDetails(AbstractConnectionDetailsPanel.this.m_connectionProps);
                    }
                }
            });
        }
        if (bl = collection.contains("customUrl")) {
            this.m_txtCustomURL = new JTextArea();
            this.m_txtCustomURL.setLineWrap(true);
            this.m_spCustomURL = new JScrollPane(this.m_txtCustomURL, 20, 31);
            if (this.m_detailsPanel == null) {
                JLabel jLabel = new JLabel();
                dBUIResourceHelper.resLabel(jLabel, (Component)this.m_txtCustomURL, this.getPropertyLabelText("customUrl"), "URL");
                object = jLabel;
            } else {
                this.m_chkCustomURL = new JCheckBox();
                this.m_chkCustomURL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AbstractConnectionDetailsPanel.this.setComponentsVisible(AbstractConnectionDetailsPanel.this.m_chkCustomURL.isSelected());
                    }
                });
                dBUIResourceHelper.resButton((AbstractButton)this.m_chkCustomURL, ConnBundle.get("CONN_CUSTOM_URL"), "Advanced");
                dBUIResourceHelper.setName((Component)this.m_txtCustomURL, "URL");
                object = this.m_chkCustomURL;
            }
            dBUILayoutHelper.add((Component)object);
        }
        if (this.m_btnSSH != null || this.m_btnParams != null) {
            object = dBUILayoutHelper.newChildHelper(bl ? 1 : 2, 1, true, false);
            object.add(Box.createHorizontalGlue(), 1, 1, true, false);
            if (this.m_btnParams != null) {
                object.add((Component)this.m_btnParams);
            }
            if (this.m_btnSSH != null) {
                object.add((Component)this.m_btnSSH);
            }
        }
        dBUILayoutHelper.nextRow();
        if (bl) {
            dBUILayoutHelper.add((Component)this.m_spCustomURL, 2, 1, true, true);
            dBUILayoutHelper.nextRow();
        }
        if (this.m_detailsPanel != null) {
            dBUILayoutHelper.add((Component)this.m_detailsPanel, 2, 1, true, true);
            dBUILayoutHelper.nextRow();
        }
    }

    protected abstract JPanel createDetailsPanel(DBUIResourceHelper var1);

    private void setComponentsVisible(boolean bl) {
        if (this.m_txtCustomURL != null) {
            this.resetCustomURL();
            if (this.m_detailsPanel != null) {
                if (bl) {
                    this.m_detailsPanel.setVisible(false);
                    this.m_spCustomURL.setVisible(true);
                } else {
                    this.m_spCustomURL.setVisible(false);
                    this.m_detailsPanel.setVisible(true);
                }
                this.ensureDialogSize();
            }
        }
    }

    protected final void resetCustomURL() {
        String string;
        if (this.isCustom() && (!ModelUtil.hasLength((String)(string = this.m_txtCustomURL.getText())) || ModelUtil.areEqual((Object)string, (Object)this.m_defaultURL))) {
            this.m_defaultURL = this.getDefaultURL();
            this.m_txtCustomURL.setText(this.m_defaultURL);
        }
    }

    protected String getDefaultURL() {
        String string = "jdbc:";
        String string2 = this.getDefaultProtocol();
        if (ModelUtil.hasLength((String)string2)) {
            string = string + string2 + ':';
        }
        return string;
    }

    protected String getDefaultProtocol() {
        String string = null;
        Map<String, String> map = this.getConnectionType().getDriverClasses();
        if (!map.isEmpty()) {
            string = map.entrySet().iterator().next().getValue();
        }
        return string;
    }

    public final void onEntry(TraversableContext traversableContext) {
        this.m_connectionProps = (Properties)traversableContext.get("NewObject");
        this.populateConnectionDetails(this.m_connectionProps);
    }

    @Override
    protected void populateConnectionDetails(Properties properties) {
        boolean bl;
        String string = properties.getProperty("customUrl");
        boolean bl2 = bl = string != null;
        if (this.m_txtCustomURL != null) {
            this.m_txtCustomURL.setText(string);
            if (this.m_chkCustomURL != null) {
                this.m_chkCustomURL.setSelected(bl);
            }
        }
        super.populateConnectionDetails(properties);
        this.setComponentsVisible(bl);
    }

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        this.m_connectionProps = (Properties)traversableContext.get("NewObject");
        boolean bl = this.isCustom();
        this.commitConnectionDetails(this.m_connectionProps, bl);
        this.validateConnectionDetails(this.m_connectionProps, bl);
    }

    private boolean isCustom() {
        return this.m_detailsPanel == null || this.m_chkCustomURL != null && this.m_chkCustomURL.isSelected();
    }

    protected void validateConnectionDetails(Properties properties, boolean bl) throws TraversalException {
        DatabaseConnectionHook.ConnectionType connectionType = this.getConnectionType();
        if (bl) {
            String string = properties.getProperty("customUrl");
            MissingDBConnValueException.check(string, connectionType.getPropertyDisplayName("customUrl"));
        } else {
            Collection collection = this.getConnectionCreator().listRequiredProperties();
            for (String string : collection) {
                MissingDBConnValueException.check(properties.getProperty(string), connectionType.getPropertyDisplayName(string));
                String string2 = properties.getProperty("port");
                if (!ModelUtil.hasLength((String)string2) || !string2.equals(String.valueOf(0))) continue;
                MissingDBConnValueException.check(null, connectionType.getPropertyDisplayName("port"));
            }
        }
    }

    protected void commitConnectionDetails(Properties properties, boolean bl) {
        if (bl) {
            this.setProperty(properties, "customUrl", this.getTrimmedText(this.m_txtCustomURL));
            for (String string : this.getRegisteredProperties()) {
                properties.remove(string);
            }
        } else {
            properties.remove("customUrl");
            super.commitConnectionDetails(properties);
        }
    }

    public Object getExitTransition() {
        return null;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    protected void ensureDialogSize() {
        if (this.m_panel != null) {
            this.m_panel.validate();
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.m_panel);
            if (window != null) {
                window.pack();
            }
        }
    }
}

