/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.combo.JTreeCombo;
import oracle.javatools.ui.combo.TreeComboModel;
import oracle.javatools.ui.combo.TreeComboRenderer;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class GlobalConnectionPicker
extends JTreeCombo {
    private final DefaultMutableTreeNode m_root;
    private final DefaultTreeModel m_treeModel;
    private final DatabaseConnectionStores m_stores;
    private final String[] m_subTypes;
    private ConnectionInfo m_info = new ConnectionInfo(null, null);
    private String m_singleStore;
    private String m_noConnectionString;
    private DefaultMutableTreeNode m_noConnectionNode;
    private boolean m_listening = true;
    private Collection<ItemListener> m_listeners;
    private Context m_context;
    private final List<DefaultMutableTreeNode> m_connNodes = new ArrayList<DefaultMutableTreeNode>();

    public GlobalConnectionPicker() {
        this(null);
    }

    public GlobalConnectionPicker(String ... stringArray) {
        this.m_subTypes = stringArray;
        this.m_stores = DatabaseConnectionStores.getInstance();
        JTree jTree = this.getTree();
        this.m_root = new DefaultMutableTreeNode("ROOT");
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        jTree.setModel(this.m_treeModel);
        this.setModel((ComboBoxModel)((Object)new M(jTree)));
        this.setRootVisible(false);
        this.setTreeComboRenderer(new R());
        this.setMinimumPopupSize(new Dimension(160, jTree.getRowHeight()));
    }

    public void setNoConnectionString(String string) {
        this.m_noConnectionString = string;
        this.resetConnections();
    }

    public int resetConnections() {
        Object object;
        this.m_root.removeAllChildren();
        this.m_connNodes.clear();
        if (ModelUtil.hasLength((String)this.m_noConnectionString)) {
            this.m_noConnectionNode = new DefaultMutableTreeNode(this.m_noConnectionString);
            this.m_root.add(this.m_noConnectionNode);
            this.m_connNodes.add(this.m_noConnectionNode);
        } else {
            this.m_noConnectionNode = null;
        }
        Collection<String> collection = this.listStores();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            DatabaseConnections databaseConnections = this.m_stores.getStore((String)object);
            if (databaseConnections == null) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(databaseConnections.getStoreName());
            for (String string : new TreeSet<String>(this.listConnections(databaseConnections))) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)new ConnectionInfo((String)object, string));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.m_connNodes.add(defaultMutableTreeNode2);
            }
            this.m_root.add(defaultMutableTreeNode);
        }
        this.m_singleStore = null;
        if (this.isSingleStoreCollapsible() && this.m_root.getChildCount() == 1) {
            object2 = (DefaultMutableTreeNode)this.m_root.getFirstChild();
            this.m_singleStore = (String)((DefaultMutableTreeNode)object2).getUserObject();
            this.m_root.remove((MutableTreeNode)object2);
            while (((DefaultMutableTreeNode)object2).getChildCount() > 0) {
                object = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getChildAt(0);
                ((DefaultMutableTreeNode)object2).remove(0);
                this.m_root.add((MutableTreeNode)object);
            }
        }
        this.m_treeModel.reload(this.m_root);
        this.expandAll();
        if (!this.m_info.isValid() && (object2 = this.getDefaultConnectionInfo()) != null) {
            object2.copyTo((Object)this.m_info);
        }
        this.selectCurrentConnection();
        return this.m_connNodes.size();
    }

    protected ConnectionInfo getDefaultConnectionInfo() {
        ConnectionInfo connectionInfo;
        if (this.m_noConnectionString == null) {
            connectionInfo = this.m_stores.getCurrentConnectionInfo(this.m_context);
            if (connectionInfo == null) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object;
                if (this.m_singleStore == null) {
                    DefaultMutableTreeNode defaultMutableTreeNode2;
                    object = this.m_stores.getCurrentStore(this.m_context);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2 = object == null ? null : this.findNode(this.m_root, ((DatabaseConnections)object).getStoreName());
                    defaultMutableTreeNode = defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getChildCount() > 0 ? defaultMutableTreeNode2 : this.getFirstChildWithChildren(this.m_root);
                } else {
                    defaultMutableTreeNode = this.m_root;
                }
                if (defaultMutableTreeNode != null) {
                    try {
                        object = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                        connectionInfo = (ConnectionInfo)((Object)((DefaultMutableTreeNode)object).getUserObject());
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
        } else {
            connectionInfo = new ConnectionInfo(null, null);
        }
        return connectionInfo;
    }

    private DefaultMutableTreeNode getFirstChildWithChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode3.getChildCount() <= 0) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        return defaultMutableTreeNode2;
    }

    protected boolean isSingleStoreCollapsible() {
        return true;
    }

    public Collection<String> listStores() {
        return this.m_stores.listStores(this.m_context);
    }

    public Collection<String> listConnections(DatabaseConnections databaseConnections) {
        return databaseConnections.listConnections(this.m_subTypes);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.m_info;
    }

    public Database getDatabase() {
        ConnectionInfo connectionInfo = this.getConnectionInfo();
        Database database = null;
        if (connectionInfo != null) {
            try {
                database = connectionInfo.getDatabase();
            }
            catch (DBException dBException) {
                DBExceptionDialog.showErrorDialog((Component)((Object)this), null, (DBException)dBException);
            }
        }
        return database;
    }

    public void setContext(Context context) {
        this.m_context = context;
        this.clearConnectionInfo();
        this.resetConnections();
    }

    public Context getContext() {
        return this.m_context;
    }

    private void clearConnectionInfo() {
        this.m_info.setStoreName(null);
        this.m_info.setConnectionName(null);
    }

    public void setDatabase(Database database) {
        String string = database == null ? null : database.getConnectionStore();
        String string2 = database == null ? null : database.getConnectionName();
        this.setConnectionInfo(string, string2);
    }

    public void setConnectionInfo(String string, String string2) {
        ConnectionInfo connectionInfo = new ConnectionInfo(string, string2);
        if (connectionInfo.isValid()) {
            this.m_info.setStoreName(string);
            this.m_info.setConnectionName(string2);
            this.selectCurrentConnection();
        } else if (this.m_noConnectionString != null) {
            this.clearConnectionInfo();
            this.selectCurrentConnection();
        }
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        if (connectionInfo != null) {
            this.m_info = connectionInfo;
            this.selectCurrentConnection();
        }
    }

    private void selectCurrentConnection() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.m_info.isValid()) {
            object = this.m_singleStore != null ? this.m_root : this.findNode(this.m_root, this.m_info.getStoreName());
            if (object != null) {
                defaultMutableTreeNode = this.findNode((DefaultMutableTreeNode)object, (Object)this.m_info);
            }
        } else if (this.m_noConnectionString != null) {
            defaultMutableTreeNode = this.m_noConnectionNode;
        }
        object = this.getSelectedItem();
        if (defaultMutableTreeNode == null) {
            this.populateConnectionInfo(object);
        } else if (defaultMutableTreeNode != object) {
            this.setSelectedItem(defaultMutableTreeNode);
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!ModelUtil.areEqual((Object)defaultMutableTreeNode3.getUserObject(), (Object)object)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        return defaultMutableTreeNode2;
    }

    public void addComboListener(ItemListener itemListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<ItemListener>();
        }
        this.m_listeners.add(itemListener);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            this.populateConnectionInfo(object);
        }
        super.fireItemStateChanged(itemEvent);
    }

    private void populateConnectionInfo(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        }
        if (object instanceof ConnectionInfo) {
            if (!object.equals((Object)this.m_info)) {
                ((ConnectionInfo)((Object)object)).copyTo((Object)this.m_info);
            }
        } else if (ModelUtil.areEqual((Object)object, (Object)this.m_noConnectionString)) {
            this.clearConnectionInfo();
        }
    }

    private class R
    extends DefaultTreeCellRenderer
    implements TreeComboRenderer {
        private R() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel && object instanceof DefaultMutableTreeNode) {
                this.renderLabel((DefaultMutableTreeNode)object, (JLabel)component);
            }
            return component;
        }

        private void renderLabel(DefaultMutableTreeNode defaultMutableTreeNode, JLabel jLabel) {
            Icon icon;
            String string;
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ConnectionInfo) {
                string = ((ConnectionInfo)((Object)object)).getConnectionName();
                icon = OracleIcons.getIcon((String)"database.png");
            } else if (ModelUtil.areEqual((Object)object, (Object)GlobalConnectionPicker.this.m_noConnectionString)) {
                string = GlobalConnectionPicker.this.m_noConnectionString;
                icon = IdeIcons.getIcon((int)23);
            } else {
                string = GlobalConnectionPicker.this.m_stores.getShortLabel((String)object);
                icon = GlobalConnectionPicker.this.m_stores.getIcon((String)object);
            }
            jLabel.setText(string);
            jLabel.setIcon(GlobalConnectionPicker.this.m_singleStore == null ? icon : null);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = new JLabel();
            if (object instanceof DefaultMutableTreeNode) {
                String string = null;
                if (object == GlobalConnectionPicker.this.m_noConnectionNode) {
                    string = GlobalConnectionPicker.this.m_noConnectionString;
                } else if ((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof ConnectionInfo) {
                    String string2;
                    string = ((ConnectionInfo)((Object)object)).getConnectionName();
                    if (GlobalConnectionPicker.this.m_singleStore == null && (string2 = ((ConnectionInfo)((Object)object)).getStoreName()) != null) {
                        string = string + " (" + GlobalConnectionPicker.this.m_stores.getShortLabel(string2) + ")";
                    }
                }
                jLabel.setText(string);
            }
            return jLabel;
        }
    }

    private class M
    extends TreeComboModel {
        M(JTree jTree) {
            super(jTree);
        }

        public int getSize() {
            return GlobalConnectionPicker.this.m_connNodes.size();
        }

        public Object getElementAt(int n) {
            return GlobalConnectionPicker.this.m_connNodes.get(n);
        }

        public void setSelectedItem(Object object) {
            if (GlobalConnectionPicker.this.m_connNodes.contains(object)) {
                super.setSelectedItem(object);
            }
        }
    }
}

