/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class CAConnectionCreator
extends DatabaseFactory.ConnectionCreator {
    private final String m_storeName;
    private final DatabaseContextManager.ContextWrapper m_wrapper;

    public CAConnectionCreator() {
        this("IdeConnections", null);
    }

    public CAConnectionCreator(String string, DatabaseContextManager.ContextWrapper contextWrapper) {
        this.m_storeName = string;
        this.m_wrapper = contextWrapper;
    }

    protected Connection createConnectionImpl(String string) throws DBException {
        try {
            Object object;
            Context context = this.m_wrapper == null && "IdeConnections".equals(this.m_storeName) ? DatabaseContextManager.getDatabaseContext() : this.m_wrapper.getDatabaseContext();
            if (context != null && (object = context.lookup(string)) instanceof DatabaseProvider) {
                return ((DatabaseProvider)object).getConnection();
            }
        }
        catch (CancelledSQLException cancelledSQLException) {
            throw new CancelledException();
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        catch (NamingException namingException) {
            throw new DBException((Throwable)namingException);
        }
        return null;
    }

    protected String getStoreName() {
        return this.m_storeName;
    }

    protected String getDisplayableStoreName() {
        return DatabaseConnectionStores.getInstance().getShortLabel(this.m_storeName);
    }
}

