/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.ui.list.SimpleListModel;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.resource.ConnBundle;

public class ConnectionList
extends JPanel {
    private NiceList m_list = new NiceList();
    private final SimpleListModel<String> m_listModel = new SimpleListModel();
    private String m_storeName;
    private boolean m_oracleOnly;
    private String m_chosen;
    private Collection<ActionListener> m_listeners;

    public ConnectionList(String string) {
        this(string, false);
    }

    public ConnectionList(String string, boolean bl) {
        this.m_oracleOnly = bl;
        this.m_list.setModel(this.m_listModel);
        this.m_list.setFireCheckboxActionOnSelectionChanged(true);
        this.m_list.setSelectionMode(0);
        this.m_list.setVisibleRowCount(5);
        this.m_list.setCellRenderer((ListCellRenderer)((Object)new Renderer()));
        this.m_list.addListActionListener(new NiceListActionListener(){

            public void listActionPerformed(NiceListActionEvent niceListActionEvent) {
                if (niceListActionEvent.getRow() < 0) {
                    return;
                }
                if (niceListActionEvent.getType() == NiceListActionEvent.Type.CHECKBOX) {
                    ConnectionList.this.changeSelection(niceListActionEvent.getRow());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.m_list), "Center");
        this.setStoreName(string);
    }

    private void changeSelection(int n) {
        String string = this.m_chosen;
        this.m_chosen = (String)this.m_listModel.getElementAt(n);
        if (ModelUtil.areDifferent((Object)string, (Object)this.m_chosen)) {
            this.m_listModel.changed(n);
            for (int i = 0; i < this.m_listModel.getSize(); ++i) {
                String string2 = (String)this.m_listModel.getElementAt(i);
                if (!ModelUtil.areEqual((Object)string2, (Object)string)) continue;
                this.m_listModel.changed(i);
            }
            this.fireChangeEvent();
        }
    }

    private void fireChangeEvent() {
        if (this.m_listeners != null) {
            ActionEvent actionEvent = new ActionEvent(this, 0, null);
            for (ActionListener actionListener : this.m_listeners) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public final String getStoreName() {
        return this.m_storeName;
    }

    public final void setStoreName(String string) {
        if (string != null && !string.equals(this.m_storeName)) {
            this.m_storeName = string;
            this.initList();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<ActionListener>();
        }
        this.m_listeners.add(actionListener);
    }

    private void initList() {
        this.m_list.clearSelection();
        this.m_listModel.removeAll();
        this.m_chosen = null;
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(this.m_storeName);
        if (databaseConnections != null) {
            for (String string : new TreeSet<String>(databaseConnections.listConnections(this.m_oracleOnly))) {
                this.m_listModel.addElement((Object)string);
            }
        }
        this.fireChangeEvent();
    }

    public Component getListComponent() {
        return this.m_list;
    }

    public String getConnectionName() {
        return (String)this.m_list.getSelectedValue();
    }

    public static final String chooseIdeConnection() {
        return ConnectionList.chooseConnection("IdeConnections", ConnBundle.get("CHOOSE_CENTRAL_STORE_TITLE"));
    }

    public static final String chooseConnection(String string, String string2) {
        ConnectionList connectionList = new ConnectionList(string);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)Ide.getMainWindow(), (String)string2, (int)3);
        jEWTDialog.setContent((Component)connectionList);
        jEWTDialog.setName("ConnectionListDialog");
        if (jEWTDialog.runDialog()) {
            return connectionList.getConnectionName();
        }
        return null;
    }

    private class Renderer
    extends NiceListRenderer<String> {
        private Map<String, String> m_urls = new HashMap<String, String>();

        Renderer() {
            this.setRadioButtonStyle(true);
        }

        protected boolean isItemSelected(String string) {
            return ModelUtil.areEqual((Object)string, (Object)ConnectionList.this.m_chosen);
        }

        protected String getTitle(String string) {
            return string;
        }

        protected String getDescription(String string) {
            return this.getURL(string);
        }

        private String getURL(String string) {
            if (this.m_urls.containsKey(string)) {
                return this.m_urls.get(string);
            }
            String string2 = ConnBundle.get("CONNECT_STRING_ERROR");
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(ConnectionList.this.m_storeName);
            if (databaseConnections != null) {
                try {
                    DatabaseProvider databaseProvider = databaseConnections.getReferenceable(string);
                    if (databaseProvider instanceof DatabaseProvider) {
                        try {
                            String string3 = databaseProvider.getProperty("user");
                            String string4 = databaseProvider.getConnectionURL();
                            string2 = ConnBundle.format("CENTRAL_STORE_DESC", string3, string4);
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            this.m_urls.put(string, string2);
            return string2;
        }
    }
}

