/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.resource.ConnBundle;

public class ConnectionDetails
extends JPanel {
    private JLabel m_usernameLabel;
    private JLabel m_usernameField;
    private JLabel m_driverLabel;
    private JLabel m_driverField;
    private JLabel m_urlLabel;
    private JLabel m_urlField;

    public ConnectionDetails() {
        this.layoutComponents(this);
    }

    private void layoutComponents(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("ConnectionDetails");
        this.m_usernameLabel = new JLabel();
        this.m_usernameField = new JLabel();
        this.m_usernameLabel.setText(ConnBundle.get("LABEL_USERNAME"));
        this.m_usernameLabel.setEnabled(false);
        this.m_usernameField.setName("ConnectionDetails.USER");
        this.m_driverLabel = new JLabel();
        this.m_driverField = new JLabel();
        this.m_driverLabel.setText(ConnBundle.get("LABEL_DRIVER"));
        this.m_driverLabel.setEnabled(false);
        this.m_driverField.setName("ConnectionDetails.DRIVER");
        this.m_urlLabel = new JLabel();
        this.m_urlField = new JLabel();
        this.m_urlLabel.setText(ConnBundle.get("LABEL_URL"));
        this.m_urlLabel.setEnabled(false);
        this.m_urlField.setName("ConnectionDetails.URL");
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.m_usernameLabel, gridBagConstraints);
        jPanel.add((Component)this.m_usernameField, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.m_driverLabel, gridBagConstraints);
        jPanel.add((Component)this.m_driverField, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.m_urlLabel, gridBagConstraints);
        jPanel.add((Component)this.m_urlField, gridBagConstraints2);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_usernameLabel.setEnabled(bl);
        this.m_driverLabel.setEnabled(bl);
        this.m_urlLabel.setEnabled(bl);
        if (!bl) {
            this.m_usernameField.setText(null);
            this.m_driverField.setText(null);
            this.m_urlField.setText(null);
            this.m_urlField.setToolTipText(null);
        }
    }

    public void populateDetails(ConnectionInfo connectionInfo) {
        this.populateDetails(connectionInfo == null ? null : connectionInfo.getReferenceable());
    }

    public void populateDetails(DatabaseProvider databaseProvider) {
        this.setEnabled(databaseProvider != null);
        this.m_usernameField.setText(ConnectionDetails.getUserName(databaseProvider));
        this.m_driverField.setText(ConnectionDetails.getDriverClassName(databaseProvider));
        String string = ConnectionDetails.getConnectionURL(databaseProvider);
        this.m_urlField.setText(string);
        this.m_urlField.setToolTipText(string);
    }

    private static String getUserName(DatabaseProvider databaseProvider) {
        return databaseProvider == null ? null : databaseProvider.getProperty("user");
    }

    private static String getDriverClassName(DatabaseProvider databaseProvider) {
        String string = null;
        try {
            string = databaseProvider == null ? null : databaseProvider.getDriverClassName();
        }
        catch (SQLException sQLException) {
            string = null;
        }
        return string;
    }

    private static String getConnectionURL(DatabaseProvider databaseProvider) {
        String string = null;
        try {
            string = databaseProvider == null ? null : databaseProvider.getConnectionURL();
        }
        catch (SQLException sQLException) {
            string = null;
        }
        return string;
    }

    public static String getTooltipText(ConnectionInfo connectionInfo) {
        String string = null;
        if (connectionInfo != null) {
            string = ConnectionDetails.getTooltipText(connectionInfo.getReferenceable());
        }
        return string;
    }

    public static String getTooltipText(DatabaseProvider databaseProvider) {
        String string = null;
        if (databaseProvider != null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(ConnBundle.get("LABEL_USERNAME"), ConnectionDetails.getUserName(databaseProvider));
            linkedHashMap.put(ConnBundle.get("LABEL_DRIVER"), ConnectionDetails.getDriverClassName(databaseProvider));
            linkedHashMap.put(ConnBundle.get("LABEL_URL"), ConnectionDetails.getConnectionURL(databaseProvider));
            string = DBUIResourceHelper.createPropertiesText(linkedHashMap);
        }
        return string;
    }
}

