/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import javax.naming.Context;
import javax.naming.NamingException;
import oracle.ide.Ide;
import oracle.ide.model.SingletonProvider;
import oracle.ideri.util.Product;
import oracle.jdevimpl.db.adapter.DefaultContextWrapper;

public class DatabaseContextManager {
    private static ContextWrapper s_wrapper;

    private DatabaseContextManager() {
    }

    public static Context getDatabaseContext() {
        ContextWrapper contextWrapper = DatabaseContextManager.getContextWrapper();
        return contextWrapper == null ? null : contextWrapper.getDatabaseContext();
    }

    public static void setContextWrapper(ContextWrapper contextWrapper) {
        s_wrapper = contextWrapper;
    }

    public static ContextWrapper getContextWrapper() {
        if (s_wrapper == null && Ide.isRunning() && (s_wrapper = (ContextWrapper)SingletonProvider.find(ContextWrapper.class)) == null) {
            if (Product.isJDeveloper()) {
                throw new IllegalStateException("No database connection context wrapper has been set.");
            }
            s_wrapper = DefaultContextWrapper.getInstance();
        }
        return s_wrapper;
    }

    public static interface ContextWrapper {
        public Context getDatabaseContext();

        public void saveDatabaseContext() throws NamingException;
    }
}

