/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.model.SingletonProvider;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.DefaultConnectionEditorLauncher;

public final class DatabaseConnectionEditor {
    private static Class<? extends DatabaseConnectionEditorLauncher> s_launcher;

    private DatabaseConnectionEditor() {
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DatabaseConnectionEditor.class);
    }

    private static ConnectionInfo launchEditor(String string, String string2, boolean bl) {
        DatabaseConnectionEditorLauncher databaseConnectionEditorLauncher = DatabaseConnectionEditor.createLauncher();
        if (bl) {
            databaseConnectionEditorLauncher.setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.ALL);
        }
        DatabaseConnections databaseConnections = ModelUtil.hasLength((String)string) ? DatabaseConnectionStores.getInstance().getStore(string) : null;
        return databaseConnectionEditorLauncher.launchEditor(databaseConnections, string2);
    }

    @Deprecated
    public static void setEditor(Class<? extends ConnectionEditor> clazz) {
    }

    @Deprecated
    public static void setLauncher(Class<? extends DatabaseConnectionEditorLauncher> clazz) {
        if (clazz != null && !Product.isJDeveloper()) {
            s_launcher = clazz;
        }
    }

    public static DatabaseConnectionEditorLauncher createLauncher() {
        DatabaseConnectionEditorLauncher databaseConnectionEditorLauncher = (DatabaseConnectionEditorLauncher)SingletonProvider.find(DatabaseConnectionEditorLauncher.class);
        try {
            if (databaseConnectionEditorLauncher != null) {
                databaseConnectionEditorLauncher = (DatabaseConnectionEditorLauncher)databaseConnectionEditorLauncher.getClass().newInstance();
            } else if (s_launcher != null) {
                databaseConnectionEditorLauncher = s_launcher.newInstance();
            }
        }
        catch (Exception exception) {
            DatabaseConnectionEditor.getLogger().log(Level.SEVERE, "Cannot create db connection editor", exception);
        }
        return databaseConnectionEditorLauncher == null ? new DefaultConnectionEditorLauncher() : databaseConnectionEditorLauncher;
    }

    @Deprecated
    public static String editConnection(String string) {
        return null;
    }

    public static String editConnection(String string, String string2) {
        return DatabaseConnectionEditor.editConnection(string, string2, false);
    }

    public static String editConnection(String string, String string2, boolean bl) {
        ConnectionInfo connectionInfo = DatabaseConnectionEditor.launchEditor(string, string2, bl);
        return connectionInfo == null ? null : connectionInfo.getConnectionName();
    }

    public static ConnectionInfo editConnection(ConnectionInfo connectionInfo, boolean bl) {
        return DatabaseConnectionEditor.launchEditor(connectionInfo == null ? null : connectionInfo.getStoreName(), connectionInfo == null ? null : connectionInfo.getConnectionName(), bl);
    }

    @Deprecated
    public static interface ConnectionEditor {
        public String launchEditor(String var1);

        public String launchEditor(String var1, String var2);
    }
}

