/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.inspector.AbstractPropertyInspectorPanel;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.LabelContainer;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.layout.Property;

abstract class AbstractFormLayoutPanel
extends AbstractPropertyInspectorPanel {
    static final int PROPERTY_MAX_COLUMNS = 4;
    private int maxColumns = 4;

    AbstractFormLayoutPanel() {
    }

    final int maxColumns() {
        return this.maxColumns;
    }

    final void updateMaxColumns(int columnCount) {
        if (this.maxColumns < columnCount) {
            this.maxColumns = columnCount;
        }
    }

    final boolean propertyRendered(Object o, int editorWidth, int startCell, Properties properties, Orientation orientation) {
        if (!this.isProperty(o)) {
            return false;
        }
        PropertyInfo property = this.propertyFromLayout((Property)o, properties);
        if (property != null) {
            this.renderProperty(property, editorWidth, startCell, orientation);
        }
        return true;
    }

    final boolean isProperty(Object o) {
        return o instanceof Property;
    }

    final PropertyInfo propertyFromLayout(Property property, Properties properties) {
        String idFromLayout = property.getID();
        return properties.propertyById(idFromLayout);
    }

    final boolean visibleProperty(Property property, Properties properties) {
        PropertyInfo realProperty = this.propertyFromLayout(property, properties);
        if (realProperty != null) {
            return !realProperty.hidden();
        }
        return false;
    }

    final void render(JLabel label, Component editor, int editorWidth, int startCell, Properties properties) {
        LabelAndEditor labelAndEditor = new LabelAndEditor(new LabelContainer(label), new EditorContainer(editor));
        LabelAndEditor containers = this.render(RenderingUtils.emptyIconContainer(), labelAndEditor, editorWidth, startCell);
        if (!(editor instanceof JComponent)) {
            return;
        }
        properties.updateCustomComponent(containers.editorContainer(), (JComponent)editor, containers.labelContainer());
    }
}

