/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.Editors;
import oracle.ide.controller.Command;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.Selection;

public class UndoableEditCommand
extends Command {
    private final List<UndoableEdit> edits = new ArrayList<UndoableEdit>();
    private URL initialUrl;
    private Project initialProject;
    private Workspace initialWorkspace;
    private int initialSelectionOffset;
    private int initialSelectionLength;
    private URL selectionUrl;
    private int selectionOffset = -1;
    private int selectionLength;
    private boolean neverDone = true;
    private List<Selection> initialMultiSelections = Collections.emptyList();
    private List<Selection> multiSelections = Collections.emptyList();

    public UndoableEditCommand(String name, Context context) {
        this(name, context, true);
    }

    public UndoableEditCommand(String name, TextNode node, Project project, Workspace workspace) {
        this(name, new Context(null, workspace, project, (Node)node), true);
    }

    public UndoableEditCommand(String name, Context context, boolean initialSelection) {
        super(Ide.findOrCreateCmdID((String)name), 0, name);
        Editor editor;
        EditorManager editorManager;
        this.setContext(context);
        if (initialSelection && EventQueue.isDispatchThread() && (editorManager = EditorManager.getEditorManager()) != null && (editor = editorManager.getCurrentEditor()) instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            Context editorContext = codeEditor.getContext();
            this.initialWorkspace = editorContext.getWorkspace();
            this.initialProject = editorContext.getProject();
            this.initialUrl = editorContext.getNode().getURL();
            this.initialSelectionOffset = codeEditor.getSelectionStart();
            this.initialSelectionLength = codeEditor.getSelectionEnd() - this.initialSelectionOffset;
            this.initialMultiSelections = codeEditor.getFocusedEditorPane().getMultiSelections();
        }
    }

    public UndoableEditCommand(String name, TextNode node, Project project, Workspace workspace, int selectionStart, int selectionEnd) {
        this(name, new Context(null, workspace, project, (Node)node), true);
        this.initialWorkspace = workspace;
        this.initialProject = project;
        this.initialUrl = node.getURL();
        this.initialSelectionOffset = selectionStart;
        this.initialSelectionLength = selectionEnd - this.initialSelectionOffset;
    }

    public UndoableEditCommand(String name, TextNode node, Project project, Workspace workspace, int selectionStart, int selectionEnd, List<Selection> multiSelections) {
        this(name, new Context(null, workspace, project, (Node)node), true);
        this.initialWorkspace = workspace;
        this.initialProject = project;
        this.initialUrl = node.getURL();
        this.initialSelectionOffset = selectionStart;
        this.initialSelectionLength = selectionEnd - this.initialSelectionOffset;
        this.initialMultiSelections = new ArrayList<Selection>(multiSelections);
    }

    public UndoableEditCommand(String name, TextNode node, Project project, Workspace workspace, boolean initialSelection) {
        this(name, new Context(null, workspace, project, (Node)node), initialSelection);
    }

    public void addEdit(UndoableEdit edit) {
        if (edit != null) {
            this.edits.add(edit);
        }
    }

    public void addEdits(Collection<UndoableEdit> edits) {
        for (UndoableEdit edit : edits) {
            this.addEdit(edit);
        }
    }

    public boolean hasEdits() {
        return !this.edits.isEmpty();
    }

    public void setSelection(URL url, int offset, int length) {
        this.selectionUrl = url;
        this.selectionOffset = offset;
        this.selectionLength = length;
    }

    public void setSelection(int offset, int length) {
        this.selectionUrl = this.context.getNode().getURL();
        this.selectionOffset = offset;
        this.selectionLength = length;
    }

    public void setMultiSelections(List<Selection> multiSelections) {
        this.multiSelections = new ArrayList<Selection>(multiSelections);
    }

    public int doit() throws Exception {
        if (this.neverDone) {
            this.neverDone = false;
            this.doOnceHook();
        } else {
            for (UndoableEdit edit : this.edits) {
                edit.redo();
            }
        }
        if (EventQueue.isDispatchThread() && this.selectionUrl != null) {
            this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.selectionUrl, this.selectionOffset, this.selectionLength, this.multiSelections);
        }
        this.fireStructureChanged();
        return 0;
    }

    protected void doOnceHook() throws Exception {
    }

    public int undo() throws Exception {
        int i = this.edits.size();
        while (i-- > 0) {
            UndoableEdit edit = this.edits.get(i);
            edit.undo();
        }
        if (EventQueue.isDispatchThread() && this.initialUrl != null) {
            this.changeSelection(this.initialWorkspace, this.initialProject, this.initialUrl, this.initialSelectionOffset, this.initialSelectionLength, this.initialMultiSelections);
        }
        this.fireStructureChanged();
        return 0;
    }

    private void changeSelection(Workspace workspace, Project project, URL url, int offset, int length, List<Selection> multiSelections) {
        BasicEditorPaneContainer basicEditorPaneContainer;
        BasicEditorPane editorPane;
        Editor editor = Editors.editNode2(workspace, project, NodeFactory.find((URL)url), offset, length, false);
        if (editor instanceof BasicEditorPaneContainer && (editorPane = (basicEditorPaneContainer = (BasicEditorPaneContainer)editor).getFocusedEditorPane()) != null) {
            editorPane.setMultiSelections(multiSelections);
        }
    }

    private void fireStructureChanged() {
        Node node = this.context.getNode();
        UpdateMessage message = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)node);
        node.notifyObservers((Object)node, message);
    }
}

