/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.authentication;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.adf.share.jndi.ConnectionReference;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;

public final class AuthenticationConnection
implements Referenceable,
ObjectFactory {
    private static final String ATTR_SUCCESSURL = "success_url";
    private static final String ATTR_ENDURL = "end_url";
    private static final String CLASSNAME = AuthenticationConnection.class.getName();
    private String _successUrl = null;
    private String _endUrl = null;
    private String _name = null;
    private static final ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();

    public AuthenticationConnection() {
        this._name = "";
    }

    public AuthenticationConnection(String name, Reference ref) {
        this._name = name;
        if (ref.getClassName().equals(CLASSNAME)) {
            RefAddr addr = ref.get(ATTR_SUCCESSURL);
            if (addr != null && addr instanceof StringRefAddr) {
                String loginUrl = (String)addr.getContent();
                this.setSuccessUrl(loginUrl.trim());
                if (_adfSecLogger.isFinest()) {
                    _adfSecLogger.log(Level.FINEST, "success_url: " + loginUrl);
                }
            }
            if ((addr = ref.get(ATTR_ENDURL)) != null && addr instanceof StringRefAddr) {
                String logoutUrl = (String)addr.getContent();
                this.setEndUrl(logoutUrl.trim());
                if (_adfSecLogger.isFinest()) {
                    _adfSecLogger.log(Level.FINEST, "end_url: " + logoutUrl);
                }
            }
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        if (ref.getClassName().equals(CLASSNAME)) {
            AuthenticationConnection conn = new AuthenticationConnection();
            RefAddr addr = ref.get(ATTR_SUCCESSURL);
            if (addr != null && addr instanceof StringRefAddr) {
                String loginUrl = (String)addr.getContent();
                conn.setSuccessUrl(loginUrl.trim());
                if (_adfSecLogger.isFinest()) {
                    _adfSecLogger.log(Level.FINEST, "success_url: " + loginUrl);
                }
            }
            if ((addr = ref.get(ATTR_ENDURL)) != null && addr instanceof StringRefAddr) {
                String logoutUrl = (String)addr.getContent();
                conn.setEndUrl(logoutUrl.trim());
                if (_adfSecLogger.isFinest()) {
                    _adfSecLogger.log(Level.FINEST, "end_url: " + logoutUrl);
                }
            }
            return conn;
        }
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        ConnectionReference ref = new ConnectionReference(this.getClass().getName(), CLASSNAME, null);
        ref.add(new StringRefAddr(ATTR_SUCCESSURL, this._successUrl));
        ref.add(new StringRefAddr(ATTR_ENDURL, this._endUrl));
        return ref;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setSuccessUrl(String successUrl) {
        this._successUrl = successUrl;
    }

    public String getSuccessUrl() {
        return this._successUrl;
    }

    public void setEndUrl(String endUrl) {
        this._endUrl = endUrl;
    }

    public String getEndUrl() {
        return this._endUrl;
    }
}

