/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.util.logging.Level;
import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextImpl;
import oracle.adf.share.security.resource.ADFSecurityMessages;
import oracle.javatools.annotations.Concealed;

public final class SecurityContextUtils {
    private static final ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    private static final String CLASS_NAME = SecurityContextUtils.class.getName();
    private static final String ALLOWED_CALLER = "oracle.jbo.server.svc.ServiceJTATxnHandlerImpl";

    @Concealed
    public static void setPolicyContextId(String appId) {
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        if (secCtx != null && SecurityContextImpl.class.isAssignableFrom(secCtx.getClass())) {
            if (!SecurityContextUtils.isAllowedClass()) {
                throw new ADFSecurityRuntimeException(ADFSecurityMessages.get("EXC_POLICY_OPERATION_NOT_GRANTED"));
            }
            ((SecurityContextImpl)secCtx).setPolicyContextId(appId);
        } else if (_adfSecLogger.isFinest()) {
            _adfSecLogger.log(Level.FINEST, "setPolicContextId not available.");
        }
    }

    @Concealed
    public static String getPolicyContextId() {
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        if (secCtx != null && SecurityContextImpl.class.isAssignableFrom(secCtx.getClass())) {
            return ((SecurityContextImpl)secCtx).getPolicyContextId();
        }
        return null;
    }

    static final boolean isAllowedClass() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < elements.length; ++i) {
            if (CLASS_NAME.equals(elements[i].getClassName())) continue;
            if (!ALLOWED_CALLER.equals(elements[i].getClassName())) break;
            return true;
        }
        return false;
    }
}

