/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.util.Map;
import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.TenantInfo;
import oracle.adf.share.security.identitymanagement.UserProfile;

public class FallbackTenantInfo
extends TenantInfo {
    private static final ADFLogger logger = ADFSecurityUtil.getADFLogger();
    private static final String SESSION_ENTERPRISE_ID = "SESSION_ENTERPRISE_ID";
    private static final String SESSION_ENTERPRISE_NAME = "SESSION_ENTERPRISE_NAME";
    private static final String SESSION_KEY_CACHED = "CACHED";
    private static final String SESSION_KEY_VALUE = "VALUE";
    private static final String SESSION_KEY_SEPARATOR = "_";
    private static final String TENANT_GUID = "TENANT_GUID";
    private static final String TENANT_NAME = "TENANT_NAME";

    @Override
    protected String internalGetTenantId() {
        String eid = this.getTenantProperty(TenantInfo.TenantInfoType.TENANT_ID);
        return eid;
    }

    @Override
    protected String internalGetTenantName() {
        String name = this.getTenantProperty(TenantInfo.TenantInfoType.TENANT_NAME);
        return name == null ? "" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTenantProperty(TenantInfo.TenantInfoType infoType) {
        String name;
        String eid;
        String requestValueKeyTenantName;
        String requestValueKeyTenantId;
        String requestCachedKey;
        Map requestScope;
        block17: {
            ADFContext adfContext = ADFContext.getCurrent();
            requestScope = adfContext.getRequestScope();
            requestCachedKey = this.getSessionKey(SESSION_ENTERPRISE_ID, SESSION_KEY_CACHED, null);
            requestValueKeyTenantId = this.getSessionKey(SESSION_ENTERPRISE_ID, SESSION_KEY_VALUE, null);
            requestValueKeyTenantName = this.getSessionKey(SESSION_ENTERPRISE_NAME, SESSION_KEY_VALUE, null);
            if (adfContext.isJEE() && Boolean.TRUE.equals(requestScope.get(requestCachedKey))) {
                String value = infoType == TenantInfo.TenantInfoType.TENANT_ID ? (String)requestScope.get(requestValueKeyTenantId) : (String)requestScope.get(requestValueKeyTenantName);
                return value;
            }
            eid = null;
            name = "";
            Map sessionScope = adfContext.getSessionScope();
            try {
                Map map = sessionScope;
                synchronized (map) {
                    SecurityContext context = adfContext.getSecurityContext();
                    if (context != null && context.isAuthenticated()) {
                        String userName = context.getUserName();
                        String sessionCachedKey = this.getSessionKey(SESSION_ENTERPRISE_ID, SESSION_KEY_CACHED, userName);
                        String sessionValueKeyTenantId = this.getSessionKey(SESSION_ENTERPRISE_ID, SESSION_KEY_VALUE, userName);
                        String sessionValueKeyTenantName = this.getSessionKey(SESSION_ENTERPRISE_NAME, SESSION_KEY_VALUE, userName);
                        if (Boolean.TRUE.equals(sessionScope.get(sessionCachedKey))) {
                            eid = (String)sessionScope.get(sessionValueKeyTenantId);
                            name = (String)sessionScope.get(sessionValueKeyTenantName);
                        } else {
                            block16: {
                                try {
                                    UserProfile userProfile = context.getUserProfile();
                                    if (userProfile != null) {
                                        eid = (String)userProfile.getProperty(TENANT_GUID);
                                        if (eid != null) {
                                            sessionScope.put(sessionValueKeyTenantId, eid);
                                        }
                                        if ((name = (String)userProfile.getProperty(TENANT_NAME)) != null && name.length() > 0) {
                                            sessionScope.put(sessionValueKeyTenantName, name);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    if (!logger.isFinest()) break block16;
                                    logger.finest("Failed to lookup enterprise property for user " + userName, (Throwable)e);
                                }
                            }
                            sessionScope.put(sessionCachedKey, Boolean.TRUE);
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!logger.isFinest()) break block17;
                logger.finest("Failed to lookup enterprise property", t);
            }
        }
        if (eid != null) {
            requestScope.put(requestValueKeyTenantId, eid);
        }
        if (name != null) {
            requestScope.put(requestValueKeyTenantName, name);
        }
        requestScope.put(requestCachedKey, Boolean.TRUE);
        return infoType == TenantInfo.TenantInfoType.TENANT_ID ? eid : name;
    }

    private String getSessionKey(String prefix, String body, String suffix) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        builder.append(SESSION_KEY_SEPARATOR);
        if (body != null) {
            builder.append(body);
            builder.append(SESSION_KEY_SEPARATOR);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }
}

