/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class XmlArchivedProperties
implements Serializable {
    private static final long serialVersionUID = 1423872944L;
    private final HashMap<String, Serializable> properties;
    private static final PersistenceDelegate NEW_FROM_STR_DELEGATE = new PersistenceDelegate(){

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{oldInstance.toString()});
        }
    };

    private XmlArchivedProperties(HashMap<String, Serializable> r) {
        this.properties = r;
    }

    protected XmlArchivedProperties() {
        this.properties = new HashMap();
    }

    public XmlArchivedProperties(XmlArchivedProperties p) {
        this.properties = XmlArchivedProperties.copy(p, false);
    }

    private static HashMap<String, Serializable> copy(XmlArchivedProperties p, boolean forPersistence) {
        ArrayList<XmlArchivedProperties> parents = new ArrayList<XmlArchivedProperties>();
        parents.add(p);
        return XmlArchivedProperties.copy(parents, p, forPersistence);
    }

    private static HashMap<String, Serializable> copy(ArrayList<XmlArchivedProperties> parents, XmlArchivedProperties original, boolean forPersistence) {
        HashMap<String, Serializable> r = new HashMap<String, Serializable>(original.properties.size());
        for (String key : original.properties.keySet()) {
            Object o2;
            Serializable value = original.properties.get(key);
            if (value instanceof XmlArchivedProperties) {
                XmlArchivedProperties child = (XmlArchivedProperties)value;
                XmlArchivedProperties.throwIfCyclic(parents, child);
                parents.add(child);
                HashMap<String, Serializable> childCopy = XmlArchivedProperties.copy(parents, child, forPersistence);
                parents.remove(child);
                if (forPersistence) {
                    r.put(key, childCopy);
                    continue;
                }
                r.put(key, new XmlArchivedProperties(childCopy));
                continue;
            }
            if (value instanceof XmlArchivedProperties[]) {
                XmlArchivedProperties[] o = (XmlArchivedProperties[])value;
                o2 = forPersistence ? new HashMap[o.length] : new XmlArchivedProperties[o.length];
                int index = 0;
                for (XmlArchivedProperties xap : (XmlArchivedProperties[])value) {
                    XmlArchivedProperties.throwIfCyclic(parents, xap);
                    parents.add(xap);
                    HashMap<String, Serializable> childCopy = XmlArchivedProperties.copy(parents, xap, forPersistence);
                    parents.remove(xap);
                    o2[index] = forPersistence ? childCopy : new XmlArchivedProperties(childCopy);
                    ++index;
                }
                r.put(key, (Serializable)o2);
                continue;
            }
            if (value instanceof Date) {
                Date d = (Date)value;
                r.put(key, new Date(d.getTime()));
                continue;
            }
            if (!forPersistence && value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                o2 = Array.newInstance(value.getClass().getComponentType(), length);
                System.arraycopy(value, 0, o2, 0, length);
                r.put(key, (Serializable)o2);
                continue;
            }
            r.put(key, value);
        }
        return r;
    }

    private static void throwIfCyclic(ArrayList<XmlArchivedProperties> parents, XmlArchivedProperties child) {
        if (parents.contains(child)) {
            throw new IllegalArgumentException("Invalid XmlArchivedProperties: cyclic reference to another XmlArchivedProperties.");
        }
    }

    public static final String toXml(XmlArchivedProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Invalid XmlArchivedProperties object: null.");
        }
        HashMap<String, Serializable> pMap = XmlArchivedProperties.copy(properties, true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(out));
        e.setPersistenceDelegate(BigDecimal.class, NEW_FROM_STR_DELEGATE);
        e.setPersistenceDelegate(BigInteger.class, NEW_FROM_STR_DELEGATE);
        e.writeObject(pMap);
        e.close();
        return out.toString();
    }

    public static final XmlArchivedProperties fromXml(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("Invalid XML: null.");
        }
        if (xml.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid XML: empty.");
        }
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(new ByteArrayInputStream(xml.getBytes())));
        Object r = d.readObject();
        d.close();
        return XmlArchivedProperties.restore((HashMap)r);
    }

    private static XmlArchivedProperties restore(HashMap<String, Serializable> map) {
        for (String key : map.keySet()) {
            Serializable value = map.get(key);
            if (value instanceof HashMap) {
                XmlArchivedProperties r = XmlArchivedProperties.restore((HashMap)value);
                map.put(key, r);
                continue;
            }
            if (!(value instanceof HashMap[])) continue;
            HashMap[] array = (HashMap[])value;
            XmlArchivedProperties[] r = new XmlArchivedProperties[array.length];
            int index = 0;
            for (HashMap em : array) {
                r[index] = XmlArchivedProperties.restore(em);
                ++index;
            }
            map.put(key, (Serializable)r);
        }
        return new XmlArchivedProperties(map);
    }

    public Object getObject(String name) {
        Serializable o = this.properties.get(name);
        if (o == null) {
            return o;
        }
        if (!o.getClass().isArray()) {
            return o;
        }
        int length = Array.getLength(o);
        Object o2 = Array.newInstance(o.getClass().getComponentType(), length);
        System.arraycopy(o, 0, o2, 0, length);
        return o2;
    }

    public boolean containsName(String name) {
        return this.properties.containsKey(name);
    }

    protected void setXmlArchivedProperties(String name, XmlArchivedProperties value) {
        this.properties.put(name, value);
    }

    public XmlArchivedProperties getXmlArchivedProperties(String name) {
        return (XmlArchivedProperties)this.getObject(name);
    }

    protected void setXmlArchivedPropertiesArray(String name, XmlArchivedProperties[] value) {
        this.properties.put(name, (Serializable)value);
    }

    public XmlArchivedProperties[] getXmlArchivedPropertiesArray(String name) {
        return (XmlArchivedProperties[])this.getObject(name);
    }

    protected void setInteger(String name, Integer value) {
        this.properties.put(name, value);
    }

    public Integer getInteger(String name) {
        return (Integer)this.getObject(name);
    }

    protected void setLong(String name, Long value) {
        this.properties.put(name, value);
    }

    public Long getLong(String name) {
        return (Long)this.getObject(name);
    }

    protected void setLongArray(String name, Long[] value) {
        this.properties.put(name, (Serializable)value);
    }

    public Long[] getLongArray(String name) {
        return (Long[])this.getObject(name);
    }

    protected void setDouble(String name, Double value) {
        this.properties.put(name, value);
    }

    public Double getDouble(String name) {
        return (Double)this.getObject(name);
    }

    protected void setBigInteger(String name, BigInteger value) {
        this.properties.put(name, value);
    }

    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.getObject(name);
    }

    protected void setBigDecimal(String name, BigDecimal value) {
        this.properties.put(name, value);
    }

    public BigDecimal getBigDecimal(String name) {
        return (BigDecimal)this.getObject(name);
    }

    protected void setString(String name, String value) {
        this.properties.put(name, (Serializable)((Object)value));
    }

    public String getString(String name) {
        return (String)this.getObject(name);
    }

    protected void setBoolean(String name, boolean b) {
        this.properties.put(name, Boolean.valueOf(b));
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.getObject(name);
    }

    protected void setDate(String name, Date date) {
        this.properties.put(name, date);
    }

    public Date getDate(String name) {
        return (Date)this.getObject(name);
    }

    protected void setStringArray(String name, String[] value) {
        this.properties.put(name, (Serializable)value);
    }

    public String[] getStringArray(String name) {
        return (String[])this.getObject(name);
    }

    protected void remove(String name) {
        this.properties.remove(name);
    }

    public Set<String> propertyNameSet() {
        return this.properties.keySet();
    }

    public int size() {
        return this.properties.size();
    }

    public String toString() {
        return this.properties.toString();
    }
}

