/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adf.share.sandbox.MetadataRepositoryBaseline;
import oracle.adf.share.sandbox.MetadataRevision;
import oracle.adf.share.sandbox.MetadataRevisionPortable;
import oracle.javatools.annotations.Concealed;

@Concealed
public abstract class MetadataRevisionSupport {
    private static final String DEFAULT_IMPL_CLASS = "oracle.adfinternal.share.sandbox.DefaultMetadataRevisionSupport";
    private static final MultiTenantStorage<MetadataRevisionSupport> mt_instance = new MultiTenantStorage();

    static MetadataRevisionSupport getInstance() {
        MetadataRevisionSupport defaultInstance = (MetadataRevisionSupport)mt_instance.get();
        if (defaultInstance != null) {
            return defaultInstance;
        }
        try {
            Class klass = ClassUtils.forName((String)DEFAULT_IMPL_CLASS, MetadataRevisionSupport.class);
            defaultInstance = (MetadataRevisionSupport)klass.newInstance();
            mt_instance.set((Object)defaultInstance);
            return defaultInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected MetadataRevisionSupport() {
    }

    protected String newRevisionId() {
        return UUID.randomUUID().toString();
    }

    public abstract String getLocalHostId();

    protected final MetadataRevision newMetadataRevision() {
        return new MetadataRevision(this.newRevisionId(), this.getLocalHostId(), null);
    }

    protected final MetadataRevision newMetadataRevision(String id, String hostId, String fromHostId) {
        return new MetadataRevision(id, hostId, fromHostId);
    }

    public abstract boolean exists(MetadataRevision var1);

    public abstract MetadataRevision create(String var1);

    public abstract void publish(MetadataRevisionPortable var1, String var2);

    public boolean isEligibleForUnpublish(MetadataRevisionPortable revision) {
        throw new UnsupportedOperationException();
    }

    public boolean unpublish(MetadataRevisionPortable revision) {
        throw new UnsupportedOperationException();
    }

    public abstract MetadataRevision get(String var1);

    public abstract List<MetadataRevision> listAfter(MetadataRevision var1);

    public abstract MetadataRevision getLatest(String var1);

    public abstract MetadataRevision getLatest();

    protected final Map<String, Object> getPayload(MetadataRevision revision) {
        return revision.getPayload();
    }

    public abstract Map<String, MetadataRepositoryBaseline> getRepositoryBaselines(MetadataRevision var1);

    public abstract Date getRecordDate(MetadataRevision var1);

    public abstract String getRecordedBy(MetadataRevision var1);

    public abstract String getNote(MetadataRevision var1);
}

