/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.sandbox;

public class MetadataRevisionNoteURI {
    static final String SCHEME_PREFIX = "note:";
    protected final String _uri;
    private String _resource;

    MetadataRevisionNoteURI(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Invalid URI: null.");
        }
        this._uri = uri;
    }

    public String getResource() {
        if (this._resource == null) {
            String n = this.extractResource();
            this._resource = n == null ? "" : n;
        }
        return this._resource;
    }

    protected String extractResource() {
        int index = this._uri.indexOf(":");
        if (index < 0) {
            return this._uri;
        }
        return this._uri.substring(index + 1);
    }

    public String toString() {
        return this._uri;
    }

    public static MetadataRevisionNoteURI create(String note) {
        if (note == null) {
            return null;
        }
        return new MetadataRevisionNoteURI(SCHEME_PREFIX + note);
    }

    public static MetadataRevisionNoteURI parse(String noteURI) {
        if (noteURI == null) {
            return null;
        }
        if (noteURI.startsWith("sandbox-id:")) {
            return new SandboxId(noteURI);
        }
        return new MetadataRevisionNoteURI(noteURI);
    }

    public static class SandboxId
    extends MetadataRevisionNoteURI {
        static final String SCHEME_PREFIX = "sandbox-id:";

        SandboxId(String uri) {
            super(uri);
        }

        public static SandboxId create(String sandboxId) {
            if (sandboxId == null) {
                throw new IllegalArgumentException("Invalid sandbox ID: null.");
            }
            return new SandboxId(SCHEME_PREFIX + sandboxId);
        }
    }
}

