/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.el;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFContext;
import oracle.adf.share.el.ADFExpressionEvaluator;
import oracle.adf.share.el.VariableResolverELContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.jsp.el.OracleExpression;
import oracle.jsp.el.OracleExpressionEvaluator;

public class OracleExpressionEvaluatorImpl
implements ADFExpressionEvaluator {
    private static final ADFLogger mLogger = ADFLogger.createADFLogger(OracleExpressionEvaluatorImpl.class);
    private OracleExpressionEvaluator mEvaluator;

    @Override
    public Object evaluateHandleNull(String expression) {
        try {
            return this.evaluate(expression);
        }
        catch (PropertyNotFoundException e) {
            if (mLogger.isWarning()) {
                mLogger.warning(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public Object evaluate(String expression) {
        if (this.getExpressionFactory() != null) {
            return this.evaluate(expression, this.getELContext());
        }
        return this.evaluateWithEL10(expression, this.getVariableResolver());
    }

    @Override
    public Object evaluateHandleNull(String expression, VariableResolver variableResolver) {
        try {
            return this.evaluate(expression, variableResolver);
        }
        catch (PropertyNotFoundException e) {
            if (mLogger.isWarning()) {
                mLogger.warning(e.getMessage());
            }
            return null;
        }
    }

    @Override
    public Object evaluate(String expression, VariableResolver variableResolver) {
        if (this.getExpressionFactory() != null) {
            if (variableResolver != null) {
                return this.evaluate(expression, new VariableResolverELContext(this.getELContext(), variableResolver));
            }
            return this.evaluate(expression, this.getELContext());
        }
        return this.evaluateWithEL10(expression, variableResolver);
    }

    private Object evaluateWithEL10(String expression, VariableResolver variableResolver) {
        if (this.mEvaluator == null) {
            this.init();
        }
        try {
            OracleExpression expr = (OracleExpression)this.mEvaluator.parseExpression(expression, Object.class, null);
            return expr.evaluate(variableResolver);
        }
        catch (ELException e) {
            throw new RuntimeException(e);
        }
    }

    public Object evaluate(String expression, ELContext context) {
        ADFContext adfCtx = ADFContext.getCurrent();
        ExpressionFactory factory = adfCtx.getExpressionFactory();
        if (factory != null) {
            ValueExpression expr = factory.createValueExpression(context, expression, Object.class);
            return expr.getValue(context);
        }
        throw new UnsupportedOperationException("Must define an expression factory");
    }

    @Override
    public void setValue(String expression, Object value) {
        if (this.getExpressionFactory() != null) {
            this.setValue(expression, value, this.getELContext());
        } else {
            this.setValue(expression, value, this.getVariableResolver());
        }
    }

    @Override
    public void setValue(String expression, Object value, VariableResolver variableResolver) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String expression, Object value, ELContext context) {
        ADFContext adfCtx = ADFContext.getCurrent();
        ExpressionFactory factory = adfCtx.getExpressionFactory();
        if (factory == null) {
            throw new UnsupportedOperationException("Must define an expression factory");
        }
        ValueExpression expr = factory.createValueExpression(context, expression, Object.class);
        expr.setValue(context, value);
    }

    @Override
    public VariableResolver getVariableResolver() {
        return ADFContext.getCurrent().getVariableResolver();
    }

    public ELContext getELContext() {
        return ADFContext.getCurrent().getELContext();
    }

    public ExpressionFactory getExpressionFactory() {
        return ADFContext.getCurrent().getExpressionFactory();
    }

    private synchronized void init() {
        if (this.mEvaluator == null) {
            this.mEvaluator = new OracleExpressionEvaluator();
        }
    }
}

