/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFSettingsImpl;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.javatools.annotations.Concealed;

public class ConfigContainerFactory {
    private static final String CLASSNAME = "oracle.adf.share.ConfigContainerFactory";
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.ConfigContainerFactory");
    private static final MultiTenantStorage<Map<ClassLoader, SoftReference<ADFSettings>>> adfSettingsMapProxy = new MultiTenantStorage<Map<ClassLoader, SoftReference<ADFSettings>>>(){

        protected Map<ClassLoader, SoftReference<ADFSettings>> initialValue() {
            return new WeakHashMap<ClassLoader, SoftReference<ADFSettings>>(4);
        }
    };
    private static final MultiTenantStorage<Object> settingsMapLockProxy = new MultiTenantStorage<Object>(){

        protected Object initialValue() {
            return new Object();
        }
    };
    public static final String ADF_CONFIG = "oracle.adf.share.ADFConfig";
    public static final String ADF_SETTIINGS = "oracle.adf.share.ADFSettings";

    public static ADFSettings findOrCreateConfig(String configType) {
        if (configType.equals(ADF_CONFIG)) {
            return ADFConfigFactory.findOrCreateADFConfig(false);
        }
        if (configType.equals(ADF_SETTIINGS)) {
            return ConfigContainerFactory.findOrCreateADFSettings();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ADFSettings findOrCreateADFSettings() {
        ADFSettings app = null;
        ClassLoader cl = ClassUtils.getClassLoader(ConfigContainerFactory.class);
        Object object = settingsMapLockProxy.get();
        synchronized (object) {
            SoftReference sr = (SoftReference)((Map)adfSettingsMapProxy.get()).get(cl);
            if (sr != null) {
                app = (ADFSettings)sr.get();
            }
            if (app == null) {
                app = new ADFSettingsImpl();
                ((Map)adfSettingsMapProxy.get()).put(cl, new SoftReference<ADFSettings>(app));
                if (mLogger.isFine()) {
                    mLogger.fine("Adding ADFSettings for ClassLoader " + cl);
                }
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    private static void internalClearSettingsMap() {
        Object object = settingsMapLockProxy.get();
        synchronized (object) {
            ((Map)adfSettingsMapProxy.get()).clear();
        }
    }

    @Concealed
    private static void internalClearMap() {
        ConfigContainerFactory.internalClearSettingsMap();
    }
}

