/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeHelper;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.Environment;
import oracle.adf.share.ResourceKey;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.config.ConfigHelper;
import oracle.adf.share.config.FallbackConfigImpl;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adfinternal.share.config.AbstractADFConfig;
import oracle.adfinternal.share.config.JRFApplicationHelper;
import oracle.adfinternal.share.util.SecureParserFactory;
import oracle.javatools.annotations.Concealed;
import oracle.jrf.PortabilityLayerException;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Concealed
public class ADFConfigImpl
extends AbstractADFConfig {
    public static final String CALLBACK_FILE = "META-INF/services/adf-config.properties";
    public static final String ADF_CONFIG_CHILD = "adf-config-child";
    public static final String NAMESPACE_ADF_MDS_CONFIG = "http://xmlns.oracle.com/adf/mds/config";
    private static ThreadLocal<Boolean> configObjectRecursing = new ThreadLocal();
    protected ConcurrentHashMap<String, Map> _storedResults = new ConcurrentHashMap(10);
    protected ConcurrentHashMap<String, List<ADFIntialParseResult>> _storeParsedElements = new ConcurrentHashMap(10);
    protected ConcurrentHashMap<String, Object> _resourceReadList = new ConcurrentHashMap(2);
    protected Object currentADFSessionOptions = null;
    private final Object PLACEHOLDER_VALUE = new Object();
    protected Map<String, String> _callbackMap = new HashMap<String, String>(20);
    protected List<URL> propFiles = new ArrayList<URL>();
    protected String _applicationName;
    @CodeSharingSafe(value="MutableStaticField")
    private static int _appCounter = 0;
    protected boolean _isNamedConfig = false;
    protected String _namedConfig = null;
    protected URL _url = null;
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    private static final String CLASSNAME = ADFConfigImpl.class.getName();
    private static final ADFLogger _logger = ADFLogger.createADFLogger((String)CLASSNAME);
    protected ConcurrentHashMap<Object, ADFScopeHelper> mScopeHelpers = new ConcurrentHashMap();
    private Object getResultLock = new Object();
    protected int _firstPassEnteredCount = 0;
    private static final MultiTenantStorage<MetadataRegistry> rcutils = new MultiTenantStorage<MetadataRegistry>(){

        protected MetadataRegistry initialValue() {
            return MetadataRegistry.newInstance();
        }
    };

    ADFConfigImpl() {
        this.init();
    }

    ADFConfigImpl(InputStream is, String resource) {
        this.init();
        this.readConfig(is, resource);
    }

    public ADFConfigImpl(String namedConfig, URL url) {
        this.init();
        this._isNamedConfig = true;
        this._namedConfig = namedConfig;
        this._url = url;
        this.readConfig(this._namedConfig, url);
    }

    public String getApplicationName() {
        return this._applicationName;
    }

    @Override
    public Object getId() {
        return this;
    }

    @Concealed
    public Map getCallBackMap() {
        this.registerCallbackListeners();
        return this._callbackMap;
    }

    protected void reset() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Reset called");
        }
        this._storedResults.clear();
        this._storeParsedElements.clear();
        this._callbackMap.clear();
        this.propFiles.clear();
        this._resourceReadList.clear();
        this.init();
    }

    protected void init() {
        this.generateApplicationName();
        this.registerCallbackListeners();
    }

    protected Map<String, List<ADFIntialParseResult>> getParsedElements() {
        if (this._storeParsedElements.isEmpty() && this._url != null && this._namedConfig != null) {
            this.readConfig(this._namedConfig, this._url);
        }
        return this._storeParsedElements;
    }

    void registerCallbackListeners() {
        Map<String, String> map = ConfigHelper.registerCallbackListeners(this.propFiles, CALLBACK_FILE);
        this._callbackMap.putAll(map);
    }

    private static MetadataRegistry getRCUtils() {
        return (MetadataRegistry)rcutils.get();
    }

    protected void readConfig(String namedConfig, URL url) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(CLASSNAME, resBundle.getString("READING_NAMED_ADFCFG"), url.getPath());
        }
        try {
            Document doc = ADFConfigImpl.getRCUtils().getDomDocument(url);
            this.readConfig(namedConfig, doc, url);
        }
        catch (IOException e) {
            if (_logger.isFine()) {
                _logger.fine(CLASSNAME, (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        catch (XMLParseException pe) {
            if (_logger.isFine()) {
                _logger.fine(CLASSNAME, (Throwable)pe);
                _logger.fine(CLASSNAME, "readConfig", resBundle.getString("XML_PARSE_EX"), new Object[]{pe.getColumnNumber(), pe.getLineNumber()});
            }
            throw new RuntimeException(pe);
        }
        catch (Exception e) {
            if (_logger.isFine()) {
                _logger.fine(CLASSNAME, (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readConfig(String namedConfig, Document doc, URL url) {
        if (_logger.isFine()) {
            _logger.fine(CLASSNAME + resBundle.getString("READING_NAMED_ADFCFG"), (Object)url.getPath());
        }
        try {
            Element root = doc.getDocumentElement();
            if (root != null) {
                NodeList nl = root.getChildNodes();
                Object ctx = null;
                boolean registered = false;
                for (int i = 0; nl != null && i < nl.getLength(); ++i) {
                    Node app = nl.item(i);
                    String ns = app.getNamespaceURI();
                    if (ns == null) continue;
                    if (!registered && !this._callbackMap.containsKey(ns)) {
                        registered = true;
                        this.registerCallbackListeners();
                    }
                    ADFIntialParseResult apr = new ADFIntialParseResult(ctx, namedConfig, app, url.getPath());
                    List<ADFIntialParseResult> val = this._storeParsedElements.get(ns);
                    if (val == null) {
                        val = new ArrayList<ADFIntialParseResult>(2);
                        val.add(apr);
                        this._storeParsedElements.put(ns, val);
                        continue;
                    }
                    List<ADFIntialParseResult> list = val;
                    synchronized (list) {
                        val = this._storeParsedElements.get(ns);
                        if (val == null) {
                            val = new ArrayList<ADFIntialParseResult>(2);
                        }
                        val.add(apr);
                        this._storeParsedElements.put(ns, val);
                        continue;
                    }
                }
            }
        }
        catch (Exception e) {
            if (_logger.isFine()) {
                _logger.fine(CLASSNAME, (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    void readConfig(InputStream is, String resource) {
        this.readConfig(is, resource, false);
    }

    void readConfig(InputStream is, String resource, boolean reparse) {
        if (reparse) {
            this._storeParsedElements.clear();
        }
        this.parseConfigFirstPass(is, resource);
    }

    protected Element getDocumentElement(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory f = SecureParserFactory.getBuilderFactory();
            f.setIgnoringElementContentWhitespace(true);
            DocumentBuilder dp = f.newDocumentBuilder();
            Document doc = dp.parse(is);
            return doc.getDocumentElement();
        }
        catch (IOException f) {
        }
        catch (XMLParseException pe) {
            _logger.internal(this.getClass().getName() + ":" + pe.getMessage() + "\n" + resBundle.getString("XML_PARSE_EX"), new Object[]{pe.getColumnNumber(), pe.getColumnNumber()});
            throw new ADFShareException(ResourceKey.XML_SYNTAX_ERROR, (Throwable)pe, pe.getColumnNumber(), pe.getLineNumber());
        }
        catch (Exception e) {
            String mesg = e.getMessage();
            if (mesg == null) {
                mesg = "";
            }
            _logger.internal(this.getClass().getName() + "  " + mesg, (Throwable)e);
            throw new ADFShareException(ResourceKey.XML_PARSING_ERROR, (Throwable)e);
        }
        return null;
    }

    protected void parseConfigFirstPass(InputStream is, String resource) {
        block24: {
            if (this._firstPassEnteredCount > 0 && _logger.isFine()) {
                _logger.fine("Entered count: " + this._firstPassEnteredCount);
            }
            ++this._firstPassEnteredCount;
            try {
                Element root = this.getDocumentElement(is);
                this.setResourceVisited(resource);
                if (root == null) break block24;
                boolean registered = false;
                if (this._callbackMap.size() == 0) {
                    registered = true;
                    this.registerCallbackListeners();
                    if (this._callbackMap.size() == 0) {
                        return;
                    }
                }
                NodeList nl = root.getChildNodes();
                Object ctx = null;
                try {
                    if (ADFContext.hasCurrent() && ADFContext.getCurrent().hasEnvironment()) {
                        ctx = ADFContext.getCurrent().getEnvironment().getContext();
                    }
                }
                catch (Exception ignore) {
                    _logger.finest(ignore.getMessage());
                }
                for (int i = 0; nl != null && i < nl.getLength(); ++i) {
                    Node app = nl.item(i);
                    String ns = app.getNamespaceURI();
                    if (ns == null) continue;
                    if (!registered && !this._callbackMap.containsKey(ns)) {
                        registered = true;
                        this.registerCallbackListeners();
                    }
                    ADFIntialParseResult apr = new ADFIntialParseResult(ctx, resource, app, resource);
                    List<ADFIntialParseResult> val = this._storeParsedElements.get(ns);
                    if (val == null) {
                        val = new ArrayList<ADFIntialParseResult>(2);
                    }
                    val.add(apr);
                    this._storeParsedElements.put(ns, val);
                }
            }
            catch (ADFShareException e) {
                throw e;
            }
            catch (Exception e) {
                String mesg = e.getMessage();
                if (mesg == null) {
                    mesg = "";
                }
                _logger.internal(this.getClass().getName() + "  " + mesg, (Throwable)e);
                throw new ADFShareException(ResourceKey.XML_PARSING_ERROR, (Throwable)e);
            }
            finally {
                --this._firstPassEnteredCount;
                try {
                    is.close();
                }
                catch (Exception e) {
                    String mesg = e.getMessage();
                    if (mesg == null) {
                        mesg = "";
                    }
                    _logger.internal(this.getClass().getName() + "  " + mesg, (Throwable)e);
                    throw new ADFShareException(ResourceKey.CLOSE_CFG_STREAM, (Throwable)e);
                }
            }
        }
    }

    private Map getResultFromComponent(Node el, Map storedResult, Object ctx, String resource, String filePath, boolean forceReparse) {
        String namespace = el.getNamespaceURI();
        String cbClassName = this._callbackMap.get(namespace);
        if (cbClassName == null) {
            if (_logger.isFine()) {
                _logger.fine("Rescanning callbacks, no parser found for " + namespace);
            }
            this.registerCallbackListeners();
            cbClassName = this._callbackMap.get(namespace);
            if (cbClassName == null) {
                if (_logger.isConfig()) {
                    _logger.config("No parser callback found for " + namespace);
                }
                return null;
            }
        }
        Map map = null;
        try {
            Class cls = ClassUtils.forName((String)cbClassName, ADFConfigFactory.class);
            if (cls == null) {
                return map;
            }
            Object handler = cls.newInstance();
            Method method = cls.getMethod("parseADFConfiguration", Element.class, Map.class, ADFConfigParsingContext.class);
            ADFConfigParsingContext adfParsingCtx = new ADFConfigParsingContext(this._applicationName, ctx, resource, filePath, forceReparse);
            map = (Map)method.invoke(handler, el, storedResult, adfParsingCtx);
        }
        catch (ADFShareException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            _logger.internal(this.getClass().getName() + "  " + e.getMessage(), e.getCause());
            throw new ADFShareException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null && (t = e.getCause()) instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException(t);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            _logger.internal(this.getClass().getName() + "  " + e.getMessage(), cause != null ? cause : e);
            throw new ADFShareException(e);
        }
        return map;
    }

    @Override
    public Map getConfigObject(String namespace) {
        return this.getConfigObject(namespace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getConfigObject(String namespace, boolean forceReparse) {
        if (this._storedResults.isEmpty() && !"http://xmlns.oracle.com/adf/config/properties".equals(namespace)) {
            configObjectRecursing.set(Boolean.TRUE);
            this.getConfigObject("http://xmlns.oracle.com/adf/config/properties", forceReparse);
            configObjectRecursing.remove();
        }
        if (Boolean.TRUE.equals(configObjectRecursing.get()) && !"http://xmlns.oracle.com/adf/config/properties".equals(namespace)) {
            throw new ADFShareException(ResourceKey.CALLBACK_PARSING_ERROR);
        }
        Map mapResult = null;
        Map m = this._storedResults.get(namespace);
        if (forceReparse || m == null) {
            Object object = this.getResultLock;
            synchronized (object) {
                List<ADFIntialParseResult> res;
                m = this._storedResults.get(namespace);
                if ((forceReparse || m == null) && (res = this.getParsedElements().get(namespace)) != null) {
                    for (int i = 0; i < res.size(); ++i) {
                        ADFIntialParseResult ps = res.get(i);
                        mapResult = this.getResultFromComponent(ps.app, m, ps.ctx, ps.resource, ps.filePath, forceReparse);
                        if (mapResult == null) continue;
                        m = mapResult;
                        this._storedResults.put(namespace, m);
                        if (!_logger.isFine()) continue;
                        _logger.fine("Parsed and stored results for " + namespace);
                    }
                }
            }
        }
        return m;
    }

    boolean isResourceVisited(String resourceName) {
        return this._resourceReadList.containsKey(resourceName);
    }

    void setResourceVisited(String resourceName) {
        this._resourceReadList.putIfAbsent(resourceName, this.PLACEHOLDER_VALUE);
    }

    @Override
    public Object getMDSInstance() {
        return this.getMDSInstance(true);
    }

    @Override
    public Object getMDSInstance(boolean bCreate) {
        FallbackConfigImpl fallBackConfig;
        Object mdsInstance;
        if (!AdfServerPlatformUtil.isMDSAvailable()) {
            return null;
        }
        if (!this.isMDSInstanceCached() && !bCreate) {
            return null;
        }
        Map mMDSContext = this.getConfigObject(NAMESPACE_ADF_MDS_CONFIG);
        if (mMDSContext == null && !bCreate) {
            return null;
        }
        if (mMDSContext != null) {
            Object mdsinstance = mMDSContext.get("MDSInstance");
            if (mdsinstance != null) {
                return mdsinstance;
            }
            if (!bCreate) {
                return null;
            }
        }
        if (mMDSContext == null && !this._isNamedConfig && (mdsInstance = (fallBackConfig = new FallbackConfigImpl()).getMDSInstance()) != null) {
            mMDSContext = this.cacheMDSInstance(mdsInstance);
            List siteDefPackages = fallBackConfig.getSiteDefPackages();
            List sessionDefPackages = fallBackConfig.getSessionDefPackages();
            List defCachePolicies = fallBackConfig.getDefCachePolicies();
            List adfSessionOptionsList = fallBackConfig.getADFSessionOptionsList();
            mMDSContext.put("SiteDefPackages", siteDefPackages);
            mMDSContext.put("SessionDefPackages", sessionDefPackages);
            mMDSContext.put("DefCachePolicies", defCachePolicies);
            mMDSContext.put("ADFSessionOptionsList", adfSessionOptionsList);
        }
        if (mMDSContext == null) {
            return null;
        }
        return mMDSContext.get("MDSInstance");
    }

    @Override
    public List getSiteDefPackages() {
        if (this.getMDSInstance() != null) {
            Map mdsContext = this.getConfigObject(NAMESPACE_ADF_MDS_CONFIG);
            ArrayList<String> lst = (ArrayList<String>)mdsContext.get("SiteDefPackages");
            if (lst == null) {
                lst = new ArrayList<String>(2);
                lst.add("sitedef");
                mdsContext.put("SiteDefPackages", lst);
            }
            return lst;
        }
        ArrayList<String> lst = new ArrayList<String>(1);
        lst.add("sitedef");
        return lst;
    }

    @Override
    public List getSessionDefPackages() {
        if (this.getMDSInstance() != null) {
            Map mdsContext = this.getConfigObject(NAMESPACE_ADF_MDS_CONFIG);
            ArrayList<String> lst = (ArrayList<String>)mdsContext.get("SessionDefPackages");
            if (lst == null) {
                lst = new ArrayList<String>(2);
                lst.add("sessiondef");
                mdsContext.put("SessionDefPackages", lst);
            }
            return lst;
        }
        ArrayList<String> lst = new ArrayList<String>(1);
        lst.add("sessiondef");
        return lst;
    }

    @Override
    public List getDefCachePolicies() {
        if (this.getMDSInstance() != null) {
            Map mdsContext = this.getConfigObject(NAMESPACE_ADF_MDS_CONFIG);
            ArrayList lst = (ArrayList)mdsContext.get("DefCachePolicies");
            if (lst == null) {
                lst = new ArrayList(0);
                mdsContext.put("DefCachePolicies", lst);
            }
            return lst;
        }
        return new ArrayList(0);
    }

    @Override
    public List getADFSessionOptionsList() {
        if (this.getMDSInstance() != null) {
            Map mdsContext = this.getConfigObject(NAMESPACE_ADF_MDS_CONFIG);
            ArrayList lst = (ArrayList)mdsContext.get("ADFSessionOptionsList");
            if (lst == null) {
                lst = new ArrayList(0);
                mdsContext.put("ADFSessionOptionsList", lst);
            }
            return lst;
        }
        return new ArrayList(0);
    }

    @Override
    public Object getCurrentADFSessionOptions() {
        if (this.getMDSInstance(false) == null) {
            return null;
        }
        List lst = this.getADFSessionOptionsList();
        Object options = this.getCurrentADFSessionOptions(lst);
        return options != null ? options : new FallbackConfigImpl().getCurrentADFSessionOptions(lst);
    }

    @Override
    public Context getConnectionsContext() throws NamingException {
        Hashtable mContextEnv = (Hashtable)this.getConfigObject("http://xmlns.oracle.com/adf/jndi/config");
        if (mContextEnv == null && !this._isNamedConfig) {
            return FallbackConfigImpl.getDefaultConnectionsContext();
        }
        if (mContextEnv == null) {
            return null;
        }
        if (this._isNamedConfig) {
            mContextEnv.put("named.adf.context", this._namedConfig);
        }
        return AdfInitialContext.newAdfInitialContext(mContextEnv, ADFConfigFactory.class);
    }

    private synchronized void generateApplicationName() {
        if (this._applicationName == null || this._applicationName.length() == 0) {
            this._applicationName = this.getPlatformAppName();
            this._applicationName = this._applicationName != null && this._applicationName.length() > 0 ? "ADFApplication_" + this._applicationName : "ADFApplication" + ++_appCounter;
            if (_logger.isFine()) {
                _logger.fine(System.identityHashCode(this) + " generated application name: " + this._applicationName);
            }
        }
    }

    protected String getPlatformAppName() {
        try {
            return this.justGetPlatformAppName();
        }
        catch (Throwable e) {
            if (AdfServerPlatformUtil.isJEE()) {
                if (_logger.isFine()) {
                    _logger.log(Level.FINE, "", e);
                } else if (_logger.isInfo()) {
                    _logger.log(Level.INFO, resBundle.getString("WLS_SUPPORT_APPNAME_FAILED"));
                }
            }
            return null;
        }
    }

    protected String justGetPlatformAppName() throws PortabilityLayerException {
        return JRFApplicationHelper.getMDSInstanceAppName();
    }

    @Override
    public Context getSecurityContext() throws NamingException {
        Map mSecurityContextEnv = this.getConfigObject("http://xmlns.oracle.com/adf/security/config");
        if (mSecurityContextEnv == null && !this._isNamedConfig) {
            return FallbackConfigImpl.getDefaultSecurityContext();
        }
        if (mSecurityContextEnv == null) {
            return null;
        }
        if (this._namedConfig != null) {
            mSecurityContextEnv.put("named.adf.context", this._namedConfig);
        }
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext(mSecurityContextEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResources() {
        if (_logger.isLoggable(Level.FINE) && this.getClass() == ADFConfigImpl.class) {
            _logger.log(Level.FINE, "From releaseResources for " + this._applicationName, new Throwable("DIAGNOSTIC AID, NOT AN ERROR"));
        }
        ADFContext old = ADFContext.hasCurrent() ? ADFContext.findCurrent() : null;
        ADFScopeHelper.setReleasing(true);
        try {
            for (Map.Entry<Object, ADFScopeHelper> ent : this.mScopeHelpers.entrySet()) {
                Object context = "null".equals(ent.getKey()) ? null : ent.getKey();
                ADFScopeHelper scopeHelper = ent.getValue();
                ADFContext.initADFContext(context, null, null, null);
                scopeHelper.fireScopeInvalidated("applicationScope");
                ADFContext ctx = ADFContext.getCurrent();
                ADFScope scope = (ADFScope)ctx.findScope("applicationScope");
                if (scope == null) continue;
                scope.invalidate();
                if (_logger.isFine()) {
                    _logger.fine("Removing ApplicationScope for  : " + ctx);
                }
                ctx.removeScope("applicationScope");
            }
            this.clearLocals();
        }
        finally {
            if (old != null) {
                old.setAsCurrent();
            } else if (ADFContext.hasCurrent()) {
                ADFContext.findCurrent().removeAsCurrent();
            }
            ADFScopeHelper.setReleasing(false);
        }
    }

    protected void clearLocals() {
        this._storedResults.clear();
        this._storeParsedElements.clear();
        this._callbackMap.clear();
        this.propFiles.clear();
        this._resourceReadList.clear();
    }

    @Override
    public void clearCaches() {
        block2: {
            try {
                this.invokeMDSInstanceClearCache();
            }
            catch (Throwable t) {
                if (!_logger.isFinest()) break block2;
                _logger.finest("ADFConfigImpl.clearCaches Error = " + t.getMessage());
            }
        }
    }

    protected Map cacheMDSInstance(Object mdsInstance) {
        HashMap<String, Object> mdsContext = this._storedResults.get(NAMESPACE_ADF_MDS_CONFIG);
        if (mdsContext == null) {
            mdsContext = new HashMap<String, Object>(20);
            this._storedResults.put(NAMESPACE_ADF_MDS_CONFIG, mdsContext);
        }
        mdsContext.put("MDSInstance", mdsInstance);
        return mdsContext;
    }

    protected boolean isMDSInstanceCached() {
        return this._storedResults.containsKey(NAMESPACE_ADF_MDS_CONFIG);
    }

    protected void invokeMDSInstanceClearCache() {
        block5: {
            try {
                Method methodClearCache;
                if (!this.isMDSInstanceCached()) {
                    return;
                }
                Object mdsInstanceObject = this.getMDSInstance(false);
                Class<?> mdsInstanceClass = mdsInstanceObject != null ? mdsInstanceObject.getClass() : null;
                Method method = methodClearCache = mdsInstanceClass != null ? mdsInstanceClass.getMethod("clearCache", new Class[0]) : null;
                if (methodClearCache != null) {
                    methodClearCache.invoke(mdsInstanceObject, null);
                    if (_logger.isFinest()) {
                        _logger.finest("ADFConfigImpl.invokeMDSInstanceClearCache. Clearing current MDSInstance cache.");
                    }
                }
            }
            catch (Throwable t) {
                if (!_logger.isFinest()) break block5;
                _logger.finest("ADFConfigImpl.invokeMDSInstanceClearCache Error = " + t.getMessage());
            }
        }
    }

    @Override
    public void addScopeListener(ADFScopeListener listener) {
        this.getScopeHelper(true).addScopeListener(listener);
    }

    private ADFScopeHelper getScopeHelper(boolean create) {
        ADFScopeHelper helper;
        Environment env;
        Object ec;
        ADFContext adfContext;
        Object extContext = "null";
        if (ADFContext.hasCurrent() && (adfContext = ADFContext.getCurrent()).hasEnvironment() && (ec = (env = adfContext.getEnvironment()).getContext()) != null) {
            extContext = ec;
        }
        if ((helper = this.mScopeHelpers.get(extContext)) == null && create) {
            ADFScopeHelper h = new ADFScopeHelper();
            helper = this.mScopeHelpers.putIfAbsent(extContext, new ADFScopeHelper());
            if (helper == null) {
                helper = h;
            }
        }
        return helper;
    }

    @Override
    public void removeScopeListener(ADFScopeListener listener) {
        ADFScopeHelper helper = this.getScopeHelper(false);
        if (helper != null) {
            helper.removeScopeListener(listener);
        }
    }

    @Override
    public void updateIfNeeded() {
    }

    public String dumpAdfConfig() {
        StringWriter strWriter = new StringWriter();
        Set<Map.Entry<String, List<ADFIntialParseResult>>> entries = this.getParsedElements().entrySet();
        for (Map.Entry<String, List<ADFIntialParseResult>> entry : entries) {
            List<ADFIntialParseResult> value = entry.getValue();
            for (ADFIntialParseResult parseResult : value) {
                try {
                    Transformer transformer = SecureParserFactory.getTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    StreamResult strResult = new StreamResult(strWriter);
                    DOMSource domSource = new DOMSource(parseResult.app);
                    transformer.transform(domSource, strResult);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                }
                catch (TransformerException transformerException) {}
            }
        }
        return strWriter.toString();
    }

    public Object getCurrentADFSessionOptions(List sessOptsList) {
        try {
            Map sessDefMap = this.getConfigObject(NAMESPACE_ADF_MDS_CONFIG);
            if (sessDefMap != null) {
                this.currentADFSessionOptions = sessDefMap.get("CurrentADFSessionOptions");
            }
            if (this.currentADFSessionOptions == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getCurrentADFSessionOptions", String.class, List.class);
                this.currentADFSessionOptions = m.invoke(obj, this._applicationName, sessOptsList);
            }
            return this.currentADFSessionOptions;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getCurrentADFSessionOptions error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getCurrentADFSessionOptions error", (Throwable)ex);
        }
    }

    class ADFIntialParseResult {
        Object ctx = null;
        String resource = "";
        Node app = null;
        String filePath = null;

        ADFIntialParseResult(Object context, String resourceRead, Node resNode, String path) {
            this.ctx = context;
            this.resource = resourceRead;
            this.app = resNode;
            this.filePath = path;
        }
    }
}

