/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.ADFConfigEx;
import oracle.adf.share.ADFConfigLifecycle;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.ClassUtilsGetResourceAsStreamPrivAction;
import oracle.adf.share.common.rc.util.LoaderUtil;
import oracle.adf.share.config.ADFConfigImpl;
import oracle.adf.share.config.FallbackConfigImpl;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adfinternal.share.util.SpaceEfficientStackCache;
import oracle.javatools.annotations.Concealed;

public class ADFConfigFactory {
    private static final String CLASSNAME = "oracle.adf.share.config.ADFConfigFactory";
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.config.ADFConfigFactory");
    private Map<Object, ADFConfigEx> applications = new WeakHashMap<Object, ADFConfigEx>(4);
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    private static final MultiTenantStorage<Object> classStaticProxy = new MultiTenantStorage<Object>(){

        protected Object initialValue() {
            return new Object();
        }
    };
    private final SpaceEfficientStackCache previouslyReportedStacks = new SpaceEfficientStackCache();

    public static ADFConfigEx findOrCreateADFConfig() {
        return ADFConfigFactory.findOrCreateADFConfig("META-INF/adf-config.xml");
    }

    @Concealed
    public static ADFConfigEx findOrCreateADFConfig(boolean reparse) {
        return ADFConfigFactory.getInstance().findOrCreateADFConfig("META-INF/adf-config.xml", reparse);
    }

    public static ADFConfigEx findOrCreateADFConfig(String resourceName) {
        return ADFConfigFactory.getInstance().findOrCreateADFConfig(resourceName, false);
    }

    private static ADFConfigFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected synchronized ADFConfigImpl createApplication(ClassLoader targetCL, String resourceName) {
        return this.createApplicationFromInputStream(targetCL, resourceName);
    }

    protected ADFConfigImpl createDefaultConfig() {
        return new FallbackConfigImpl();
    }

    private static ADFConfigImpl getApplicationFromMap(Object key) {
        return (ADFConfigImpl)ADFConfigFactory.getInstance().applications.get(key);
    }

    private static void putApplicationInMap(Object key, ADFConfigEx impl) {
        ADFConfigFactory.getInstance().applications.put(key, impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ADFConfigEx findOrCreateADFConfig(String resourceName, boolean reparse) {
        String method = "findOrCreateADFConfig";
        ClassLoader cl = ClassUtils.getClassLoader(ADFConfigFactory.class);
        ADFConfigEx app = this.lookupConfig(cl, resourceName, reparse);
        if (app != null) {
            return app;
        }
        ClassLoader targetCL = this.getTargetClassLoader(cl, resourceName);
        Map<Object, ADFConfigEx> map = this.applications;
        synchronized (map) {
            StringBuilder buf;
            if (mLogger.isFinest()) {
                buf = new StringBuilder();
                LoaderUtil.dumpClassLoaderHierarchy((ClassLoader)cl, (StringBuilder)buf, (String)"  ", (String)"  ");
                mLogger.finest("resourceName=" + resourceName + " failed for cl=" + cl + ", Target=" + targetCL + ", Hierarchy:\n" + buf.toString() + "\n  Applications=" + this.applications);
            }
            if ((app = this.lookupConfig(cl, resourceName, reparse)) != null) {
                return app;
            }
            app = this.createApplication(cl, resourceName);
            if (app == null) {
                this.logDefaultConfigWarning(cl, resourceName, "findOrCreateADFConfig");
                app = this.createDefaultConfig();
                if (app instanceof ADFConfigImpl) {
                    ((ADFConfigImpl)app).setResourceVisited(resourceName);
                    targetCL = cl;
                }
                if (this.isSystemClassLoader(cl) && AdfServerPlatformUtil.isJEE()) {
                    IllegalStateException t;
                    targetCL = null;
                    if (mLogger.isLoggable(AdfServerPlatformUtil.INCIDENT_ERROR) && this.previouslyReportedStacks.shouldReport((Throwable)(t = new IllegalStateException(resBundle.getString("ADF_CONFIG_WITHOUT_APP_CONTEXT"))))) {
                        mLogger.log(AdfServerPlatformUtil.INCIDENT_ERROR, "", (Throwable)t);
                    }
                }
            }
            if (app != null) {
                if (targetCL != null) {
                    ADFConfigFactory.putApplicationInMap(targetCL, app);
                }
                if (mLogger.isFinest()) {
                    buf = new StringBuilder();
                    LoaderUtil.dumpClassLoaderHierarchy((ClassLoader)cl, (StringBuilder)buf, (String)"  ", (String)"  ");
                    mLogger.finest(CLASSNAME, "findOrCreateADFConfig", "Added target: " + resourceName + " app=" + System.identityHashCode(app) + " with key=" + targetCL + "\n  applications=" + this.applications + "\n" + buf.toString());
                    this.printClasspathDiagnostic(cl, resourceName);
                }
            }
        }
        ADFContext old = null;
        boolean revertOld = false;
        if (ADFContext.hasCurrent() && (old = ADFContext.findCurrent()).hasEnvironment() && old.getEnvironment().getContext() != null) {
            revertOld = true;
            old.removeAsCurrent();
        }
        try {
            app.addScopeListener(new ADFScopeListener(){

                @Override
                public void scopeInvalidated(String scopeName) {
                }
            });
        }
        finally {
            if (revertOld) {
                old.setAsCurrent();
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adfConfigFound(ClassLoader cl, ADFConfigImpl app, String resourceName, boolean reparse, boolean resourceRead) {
        if (reparse || !resourceRead) {
            if (mLogger.isFinest()) {
                mLogger.finest("reparse value is " + reparse + "resourceRead value is: " + resourceRead);
            }
            Map<Object, ADFConfigEx> map = this.applications;
            synchronized (map) {
                if (app.isResourceVisited(resourceName)) {
                    return;
                }
                InputStream is = cl.getResourceAsStream(resourceName);
                if (is != null) {
                    app.readConfig(is, resourceName, reparse);
                } else {
                    app.setResourceVisited(resourceName);
                }
            }
        }
    }

    private void printClasspathDiagnostic(ClassLoader cl, String resourceName) {
        try {
            if (mLogger.isFinest()) {
                Enumeration<URL> urlList = cl.getResources(resourceName);
                int count = 0;
                String mesg = resBundle.getString("PRINT_URLS");
                mLogger.finest(CLASSNAME, "printClasspathDiagnostic", mesg, (Object)resourceName);
                while (urlList.hasMoreElements()) {
                    URL url = urlList.nextElement();
                    mLogger.finest(count++ + ": " + url.getPath());
                }
                mLogger.finest("\n");
                if (count > 1) {
                    mLogger.warning(CLASSNAME, "printClasspathDiagnostic", resBundle.getString("MULTIPLE_RESOURCES_FOUND"), (Object)resourceName);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ADFConfigImpl createApplicationFromInputStream(ClassLoader cl, String resourceName) {
        ClassUtilsGetResourceAsStreamPrivAction getResourceAsStreamPrivAction = new ClassUtilsGetResourceAsStreamPrivAction(cl, resourceName);
        InputStream is = (InputStream)AccessController.doPrivileged(getResourceAsStreamPrivAction);
        if (is != null) {
            if (mLogger.isFinest()) {
                URL url = cl.getResource(resourceName);
                mLogger.finest(CLASSNAME, "createApplicationFromInputStream", resBundle.getString("READING_URL"), (Object)url.getPath());
            }
            return new ADFConfigImpl(is, resourceName);
        }
        return null;
    }

    private final ClassLoader getTargetClassLoader(final ClassLoader cl, final String resourceName) {
        if (System.getSecurityManager() == null) {
            return this.getTargetClassLoader0(cl, resourceName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ADFConfigFactory.this.getTargetClassLoader0(cl, resourceName);
            }
        });
    }

    private final ClassLoader getTargetClassLoader0(ClassLoader cl, String resourceName) {
        URL url = null;
        URL retURL = null;
        ClassLoader ret = null;
        while (cl != null && (url = cl.getResource(resourceName)) != null) {
            ret = cl;
            retURL = url;
            cl = cl.getParent();
        }
        if (mLogger.isFine()) {
            mLogger.fine("ClassLoader Target of " + ret + " found " + retURL);
        }
        return ret;
    }

    public static ADFConfigEx findADFConfig(String namedConfig) {
        return ADFConfigFactory.getApplicationFromMap(namedConfig);
    }

    @Concealed
    public static Object internalFindADFConfigId() {
        ClassLoader cl = ClassUtils.getClassLoader(ADFConfigFactory.class);
        ADFConfigEx config = ADFConfigFactory.getInstance().lookupConfig(cl, "META-INF/adf-config.xml", false, true);
        if (config != null) {
            return config.getId();
        }
        if (mLogger.isFine()) {
            mLogger.log(Level.FINE, "Lightweight lookupConfig missed!", new Throwable("DIAGNOSTIC AID, NOT AN ERROR"));
        }
        return null;
    }

    public static ADFConfigEx findADFConfig() {
        ClassLoader cl = ClassUtils.getClassLoader(ADFConfigFactory.class);
        return ADFConfigFactory.getInstance().lookupConfig(cl, "META-INF/adf-config.xml", false);
    }

    public static ADFConfigEx findOrCreateADFConfig(String name, URL adfConfigUrl) {
        return ADFConfigFactory.findOrCreateADFConfig(name, adfConfigUrl, ADFConfigImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFConfigEx findOrCreateADFConfig(String name, URL adfConfigUrl, Class configClass) {
        Object object = classStaticProxy.get();
        synchronized (object) {
            ADFConfigEx app = ADFConfigFactory.getApplicationFromMap(name);
            if (app == null) {
                Object[] parameters = new Object[]{name, adfConfigUrl};
                Class[] parameterTypes = new Class[]{String.class, URL.class};
                try {
                    Constructor constructor = configClass.getConstructor(parameterTypes);
                    app = (ADFConfigEx)constructor.newInstance(parameters);
                }
                catch (Exception e) {
                    mLogger.warning((Throwable)e);
                    app = null;
                }
                if (app != null) {
                    ADFConfigFactory.putApplicationInMap(name, app);
                    if (mLogger.isFinest()) {
                        mLogger.finest(CLASSNAME, "findOrCreateADFConfig(String,URL,Class)", name + " app=" + System.identityHashCode(app));
                    }
                }
            }
            return app;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNamedConfig(String namedConfig) {
        Map<Object, ADFConfigEx> map = ADFConfigFactory.getInstance().applications;
        synchronized (map) {
            ADFConfigFactory.getInstance().applications.remove(namedConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpApplicationState(ClassLoader appClassLoader) {
        if (mLogger.isFinest()) {
            mLogger.finest(resBundle.getString("CLEAN_APPLICATION_STATE"));
        }
        WeakHashMap<Object, Object> applicationsCopy = new WeakHashMap(4);
        boolean mapEdited = false;
        ADFConfigFactory factoryInstance = ADFConfigFactory.getInstance();
        Map<Object, ADFConfigEx> map = factoryInstance.applications;
        synchronized (map) {
            applicationsCopy = new WeakHashMap<Object, ADFConfigEx>(factoryInstance.applications);
        }
        Object app = applicationsCopy.get(appClassLoader);
        if (app == null) {
            for (Object key : applicationsCopy.keySet()) {
                ClassLoader cl;
                if (!(key instanceof ClassLoader) || (cl = (ClassLoader)key).getParent() != appClassLoader) continue;
                app = applicationsCopy.get(cl);
                break;
            }
        }
        if (app != null) {
            if (app instanceof ADFConfigEx) {
                ADFConfigEx config = (ADFConfigEx)app;
                if (mLogger.isInfo()) {
                    mLogger.info(resBundle.getString("ADF_CONFIG_IMPLEMENTATION"), (Object)config.getClass().toString());
                }
                config.releaseResources();
            }
            while (applicationsCopy.containsValue(app)) {
                applicationsCopy.values().remove(app);
                mapEdited = true;
            }
        }
        if (mapEdited) {
            Map<Object, ADFConfigEx> map2 = factoryInstance.applications;
            synchronized (map2) {
                factoryInstance.applications = applicationsCopy;
            }
            if (mLogger.isInfo()) {
                mLogger.info("applications size=" + applicationsCopy.size());
            }
        }
        applicationsCopy = null;
    }

    private static ADFConfigFactory initInstance() {
        ADFConfigFactory instance = null;
        if (!Beans.isDesignTime() && AdfServerPlatformUtil.isMDSAvailable()) {
            try {
                Class factoryclass = ClassUtils.forName((String)"oracle.adf.share.config.MDSConfigFactory", ADFConfigFactory.class);
                instance = (ADFConfigFactory)factoryclass.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (instance == null) {
            instance = new ADFConfigFactory();
        }
        if (mLogger.isFinest()) {
            mLogger.finest(resBundle.getString("CONFIG_INSTANCE_IMPL"), (Object)instance.getClass().getName());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpApplicationCaches(ClassLoader appClassLoader) {
        if (mLogger.isFinest()) {
            mLogger.finest("Clean up Application Caches");
        }
        WeakHashMap<Object, ADFConfigEx> applicationsCopy = new WeakHashMap(4);
        ADFConfigFactory factoryInstance = ADFConfigFactory.getInstance();
        Map<Object, ADFConfigEx> map = factoryInstance.applications;
        synchronized (map) {
            applicationsCopy = new WeakHashMap<Object, ADFConfigEx>(factoryInstance.applications);
        }
        if (mLogger.isFinest()) {
            ADFConfigFactory.dumpApplicationsMap(applicationsCopy);
        }
        Object app = null;
        for (Object key : applicationsCopy.keySet()) {
            ClassLoader cl;
            if (!(key instanceof ClassLoader) || (cl = (ClassLoader)key) != appClassLoader && cl.getParent() != appClassLoader || (app = (Object)applicationsCopy.get(cl)) == null || !ADFConfigEx.class.isAssignableFrom(app.getClass())) continue;
            ADFConfigFactory.clearAdfConfigCaches((ADFConfigEx)app);
        }
        applicationsCopy = null;
    }

    public static void dumpApplicationsMap(Map<Object, ADFConfigEx> curApplications) {
        try {
            Iterator<Object> iterator;
            Set<Object> keys = curApplications.keySet();
            Iterator<Object> iterator2 = iterator = keys != null ? keys.iterator() : null;
            if (iterator != null) {
                StringBuffer adfConfigMap = new StringBuffer(100);
                while (iterator.hasNext()) {
                    Object currKey = iterator.next();
                    ADFConfigEx adfConfig = curApplications.get(currKey);
                    Object mdsInstance = adfConfig.getMDSInstance(false);
                    adfConfigMap.append("Key = " + currKey.toString() + ", ADFConfig = " + adfConfig.toString() + ", MDS Instance = " + String.valueOf(mdsInstance) + ".\n");
                }
                mLogger.finest("ADFConfig Map. \n" + adfConfigMap.toString());
            }
        }
        catch (Throwable t) {
            mLogger.finest("Error dumping ADFConfig Map = " + t.getMessage());
        }
    }

    public static void clearAdfConfigCaches(ADFConfigEx adfConfig) {
        if (null == adfConfig || !ADFConfigLifecycle.class.isAssignableFrom(adfConfig.getClass())) {
            return;
        }
        if (mLogger.isFinest()) {
            mLogger.finest("ADFConfigFactory.clearAdfConfigCaches. " + resBundle.getString("ADF_CONFIG_IMPLEMENTATION"), (Object)adfConfig.getClass().toString());
        }
        ((ADFConfigLifecycle)((Object)adfConfig)).clearCaches();
    }

    private ADFConfigEx lookupConfig(ClassLoader original, String resourceName, boolean reparse) {
        return this.lookupConfig(original, resourceName, reparse, false);
    }

    private ADFConfigEx lookupConfig(ClassLoader original, String resourceName, boolean reparse, boolean justExistsCheck) {
        String method = "lookupConfig";
        boolean isPrivileged = System.getSecurityManager() != null;
        Boolean junitExclusion = null;
        ClassLoader current = original;
        while (current != null) {
            ADFConfigEx config = this.applications.get(current);
            if (config != null) {
                if (justExistsCheck) {
                    return config;
                }
                if (config instanceof ADFConfigImpl) {
                    ADFConfigImpl configImpl = (ADFConfigImpl)config;
                    boolean resourceRead = configImpl.isResourceVisited(resourceName);
                    if (!resourceRead && configImpl._resourceReadList.size() != 0) {
                        if (mLogger.isFine()) {
                            mLogger.fine(CLASSNAME, "lookupConfig", "Multi-resourceName collision: " + resourceName + ", are both configs in their expected class loaders?" + "\n  configImpl._resourceReadList=" + configImpl._resourceReadList);
                        }
                        return null;
                    }
                    this.adfConfigFound(current, configImpl, resourceName, reparse, resourceRead);
                }
                if (mLogger.isFinest()) {
                    mLogger.finest("applications=" + this.applications);
                }
                return config;
            }
            ClassLoader classLoader = current = !isPrivileged ? current.getParent() : this.getParentClassLoader(current);
            if (current == null) break;
            if (!this.isSystemClassLoader(current) || this.isSystemClassLoader(original)) continue;
            if (this.isExclusion(original, current, isPrivileged)) {
                if (!mLogger.isFiner()) continue;
                mLogger.finer("Taking the 'groovy' class loader exclusion on " + original);
                continue;
            }
            if (junitExclusion == null) {
                StackTraceElement[] elems = Thread.currentThread().getStackTrace();
                junitExclusion = elems.length == 0 ? Boolean.FALSE.booleanValue() : elems[elems.length - 1].getClassName().contains("junit");
            }
            if (junitExclusion.booleanValue()) {
                if (!mLogger.isFiner()) continue;
                mLogger.finer("Taking the 'junit' class loader exclusion on " + original);
                continue;
            }
            if (!mLogger.isFine()) break;
            mLogger.fine(resourceName + " lookup ended with null at the system ClassLoader");
            break;
        }
        return null;
    }

    private boolean isExclusion(ClassLoader original, ClassLoader sysCL, boolean isPrivileged) {
        boolean exclusion = original instanceof ClassLoaderExclusionMarker;
        if (!exclusion) {
            ClassLoader classLoader = original = !isPrivileged ? original.getParent() : this.getParentClassLoader(original);
            if (original != null && original != sysCL) {
                exclusion = this.isExclusion(original, sysCL, isPrivileged);
            }
        }
        return exclusion;
    }

    private ClassLoader getParentClassLoader(final ClassLoader current) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return current.getParent();
            }
        });
    }

    private final boolean isSystemClassLoader(ClassLoader cl) {
        for (WeakReference<ClassLoader> ref : SystemCLHolder.loaders) {
            if (cl != ref.get()) continue;
            return true;
        }
        return false;
    }

    private void logDefaultConfigWarning(ClassLoader cl, String resourceName, String method) {
        Level level = Level.INFO;
        if (ADFContext.getCurrent().isJEE()) {
            level = Level.WARNING;
        }
        if (mLogger.isLoggable(level)) {
            mLogger.logp(level, CLASSNAME, method, resBundle.getString("RESOURCE_NOT_FOUND"), (Object)resourceName);
            mLogger.logp(level, CLASSNAME, method, resBundle.getString("SECOND_FALLBACKIMPL_WARNING"), new Object[]{resourceName});
        }
        this.dumpConfigNotFoundMessage(cl);
    }

    private void dumpConfigNotFoundMessage(ClassLoader cl) {
        Logger logger = Logger.getLogger("oracle.adf.share.config.ConfigNotFound");
        if (!logger.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        String prefix = "";
        for (ClassLoader clw = cl; clw != null; clw = clw.getParent()) {
            prefix = "  " + prefix;
            buf.append("\n" + prefix + clw);
            if (!(clw instanceof URLClassLoader)) {
                buf.append(" (" + clw.getClass().getName() + ")");
                continue;
            }
            URL[] urls = ((URLClassLoader)clw).getURLs();
            if (urls == null) continue;
            String prefix2 = "    " + prefix;
            for (URL url : urls) {
                buf.append("\n" + prefix2 + url);
            }
        }
        logger.log(Level.CONFIG, "DIAGNOSTIC ONLY, NOT AN ERROR\nControl with logger: oracle.adf.share.config.ConfigNotFound\n\nClass Loader Heirarchy:" + buf.toString(), new Throwable("DIAGNOSTIC ONLY, NOT AN ERROR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    private static void internalClearMap() {
        Map<Object, ADFConfigEx> map = ADFConfigFactory.getInstance().applications;
        synchronized (map) {
            ADFConfigFactory.getInstance().applications.clear();
        }
    }

    static /* synthetic */ ADFConfigFactory access$100() {
        return ADFConfigFactory.initInstance();
    }

    public static interface ClassLoaderExclusionMarker {
    }

    private static class SystemCLHolder {
        @CodeSharingSafe(value="MutableStaticField")
        public static final Collection<WeakReference<ClassLoader>> loaders = SystemCLHolder.initSystemCLs();

        private SystemCLHolder() {
        }

        private static Collection<WeakReference<ClassLoader>> initSystemCLs() {
            Collection<WeakReference<ClassLoader>> tempCLs = null;
            tempCLs = System.getSecurityManager() == null ? SystemCLHolder.justInitSystemCLs() : AccessController.doPrivileged(new PrivilegedAction<Collection<WeakReference<ClassLoader>>>(){

                @Override
                public Collection<WeakReference<ClassLoader>> run() {
                    return SystemCLHolder.justInitSystemCLs();
                }
            });
            return tempCLs;
        }

        private static Collection<WeakReference<ClassLoader>> justInitSystemCLs() {
            ArrayList<WeakReference<ClassLoader>> tempCLs = new ArrayList<WeakReference<ClassLoader>>();
            for (ClassLoader sysCL = ClassLoader.getSystemClassLoader(); sysCL != null; sysCL = sysCL.getParent()) {
                tempCLs.add(new WeakReference<ClassLoader>(sysCL));
            }
            return new ArrayList<WeakReference<ClassLoader>>(tempCLs);
        }
    }

    private static class InstanceHolder {
        @CodeSharingSafe(value="MutableStaticField")
        public static final ADFConfigFactory INSTANCE = ADFConfigFactory.access$100();

        private InstanceHolder() {
        }
    }
}

