/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;

public abstract class Environment {
    private Boolean mIsFacesEnvironment = null;

    public abstract Object getRequest();

    public abstract Object getResponse();

    public abstract Object getContext();

    public abstract Locale getRequestLocale();

    public abstract String getRequestServletPath();

    public abstract String getRequestPathInfo();

    public abstract String encodeResourceURL(String var1);

    public abstract void redirect(String var1) throws IOException;

    public abstract void dispatch(String var1) throws IOException;

    public abstract String getRequestContextPath();

    public abstract String getRequestURI();

    Object getFacesContext() {
        if (this.mIsFacesEnvironment != null && !this.mIsFacesEnvironment.booleanValue()) {
            return null;
        }
        try {
            Class<?> facesContextClz = Class.forName("javax.faces.context.FacesContext", true, Environment.getThreadContextClassLoader());
            Method getCurrentInstance = facesContextClz.getMethod("getCurrentInstance", null);
            Object facesCtx = getCurrentInstance.invoke(null, null);
            if (this.mIsFacesEnvironment == null && facesCtx != null) {
                Method getApplication = facesContextClz.getMethod("getApplication", null);
                getApplication.invoke(facesCtx, null);
            }
            this.mIsFacesEnvironment = true;
            return facesCtx;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final void setFacesEnvironment(boolean isFacesEnvironment) {
        this.mIsFacesEnvironment = isFacesEnvironment;
    }

    public String getRequestQueryString() {
        return null;
    }

    public abstract String getRequestCharacterEncoding();

    public abstract void setRequestCharacterEncoding(String var1) throws IOException;

    public abstract Map getRequestParameterMap();

    public void clearCachedLocale() {
    }

    public Object getContextObject() {
        return null;
    }

    private static final ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

