/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import oracle.dss.util.format.dateFormat.DateConstants;
import oracle.dss.util.format.dateFormat.DateFormatToken;
import oracle.dss.util.format.dateFormat.LiteralToken;
import oracle.dss.util.format.dateFormat.ModifierToken;
import oracle.dss.util.format.dateFormat.TimeUnitToken;

class Scanner {
    private String formatString;
    private int formatStringLen = 0;
    private int startPos = 1;
    private int level = 0;
    private int endPos = 47;
    private char curChar;
    private int curPos = 0;
    private int theCase = 1;
    private boolean endFlag = false;
    private DateFormatToken lookToken;

    public Scanner(String formatString) {
        this.formatString = formatString;
        this.formatStringLen = formatString.length();
        if (!this.getNextChar()) {
            this.endFlag = true;
        }
    }

    public DateFormatToken getNextToken() {
        String twoChars = "";
        if (this.formatStringLen >= this.curPos + 1) {
            twoChars = this.formatString.substring(this.curPos - 1, this.curPos + 1);
        }
        if (this.endFlag) {
            this.lookToken = new TimeUnitToken(0);
        } else if (this.curChar == '\"') {
            int endquote = this.formatString.indexOf(34, this.curPos);
            if (endquote == -1) {
                this.lookToken = new LiteralToken(this.formatString.substring(this.curPos), 1000);
                this.endFlag = true;
            } else {
                this.lookToken = new LiteralToken(this.formatString.substring(this.curPos, endquote), 1000);
                this.curPos = endquote + 1;
                if (!this.getNextChar()) {
                    this.endFlag = true;
                }
            }
        } else if (!Character.isLetterOrDigit(this.curChar)) {
            int puncStart = this.curPos - 1;
            if (this.curChar == '|') {
                puncStart = this.curPos;
            }
            while (!Character.isLetterOrDigit(this.curChar) && this.curChar != '\"') {
                if (this.getNextChar()) continue;
                this.endFlag = true;
                break;
            }
            String lookValue = this.endFlag ? this.formatString.substring(puncStart, this.curPos) : this.formatString.substring(puncStart, this.curPos - 1);
            this.lookToken = new LiteralToken(lookValue, 2000);
        } else if (this.formatStringLen >= this.curPos + 1 && (twoChars.equalsIgnoreCase("FM") || twoChars.equalsIgnoreCase("FX") || twoChars.equalsIgnoreCase("SP") || twoChars.equalsIgnoreCase("TH"))) {
            int thisModifier = 0;
            boolean allowInput = false;
            int thisCase = 2;
            if (Character.isUpperCase(twoChars.charAt(0))) {
                thisCase = 1;
            }
            if (twoChars.equalsIgnoreCase("FM")) {
                thisModifier = 100;
                allowInput = true;
            } else if (twoChars.equalsIgnoreCase("FX")) {
                thisModifier = 200;
                allowInput = true;
            } else {
                thisModifier = twoChars.equalsIgnoreCase("SP") ? 300 : 400;
            }
            this.lookToken = new ModifierToken(thisModifier, allowInput, twoChars, thisCase);
            if (this.formatStringLen == this.curPos + 1) {
                this.endFlag = true;
            } else {
                this.getNextChar();
                this.getNextChar();
            }
        } else {
            int startFrom = this.curPos - 1;
            while (this.charSearch(this.curChar)) {
                if (this.getNextChar()) continue;
                this.endFlag = true;
                break;
            }
            int endTo = this.curPos - 1;
            if (this.endFlag) {
                endTo = this.curPos;
            }
            if (DateConstants.AllFormats[this.startPos].length() == this.level) {
                if (this.startPos == 5 || this.startPos == 1 || this.startPos == 2 || this.startPos == 28) {
                    this.theCase = Character.isUpperCase(this.formatString.charAt(startFrom)) ? 1 : 2;
                }
                this.lookToken = new TimeUnitToken(this.startPos, this.formatString.substring(startFrom, endTo), this.theCase, DateConstants.InputAllowed[this.startPos]);
            } else if (this.endPos == 43) {
                if (this.endFlag) {
                    this.curPos -= this.level - 1;
                    this.endFlag = false;
                } else {
                    this.curPos -= this.level;
                }
                this.getNextChar();
                String tmpStr = this.formatString.substring(startFrom, startFrom + 1);
                if (Character.isLowerCase(this.formatString.charAt(startFrom))) {
                    this.theCase = 2;
                }
                this.lookToken = new TimeUnitToken(42, tmpStr, this.theCase, DateConstants.InputAllowed[this.endPos - 1]);
            } else if (this.endPos == 36 && this.curPos - startFrom == 4) {
                this.curPos -= 2;
                this.getNextChar();
                String tmpStr = this.formatString.substring(startFrom, endTo - 1);
                this.lookToken = new TimeUnitToken(35, tmpStr, this.theCase, DateConstants.InputAllowed[this.endPos - 1]);
            } else {
                this.lookToken = new TimeUnitToken(48, this.formatString.substring(startFrom, endTo));
            }
            this.level = 0;
            this.startPos = 1;
            this.endPos = 47;
            this.theCase = 1;
        }
        return this.lookToken;
    }

    private boolean charSearch(char c) {
        boolean found = false;
        int thisEndPos = this.endPos;
        for (int i = this.startPos; i <= thisEndPos; ++i) {
            if (this.level >= DateConstants.AllFormats[i].length() || Character.toUpperCase(c) != DateConstants.AllFormats[i].charAt(this.level)) continue;
            if (this.level == 0 && Character.isLowerCase(c)) {
                this.theCase = 2;
            } else if (this.level == 1 && Character.isLowerCase(c) && this.theCase == 1) {
                this.theCase = 3;
            }
            if (!found) {
                found = true;
                this.startPos = i;
            }
            this.endPos = i;
        }
        if (found) {
            ++this.level;
        }
        return found;
    }

    private boolean getNextChar() {
        if (this.curPos < this.formatStringLen) {
            this.curChar = this.formatString.charAt(this.curPos++);
            return true;
        }
        return false;
    }
}

