/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.TreeNode;
import oracle.adfinternal.model.dvt.util.transform.CommonComparator;
import oracle.adfinternal.model.dvt.util.transform.ComparatorInterface;
import oracle.adfinternal.model.dvt.util.transform.DataAccessLong;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeNodeImpl;
import oracle.adfinternal.model.dvt.util.transform.GetSlice;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.adfinternal.model.dvt.util.transform.total.TotalMember;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;
import oracle.javatools.annotations.Concealed;

@Concealed
class EdgeTreeChildren
extends ArrayList<EdgeTreeNodeImpl>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private List<EdgeTreeNodeImpl> m_unreplacedNodes = new ArrayList<EdgeTreeNodeImpl>();
    private Hashtable<Object, EdgeTreeNodeImpl[]> m_lookupTable = new Hashtable();

    EdgeTreeChildren() {
    }

    public Object clone(EdgeTreeImpl tree, EdgeTreeNodeImpl parent, boolean caching) throws CloneNotSupportedException {
        EdgeTreeNodeImpl node;
        EdgeTreeChildren children = (EdgeTreeChildren)super.clone();
        children.m_unreplacedNodes = new ArrayList<EdgeTreeNodeImpl>();
        children.clear();
        Iterator<Object> nodes = super.iterator();
        EdgeTreeNodeImpl newNode = null;
        while (nodes.hasNext()) {
            node = (EdgeTreeNodeImpl)nodes.next();
            if (node != null) {
                newNode = (EdgeTreeNodeImpl)node.clone(tree, parent, caching);
                children.add(newNode);
                continue;
            }
            children.add(null);
        }
        children.m_lookupTable = null;
        children.m_unreplacedNodes.clear();
        nodes = this.m_unreplacedNodes.iterator();
        newNode = null;
        while (nodes.hasNext()) {
            node = (EdgeTreeNodeImpl)nodes.next();
            if (node != null) {
                newNode = (EdgeTreeNodeImpl)node.clone(tree, parent, caching);
                children.m_unreplacedNodes.add(newNode);
                continue;
            }
            children.m_unreplacedNodes.add(null);
        }
        return children;
    }

    @Override
    public boolean add(EdgeTreeNodeImpl node) {
        if (this.duplicate(super.size() - 1, node)) {
            return false;
        }
        boolean retVal = super.add(node);
        this.m_unreplacedNodes.add(node);
        try {
            if (node != null) {
                String value = node.getMember().getValue();
                this._updateLookupTable(value, node);
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return retVal;
    }

    private void _updateLookupTable(String value, EdgeTreeNodeImpl location) {
        if (this.m_lookupTable == null) {
            return;
        }
        EdgeTreeNodeImpl[] locs = this.m_lookupTable.get(this._getValue(value));
        EdgeTreeNodeImpl[] newLocs = null;
        if (locs == null) {
            locs = new EdgeTreeNodeImpl[]{location};
            newLocs = locs;
        } else {
            newLocs = new EdgeTreeNodeImpl[locs.length + 1];
            System.arraycopy(locs, 0, newLocs, 0, locs.length);
            newLocs[locs.length] = location;
        }
        this.m_lookupTable.put(this._getValue(value), newLocs);
    }

    private boolean duplicate(int pos, EdgeTreeNodeImpl node) {
        if (pos != -1 && pos < super.size()) {
            EdgeTreeNodeImpl existingNode = (EdgeTreeNodeImpl)super.get(pos);
            if (node != null && node.equals(existingNode)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int pos, EdgeTreeNodeImpl node) {
        if (this.duplicate(pos, node)) {
            return;
        }
        super.add(pos, node);
        this.m_unreplacedNodes.add(pos, node);
        if (node != null) {
            try {
                String value = node.getMember().getValue();
                this._updateLookupTable(value, node);
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
    }

    public void release() {
        for (EdgeTreeNodeImpl node : this) {
            node.release();
        }
        this.clear();
        this.m_unreplacedNodes.clear();
    }

    protected EdgeTreeNodeImpl getChild(long pos) {
        if (pos > -1L && pos < (long)this.size()) {
            return (EdgeTreeNodeImpl)this.get((int)pos);
        }
        return null;
    }

    private void clearPositions(EdgeTreeNodeImpl node1, EdgeTreeNodeImpl node2) throws TransformException {
        node1.clearSpan();
        node2.clearSpan();
        this.clearStart();
    }

    protected void swap(EdgeTreeNodeImpl node1, EdgeTreeNodeImpl node2) throws TransformException {
        int n1 = (int)node1.getPosition();
        int n2 = (int)node2.getPosition();
        this.set(n1, node2);
        this.set(n2, node1);
        this.clearPositions(node1, node2);
    }

    protected void moveAfter(EdgeTreeNodeImpl move, EdgeTreeNodeImpl moveTo) throws TransformException {
        this.m_lookupTable = null;
        this.remove(move);
        int to = (int)moveTo.getPosition();
        int size = this.size();
        if (to == size - 1) {
            super.add(move);
        } else {
            super.add(to + 1, move);
        }
        this.clearPositions(move, moveTo);
    }

    protected void moveBefore(EdgeTreeNodeImpl move, EdgeTreeNodeImpl moveTo) throws TransformException {
        this.m_lookupTable = null;
        this.remove(move);
        int to = (int)moveTo.getPosition();
        super.add(to, move);
        this.clearPositions(move, moveTo);
    }

    public EdgeTreeNodeImpl addChild(EdgeTreeNodeImpl childNode, TreeNode treeNode, String insertLocation, boolean above, boolean alwaysAdd, boolean replace, boolean placeTotals, LayerSortInfo sortInfo) throws TransformException {
        EdgeTreeNodeImpl alreadyThereNode = this.findChild(childNode);
        if (alreadyThereNode != null && !alwaysAdd) {
            return alreadyThereNode;
        }
        if (insertLocation != null) {
            EdgeTreeNodeImpl node = this.findChild(insertLocation);
            if (node != null) {
                long index = node.getPosition();
                if (above) {
                    this._addChild(childNode, treeNode, (int)index, replace);
                } else {
                    this._addChild(childNode, treeNode, (int)index + 1, replace);
                }
            }
        } else {
            this._simpleAddChild(childNode, treeNode, above, replace, placeTotals, sortInfo);
        }
        return childNode;
    }

    private void _simpleAddChild(EdgeTreeNodeImpl node, TreeNode treeNode, boolean above, boolean replace, boolean placeTotals, LayerSortInfo sortInfo) throws TransformException {
        if (placeTotals && node.isTotalNode()) {
            if (above) {
                this._addChild(node, treeNode, 0, replace);
            } else {
                this._addChild(node, treeNode, -1, replace);
            }
        } else {
            int locToInsert = this._getLocationToInsert(above, node, placeTotals, sortInfo);
            this._addChild(node, treeNode, locToInsert, replace);
        }
    }

    private void _addChild(EdgeTreeNodeImpl nodeToAdd, TreeNode node, int pos, boolean replace) throws TransformException {
        if (replace) {
            this.clear();
            pos = -1;
        }
        if (pos != -1) {
            this.add(pos, nodeToAdd);
        } else {
            this.add(nodeToAdd);
        }
        if (nodeToAdd.needAggregateSibling()) {
            boolean before;
            EdgeTreeNodeImpl aggSiblingNode = nodeToAdd.getEdgeTree().getEdgeTreeNode(true, nodeToAdd.getParentInternal(), nodeToAdd.getMember(), node, nodeToAdd.getLayerName());
            boolean bl = before = nodeToAdd.getAggregatePosition() == MemberInterface.AggregatePosition.BEFORE;
            if (pos != -1) {
                if (before) {
                    this.add(pos, aggSiblingNode);
                } else {
                    this.add(pos + 1, aggSiblingNode);
                }
            } else if (before) {
                this.add(this.size() - 1, aggSiblingNode);
            } else {
                this.add(aggSiblingNode);
            }
        }
    }

    private int _getLocationToInsert(boolean above, EdgeTreeNodeImpl nodeToInsert, boolean placeTotals, LayerSortInfo sortInfo) throws TransformException {
        int size;
        int pos = 0;
        if (above) {
            for (EdgeTreeNodeImpl node : this) {
                if (!placeTotals || !node.isTotalNode()) {
                    return this._sortedPosition(pos, -1, nodeToInsert, sortInfo);
                }
                ++pos;
            }
            return pos;
        }
        pos = size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!placeTotals || !((EdgeTreeNodeImpl)this.get(i)).isTotalNode()) {
                return this._sortedPosition(-1, pos, nodeToInsert, sortInfo);
            }
            --pos;
        }
        return 0;
    }

    private int _sortedPosition(int start, int end, EdgeTreeNodeImpl node, LayerSortInfo sortInfo) throws TransformException {
        int i;
        if (sortInfo == null || sortInfo.getLayer() == -1 || sortInfo.getDirection() == null || sortInfo.getDirection().length == 0) {
            if (start == -1) {
                return end;
            }
            return start;
        }
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        if (end == -1) {
            start = 0;
            for (i = size - 1; i >= 0; --i) {
                if (((EdgeTreeNodeImpl)this.get(i)).isTotalNode()) continue;
                end = i;
                break;
            }
        }
        if (start == -1) {
            for (i = 0; i < size; ++i) {
                if (((EdgeTreeNodeImpl)this.get(i)).isTotalNode()) continue;
                start = i;
                break;
            }
        }
        int sortDirection = sortInfo.getDirection()[0];
        Object value = node.getMember().getMetadata("sortAttribute");
        return this._insert(start, end, value, new CommonComparator(sortDirection, sortInfo.isNullsFirst()));
    }

    private int _insert(int start, int end, Object value, Comparator comp) throws TransformException {
        Object currListValue = null;
        if (end <= start) {
            return start;
        }
        int m = start + (end - start) / 2;
        EdgeTreeNodeImpl node = (EdgeTreeNodeImpl)super.get(m);
        currListValue = node.getMember().getMetadata("sortAttribute");
        int compare = comp.compare(value, currListValue);
        if (compare > 0) {
            return this._insert(m + 1, end, value, comp);
        }
        if (compare < 0) {
            return this._insert(start, m - 1, value, comp);
        }
        return m;
    }

    protected void addAggregateSibling(EdgeTreeNodeImpl node, TreeNode treeNode, int pos) throws TransformException {
        if (node.needAggregateSibling()) {
            boolean before;
            EdgeTreeNodeImpl aggSiblingNode = node.getEdgeTree().getEdgeTreeNode(true, node.getParentInternal(), node.getMember(), treeNode, node.getLayerName());
            node.setAllSibling(aggSiblingNode);
            boolean bl = before = node.getAggregatePosition() == MemberInterface.AggregatePosition.BEFORE;
            if (pos != -1) {
                if (before) {
                    this.add(pos, aggSiblingNode);
                } else {
                    this.add(pos + 1, aggSiblingNode);
                }
            } else if (before) {
                this.add(this.size() - 1, aggSiblingNode);
            } else {
                this.add(aggSiblingNode);
            }
        }
    }

    public EdgeTreeNodeImpl findFirstChild(boolean nonAggregate) throws TransformException {
        Iterator<EdgeTreeNodeImpl> children = this.m_unreplacedNodes.iterator();
        EdgeTreeNodeImpl currNode = null;
        while (children.hasNext()) {
            currNode = children.next();
            if (!nonAggregate) {
                return currNode;
            }
            if (nonAggregate && currNode.isTotalNode()) continue;
            return currNode;
        }
        return null;
    }

    public EdgeTreeNodeImpl findLastChild(boolean nonAggregate) throws TransformException {
        int size = this.m_unreplacedNodes.size();
        EdgeTreeNodeImpl currNode = null;
        for (int i = size - 1; i >= 0; --i) {
            currNode = this.m_unreplacedNodes.get(i);
            if (nonAggregate && currNode.isTotalNode()) continue;
            return currNode;
        }
        return null;
    }

    private Object _getValue(String value) {
        return value == null ? TransformUtils.m_nullMarker : value;
    }

    public EdgeTreeNodeImpl findChild(String value) throws TransformException {
        if (this.m_lookupTable == null) {
            Iterator children = this.iterator();
            EdgeTreeNodeImpl currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNodeImpl)children.next();
                if (!Utility.compareObj(value, currNode.getMember().getValue())) continue;
                return currNode;
            }
            return null;
        }
        EdgeTreeNodeImpl[] locs = this.m_lookupTable.get(this._getValue(value));
        if (locs != null) {
            for (int i = 0; i < locs.length; ++i) {
                if ((value != null || locs[i].getMember().getValue() != null) && (value == null || !value.equals(locs[i].getMember().getValue()))) continue;
                return locs[i];
            }
        }
        return null;
    }

    public EdgeTreeNodeImpl findChild(EdgeTreeNodeImpl value) throws TransformException {
        if (this.m_lookupTable == null || value.getMember() == null || value.getMember().getValue() == null) {
            Iterator children = this.iterator();
            EdgeTreeNodeImpl currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNodeImpl)children.next();
                if (!Utility.compareObj(value, currNode)) continue;
                return currNode;
            }
            return null;
        }
        EdgeTreeNodeImpl[] locs = this.m_lookupTable.get(this._getValue(value.getMember().getValue()));
        if (locs != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (!value.equals(locs[i])) continue;
                return locs[i];
            }
        }
        return null;
    }

    public EdgeTreeNodeImpl[] findAllChildren(String value, boolean nonAggregateOnly, boolean treatNullAsAll) throws TransformException {
        String compVal;
        String string = compVal = treatNullAsAll ? value : this._getValue(value);
        if (this.m_lookupTable != null && !this.m_lookupTable.isEmpty() && compVal != null) {
            EdgeTreeNodeImpl[] locs = this.m_lookupTable.get(compVal);
            if (locs != null) {
                if (nonAggregateOnly) {
                    ArrayList<EdgeTreeNodeImpl> nonAggNodes = new ArrayList<EdgeTreeNodeImpl>();
                    for (int i = 0; i < locs.length; ++i) {
                        if (locs[i].isAggregateNodeType()) continue;
                        nonAggNodes.add(locs[i]);
                    }
                    return nonAggNodes.toArray(new EdgeTreeNodeImpl[0]);
                }
                return locs;
            }
        } else {
            Iterator children = this.iterator();
            EdgeTreeNodeImpl currNode = null;
            ArrayList<EdgeTreeNodeImpl> nodes = new ArrayList<EdgeTreeNodeImpl>();
            while (children.hasNext()) {
                currNode = (EdgeTreeNodeImpl)children.next();
                if (compVal == null && treatNullAsAll) {
                    nodes.add(currNode);
                    continue;
                }
                if (!Utility.compareObj(compVal, currNode.getMember().getValue())) continue;
                if (nonAggregateOnly) {
                    if (currNode.isAggregateNodeType()) continue;
                    nodes.add(currNode);
                    continue;
                }
                nodes.add(currNode);
            }
            return nodes.toArray(new EdgeTreeNodeImpl[0]);
        }
        return new EdgeTreeNodeImpl[0];
    }

    public EdgeTreeNodeImpl findChild(String value, boolean nonAggregateOnly, boolean treatNullAsAll) throws TransformException {
        EdgeTreeNodeImpl[] nodes = this.findAllChildren(value, nonAggregateOnly, treatNullAsAll);
        if (nodes != null && nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }

    public EdgeTreeNodeImpl findChild(long slice, GetSlice get) throws TransformException {
        long m = 0L;
        long lower = 0L;
        long upper = this.size() - 1;
        FoundState foundState = FoundState.FOUND;
        while (upper >= 0L) {
            m = (lower + upper) / 2L;
            foundState = this._foundChild(m, slice, get);
            if (foundState == FoundState.FOUND) {
                EdgeTreeNodeImpl child = this.getChild(m);
                if (child != null && slice < child.getStart(GetSlice.GET_NO_SLICES, slice) + child.getSpan()) {
                    return child;
                }
                return null;
            }
            if (foundState == FoundState.HIGH) {
                lower = m + 1L;
                continue;
            }
            upper = m - 1L;
        }
        return null;
    }

    private FoundState _foundChild(long childLoc, long slice, GetSlice get) throws TransformException {
        EdgeTreeNodeImpl childNode = this.getChild(childLoc);
        long childStart = childNode.getStart(get, -1L);
        if (slice == childStart) {
            return FoundState.FOUND;
        }
        if (slice < childStart) {
            return FoundState.LOW;
        }
        EdgeTreeNodeImpl nextChild = this.getChild(childLoc + 1L);
        if (nextChild == null) {
            return FoundState.FOUND;
        }
        long nextChildStart = nextChild.getStart(get, -1L);
        return slice < nextChildStart ? FoundState.FOUND : FoundState.HIGH;
    }

    private boolean isTotal(EdgeTreeNodeImpl node) {
        if (node.isAggregateNodeType()) {
            return true;
        }
        MemberInterface mi = node.getMember();
        return mi != null ? mi instanceof TotalMember : false;
    }

    private Object getSortDataValue(DataAccessLong da, int edge, int layer, long slice, long otherSlice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        if (layer > -1) {
            return da.getMemberMetadata(edge, layer, otherSlice, "sortAttribute");
        }
        return edge == 0 ? da.getValue(slice, otherSlice, "dataValue") : da.getValue(otherSlice, slice, "dataValue");
    }

    public void sort(int sortDir, boolean nullsFirst, DataAccessLong da, int edge, int sortLayer, long slice) throws TransformException {
        EdgeNodeSortElement[] children = new EdgeNodeSortElement[super.size()];
        int childCount = 0;
        Iterator iter = super.iterator();
        EdgeTreeNodeImpl node = null;
        long otherSlice = -1L;
        boolean aggsFirst = false;
        ArrayList<EdgeTreeNodeImpl> removeList = new ArrayList<EdgeTreeNodeImpl>();
        try {
            while (iter.hasNext()) {
                node = (EdgeTreeNodeImpl)iter.next();
                if (!this.isTotal(node)) {
                    otherSlice = node.getStart(GetSlice.GET_ALL_SLICES, -1L);
                    Object dataVal = this.getSortDataValue(da, edge, sortLayer, slice, otherSlice);
                    children[childCount++] = new EdgeNodeSortElement(node, dataVal);
                    removeList.add(node);
                    continue;
                }
                aggsFirst = childCount == 0;
            }
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
        iter = removeList.iterator();
        EdgeTreeNodeImpl removeNode = null;
        while (iter.hasNext()) {
            removeNode = (EdgeTreeNodeImpl)iter.next();
            super.remove(removeNode);
            this.m_unreplacedNodes.remove(removeNode);
        }
        if (childCount != children.length) {
            EdgeNodeSortElement[] newChildren = new EdgeNodeSortElement[childCount];
            System.arraycopy(children, 0, newChildren, 0, newChildren.length);
            children = newChildren;
        }
        Arrays.sort(children, new CommonComparator(sortDir, nullsFirst));
        if (aggsFirst) {
            for (int i = 0; i < children.length; ++i) {
                super.add(children[i].m_node);
                this.m_unreplacedNodes.add(children[i].m_node);
            }
        } else {
            for (int i = children.length - 1; i >= 0; --i) {
                super.add(0, children[i].m_node);
                this.m_unreplacedNodes.add(0, children[i].m_node);
            }
        }
        if (this.m_lookupTable != null) {
            this.m_lookupTable.clear();
        }
    }

    public EdgeTreeNodeImpl getLastChild() {
        return this.getChild(this.size() - 1);
    }

    public void deleteChild(EdgeTreeNodeImpl node) throws TransformException {
        String value;
        EdgeTreeNodeImpl[] locs;
        super.remove(node);
        this.m_unreplacedNodes.remove(node);
        if (this.m_lookupTable != null && node != null && node.getMember() != null && (locs = this.m_lookupTable.get(this._getValue(value = node.getMember().getValue()))) != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (!node.equals(locs[i])) continue;
                locs[i] = null;
                EdgeTreeNodeImpl[] newLocs = new EdgeTreeNodeImpl[locs.length - 1];
                int newLocLocation = 0;
                for (int j = 0; j < locs.length; ++j) {
                    if (locs[j] == null) continue;
                    newLocs[newLocLocation++] = locs[j];
                }
                this.m_lookupTable.remove(this._getValue(value));
                this.m_lookupTable.put(this._getValue(value), newLocs);
                return;
            }
        }
    }

    public void invalidate() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNodeImpl currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNodeImpl)children.next();
            currNode.invalidate();
        }
    }

    public void clearStart() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNodeImpl currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNodeImpl)children.next();
            currNode.clearStart();
        }
    }

    public void unlock() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNodeImpl currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNodeImpl)children.next();
            currNode.unlock();
        }
    }

    protected class EdgeNodeSortElement
    implements ComparatorInterface {
        protected EdgeTreeNodeImpl m_node = null;
        protected Object m_data = null;

        public EdgeNodeSortElement(EdgeTreeNodeImpl node, Object data) {
            this.m_node = node;
            this.m_data = data;
        }

        @Override
        public Object getValue() {
            return this.m_data;
        }
    }

    private static enum FoundState {
        FOUND,
        LOW,
        HIGH;

    }
}

