/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.net.URL;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.FSMWizard;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnection;
import oracle.jdevimpl.vcs.git.GITConnectionManager;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.progress.ProgressMonitor;

abstract class GITWizard {
    private VCSExceptionHandler _exceptionHandler;

    protected WizardDialog createWizardDialog(FSMWizard wizard, Component parent, Context context) {
        WizardDialog wd;
        Dialog dlg = DialogUtil.getAncestorDialog((Component)parent);
        if (dlg != null) {
            wd = wizard.getDialog(dlg);
        } else {
            Frame f = DialogUtil.getAncestorFrame((Component)parent);
            wd = wizard.getDialog(f);
        }
        wizard.addCommitListener(this.getCommitListener(wd, context));
        return wd;
    }

    protected boolean commitWizard(Context context) {
        return true;
    }

    protected CommitListener getCommitListener(WizardDialog wd, Context context) {
        return new GITWizardCommitListener(wd, context);
    }

    protected VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    protected Map<String, GitRemoteConfig> getRemoteConfigs(URL url) throws Exception {
        GitClient client = null;
        Map remotes = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("remotes");
        try {
            if (url != null) {
                client = GITClientAdaptor.getClient(url);
                remotes = client.getRemotes((ProgressMonitor)monitor);
            }
            Map map = remotes;
            return map;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITWizard.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get("WZ_FETCH_ERROR_REMOTE"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    protected URL getURLFromGitWorkTree(Context context) {
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)context, (URLFilter)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT"));
        URL url = null;
        if (locatables.length > 0) {
            url = locatables[0].getURL();
        } else {
            Node node = context.getNode();
            if (node != null && node.getURL() != null && GITNavURLFileSystemHelper.isNavigatorURL(node.getURL())) {
                url = GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL());
            }
        }
        return url;
    }

    protected void connection(String remoteUrl, String remote, String username, char[] pass, char[] passPhrase) {
        GITConnection connection = GITConnectionManager.getInstance().getConnection(remoteUrl);
        if (connection == null) {
            connection = new GITConnection(remoteUrl);
            if (remote == null || remote.isEmpty()) {
                connection.setRemote(this.getRemoteDefault());
            }
        }
        if (connection != null) {
            connection.setUsername(username);
            if (remote != null) {
                connection.setRemote(remote);
            }
            connection.setPassword(pass);
            connection.setPassphrase(passPhrase);
            GITConnectionManager.getInstance().putConnection(connection);
        }
    }

    private String getRemoteDefault() {
        return Resource.get("WZ_CLONE_REMOTE_DEFAULT");
    }

    private class GITWizardCommitListener
    implements CommitListener {
        private WizardDialog dialog;
        private Context _context;

        public GITWizardCommitListener(WizardDialog wd, Context context) {
            this.dialog = wd;
            this._context = context;
        }

        public void checkCommit(ApplyEvent applyevent) throws TraversalException {
        }

        public void commit(ApplyEvent event) throws TraversalException {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!GITWizard.this.commitWizard(GITWizardCommitListener.this._context)) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GITWizardCommitListener.this.dialog.dispose();
                        }
                    });
                }
            }, "GIT Wizard Thread").start();
        }

        public void rollback(ApplyEvent applyevent) {
        }

        public void cancel(ApplyEvent applyevent) {
        }
    }
}

