/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.nav.GITBranchLocalNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITStashNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITStashListNode
extends DefaultContainer
implements GITRemote {
    private GITConnectionInfo _info;

    GITStashListNode(GITConnectionInfo info) {
        this._info = info;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(this._info.getRootURL()));
    }

    public String getShortLabel() {
        return Resource.get("NAV_NODE_STASH");
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"bullist.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        GitClient client = null;
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            try {
                this._children.clear();
                URL root = GITNavURLFileSystemHelper.fromNavigatorURL(this.getURL());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Stashed Commits");
                client = GITClientAdaptor.getClient(root);
                GitRevisionInfo[] infos = client.stashList((ProgressMonitor)monitor);
                if (monitor.getError() != null) {
                    GITProfile.getQualifiedLogger(GITStashListNode.class.getName()).log(Level.WARNING, monitor.getError());
                }
                if (monitor.hasFinished()) {
                    for (int st = 0; st < infos.length; ++st) {
                        this._children.add(new GITStashNode(this._info.getRootURL(), infos[st], st));
                    }
                }
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITBranchLocalNode.class.getName()).log(Level.WARNING, e.getMessage());
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._info.getRootURL());
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITStashListNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

