/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.ideimpl.ceditor.saveactions.SaveActionsHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class SaveActionsOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "SaveActionsOptions";
    private static final String SAVE_ACTION_LIST = "saveActionList";
    private static final String DISABLED_SAVE_ACTION_LIST = "disabledSaveActionList";
    private static final String MIGRATED_SAVE_ACTIONS = "migratedSaveActions";

    static void migrate() {
        Preferences prefs = Preferences.getPreferences();
        SaveActionsOptions saOptions = SaveActionsOptions.getInstance((PropertyStorage)prefs);
        if (!saOptions.getMigratedSaveActions()) {
            saOptions.setMigratedSaveActions(true);
            if (!Ide.getEnvironOptions().getBuildAfterSave()) {
                saOptions.setExecutableSaveAction("BUILD_PROJECT_AFTER_SAVE", false);
            }
            if (Ide.getEnvironOptions().getBuildDependentsAfterSave()) {
                saOptions.setExecutableSaveAction("BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE", true);
            }
        }
    }

    private SaveActionsOptions(HashStructure hash) {
        super(hash);
    }

    public static SaveActionsOptions getInstance(PropertyStorage prefs) {
        return new SaveActionsOptions(SaveActionsOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean isPotentialSaveAction(String actionId) {
        Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        return hookActions.containsKey(actionId);
    }

    public List<SaveActionDescription> getExecutableSaveActions() {
        ListStructure enabledActionIds = this.getEnabledActionList(false);
        ListStructure disabledActionIds = this.getDisabledActionList(false);
        ArrayList<SaveActionDescription> saveActionDescs = new ArrayList<SaveActionDescription>();
        Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        if (enabledActionIds != null) {
            for (Map.Entry<String, SaveActionDescription> actionId : enabledActionIds) {
                SaveActionDescription actionDescription = hookActions.get(actionId.toString());
                if (actionDescription == null) continue;
                saveActionDescs.add(actionDescription);
            }
        }
        for (Map.Entry<String, SaveActionDescription> entry : hookActions.entrySet()) {
            if (!entry.getValue().getExecuteByDefault() || saveActionDescs.contains(entry.getValue()) || disabledActionIds != null && disabledActionIds.contains((Object)entry.getKey())) continue;
            saveActionDescs.add(entry.getValue());
            if (enabledActionIds == null) continue;
            enabledActionIds.add((Object)entry.getKey());
        }
        return saveActionDescs;
    }

    public void setExecutableSaveActions(Collection<SaveActionDescription> newSaveActionDescs) {
        Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        ListStructure newEnabledActionIds = ListStructure.newInstance();
        ListStructure newDisabledActionIds = ListStructure.newInstance();
        for (SaveActionDescription hookAction : newSaveActionDescs) {
            newEnabledActionIds.add((Object)hookAction.getId());
        }
        for (String id : hookActions.keySet()) {
            if (newEnabledActionIds.contains((Object)id)) continue;
            newDisabledActionIds.add((Object)id);
        }
        this.setEnabledActionList(newEnabledActionIds);
        this.setDisabledActionList(newDisabledActionIds);
    }

    public boolean setExecutableSaveAction(String actionId, boolean enable) {
        boolean result = true;
        Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        result = hookActions.keySet().contains(actionId);
        ListStructure enabledActionIds = this.getEnabledActionList(true);
        ListStructure disabledActionIds = this.getDisabledActionList(true);
        if (enable) {
            if (!enabledActionIds.contains((Object)actionId)) {
                enabledActionIds.add((Object)actionId);
            }
            disabledActionIds.remove((Object)actionId);
        } else {
            enabledActionIds.remove((Object)actionId);
            if (!disabledActionIds.contains((Object)actionId)) {
                disabledActionIds.add((Object)actionId);
            }
        }
        return result;
    }

    public boolean isExecutableSaveAction(String actionId) {
        Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        SaveActionDescription hookAction = hookActions.get(actionId);
        if (hookAction == null) {
            return false;
        }
        ListStructure enabledActions = this.getEnabledActionList(false);
        if (enabledActions != null) {
            return enabledActions.contains((Object)actionId);
        }
        ListStructure disabledActions = this.getDisabledActionList(false);
        if (disabledActions != null && disabledActions.contains((Object)actionId)) {
            return false;
        }
        return hookAction.getExecuteByDefault();
    }

    static List<SaveActionDescription> getMissingActions(List<SaveActionDescription> currentActions, boolean beforeSave) {
        ArrayList<SaveActionDescription> missingActions = new ArrayList<SaveActionDescription>();
        Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
        for (Map.Entry<String, SaveActionDescription> entry : hookActions.entrySet()) {
            SaveActionDescription action = entry.getValue();
            if (action.getExecuteBeforeSave() != beforeSave || currentActions.contains(action)) continue;
            missingActions.add(action);
        }
        return missingActions;
    }

    private ListStructure getEnabledActionList(boolean create) {
        ListStructure list = this._hash.getListStructure(SAVE_ACTION_LIST);
        if (list == null && create) {
            list = ListStructure.newInstance();
            this._hash.putListStructure(SAVE_ACTION_LIST, list);
            Map<String, SaveActionDescription> hookActions = SaveActionsHook.getSaveActions();
            for (Map.Entry<String, SaveActionDescription> entry : hookActions.entrySet()) {
                if (!entry.getValue().getExecuteByDefault()) continue;
                list.add((Object)entry.getKey());
            }
        }
        return list;
    }

    private ListStructure getDisabledActionList(boolean create) {
        ListStructure list = this._hash.getListStructure(DISABLED_SAVE_ACTION_LIST);
        if (list == null && create) {
            list = ListStructure.newInstance();
            this._hash.putListStructure(DISABLED_SAVE_ACTION_LIST, list);
        }
        return list;
    }

    private void setEnabledActionList(ListStructure actionNameList) {
        this._hash.putListStructure(SAVE_ACTION_LIST, actionNameList);
    }

    private void setDisabledActionList(ListStructure actionNameList) {
        this._hash.putListStructure(DISABLED_SAVE_ACTION_LIST, actionNameList);
    }

    private boolean getMigratedSaveActions() {
        return this._hash.getBoolean(MIGRATED_SAVE_ACTIONS, false);
    }

    private void setMigratedSaveActions(boolean value) {
        this._hash.putBoolean(MIGRATED_SAVE_ACTIONS, value);
    }
}

