/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.filtering.Filtering;
import oracle.dbtools.rt.json.query.HyperLinks;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.query.ResultRowRepresentation;
import oracle.dbtools.rt.web.AcceptFormatting;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

public class JSONRepresentation
implements ResultRowRepresentation {
    private final boolean firstRowOnly;
    private final ContentType contentType;

    public JSONRepresentation(boolean firstRowOnly) {
        this(firstRowOnly, ContentTypes.JSON);
    }

    public JSONRepresentation(boolean firstRowOnly, ContentType contentType) {
        this.firstRowOnly = firstRowOnly;
        this.contentType = contentType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Entity toRepresentation(RequestEntity request, long pageOffset, Iterator<ResultRow> rows) throws IOException {
        AcceptFormatting contentFormatting = AcceptFormatting.contentFormatting(request);
        JSONOptions options = JSONOptions.configure(contentFormatting.parameters());
        ResultRow root = null;
        if (this.firstRowOnly) {
            if (!rows.hasNext()) throw WebException.notFound();
            root = rows.next();
        } else {
            ResultRow hyperlinks = null;
            if (!this.firstRowOnly && pageOffset != -1L) {
                hyperlinks = Pagination.hyperlinks(request.path(), pageOffset, rows);
                if (hyperlinks != null) {
                    hyperlinks = Filtering.hyperlinks(request, hyperlinks);
                }
                if (hyperlinks != null) {
                    hyperlinks = HyperLinks.hyperlink(request.base(), hyperlinks);
                }
            }
            ResultRows.RowBuilder b = new ResultRows.RowBuilder();
            if (hyperlinks != null) {
                b.add(hyperlinks);
            }
            b.add("items", rows);
            root = b.build();
        }
        ResultRow hyperlinked = HyperLinks.hyperlink(Requests.documentBase(request), root);
        return Entities.alsoClose(Entities.entity((InputStream)((Object)new JSONQueryStream(hyperlinked, options)), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, this.contentType})), rows);
    }
}

