/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRowIterator;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.IteratorState;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONRenderer;
import oracle.dbtools.rt.json.JSONStringRenderer;

public class JSONQueryStream
extends ChunkedInputStream {
    public static final String ANTI_HIJACKING = "items";

    public JSONQueryStream(Iterator<ResultRow> rows, JSONOptions options) {
        this(JSONQueryStream.root(rows), options);
    }

    public JSONQueryStream(ResultRow root) {
        this(root, JSONOptions.DEFAULT_JSON_OPTIONS);
    }

    public JSONQueryStream(ResultRow root, JSONOptions options) {
        super((ChunkedInputStream.Chunker)new JSONChunker(options, root, JSONQueryStream.renderer()));
    }

    static ResultRow root(Iterator<ResultRow> rows) {
        ResultRows.RowBuilder b = new ResultRows.RowBuilder();
        b.add(ANTI_HIJACKING, rows);
        return b.build();
    }

    static JSONBuilder toJson(JSONOptions options, ResultRow result) {
        JSONBuilder b = JSONBuilder.o((JSONOptions)options);
        b.options(options);
        for (int i = 1; i <= result.size(); ++i) {
            String n = result.name(i);
            Object v = result.get(i);
            if (v instanceof Timestamp) {
                v = Timestamps.toString((long)((Timestamp)v).getTime());
            } else if (v instanceof ResultRow) {
                v = JSONQueryStream.toJson(options, (ResultRow)v);
            }
            b.p(n, v);
        }
        return b;
    }

    private static boolean isArray(Object o) {
        boolean isArray = o != null && o.getClass().isArray() && !o.getClass().getComponentType().isPrimitive();
        return isArray;
    }

    private static ScalarIterator iterator(Object[] v) {
        return new ScalarArray(v);
    }

    private static JSONStringRenderer renderer() {
        JSONStringRenderer w = new JSONStringRenderer(2048);
        return w;
    }

    private static interface ScalarIterator
    extends Iterator<Object>,
    IteratorState {
    }

    private static class ScalarArray
    extends AbstractIterator<Object>
    implements ScalarIterator {
        private final Object[] array;
        private int pos = 0;

        public ScalarArray(Object[] array) {
            super(false, true);
            this.array = array;
        }

        public String toString() {
            return "ScalarArray [pos=" + this.pos + ", array=" + Arrays.toString(this.array) + "]";
        }

        protected Object advance() {
            if (this.pos < this.array.length) {
                Object value = this.array[this.pos];
                ++this.pos;
                return value;
            }
            return this.eos();
        }
    }

    private static class JSONChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final JSONOptions options;
        private final Deque<CursorState> state = new ArrayDeque<CursorState>();
        private final JSONStringRenderer w;

        JSONChunker(JSONOptions options, ResultRow root, JSONStringRenderer w) {
            this.options = options;
            this.state.push(new CursorState(root.columns()));
            this.w = w;
        }

        public void close() throws IOException {
            Closeables.close((Object)this.w);
        }

        public String toString() {
            return "JSONChunker [w=" + this.w + ", state=" + this.state + "]";
        }

        protected byte[] advance() {
            byte[] chunk = null;
            if (!this.finished()) {
                boolean yield = false;
                CursorState state = this.state.peek();
                switch (state.dataType) {
                    case OBJECT: {
                        yield = this.render((ColumnIterator)state.iter, (JSONRenderer)this.w);
                        break;
                    }
                    case ARRAY_OF_OBJECT: {
                        yield = this.render((ResultRowIterator)state.iter, (JSONRenderer)this.w);
                        break;
                    }
                    case ARRAY_OF_SCALAR: {
                        yield = this.render((ScalarIterator)state.iter, (JSONRenderer)this.w);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                if (!yield) {
                    this.state.pop();
                }
                if (this.finished()) {
                    this.w.flush(true);
                }
                chunk = Text.getBytes((String)this.w.toString());
                this.w.reset();
            }
            return chunk;
        }

        private boolean finished() {
            return this.state.isEmpty();
        }

        private void push(DataType dataType, Object v) {
            switch (dataType) {
                case OBJECT: {
                    this.state.push(new CursorState(((ResultRow)v).columns()));
                    break;
                }
                case ARRAY_OF_OBJECT: {
                    ResultRowIterator objects = null;
                    objects = v instanceof ResultRowIterator ? (ResultRowIterator)v : ResultRows.adapt((Object)v);
                    this.state.push(new CursorState(objects));
                    break;
                }
                case ARRAY_OF_SCALAR: {
                    ScalarIterator array = JSONQueryStream.iterator((Object[])v);
                    this.state.push(new CursorState(array));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        private boolean render(ColumnIterator row, JSONRenderer w) {
            if (row.beforeNext()) {
                w.start();
            }
            while (row.hasNext()) {
                Object v = row.next();
                String n = row.columnName();
                boolean emit = null != v || this.options.includeNulls();
                if (!emit) continue;
                w.name(new QName(n));
                if (!this.renderValue(v, w)) continue;
                return true;
            }
            w.end();
            return false;
        }

        private boolean render(ResultRowIterator rows, JSONRenderer w) {
            if (rows.beforeNext()) {
                w.startArray();
            }
            if (rows.hasNext()) {
                ResultRow row = (ResultRow)rows.next();
                this.push(DataType.OBJECT, row);
                return true;
            }
            w.endArray();
            return false;
        }

        private boolean render(ScalarIterator rows, JSONRenderer w) {
            if (rows.beforeNext()) {
                w.startArray();
            }
            while (rows.hasNext()) {
                Object v = rows.next();
                if (this.renderValue(v, w)) {
                    return true;
                }
                this.yieldForChunk();
            }
            w.endArray();
            return false;
        }

        private void renderScalar(Object v, DataType dataType, JSONRenderer w) {
            switch (dataType) {
                case NULL: {
                    w.value((Reader)null);
                    break;
                }
                case TEXT: {
                    w.value((CharSequence)v);
                    break;
                }
                case NUMBER: {
                    w.value((Number)v);
                    break;
                }
                case BOOLEAN: {
                    w.value((Boolean)v);
                    break;
                }
                case READER: {
                    w.value((Reader)v);
                    break;
                }
                case TIMESTAMP: {
                    String text = Timestamps.toString((long)((Timestamp)v).getTime());
                    w.value((CharSequence)text);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        private boolean renderValue(Object v, JSONRenderer w) {
            DataType dataType = DataType.dataType(v);
            if (dataType.scalar()) {
                this.renderScalar(v, dataType, w);
                return false;
            }
            this.push(dataType, v);
            return true;
        }

        private boolean yieldForChunk() {
            return this.w.size() > JSONQueryStream.chunkSizeChars();
        }
    }

    private static enum DataType {
        ARRAY_OF_OBJECT(false),
        ARRAY_OF_SCALAR(false),
        BOOLEAN,
        NULL,
        NUMBER,
        OBJECT(false),
        READER,
        TEXT,
        TIMESTAMP,
        UNKNOWN;

        private boolean scalar;

        private DataType() {
            this(true);
        }

        private DataType(boolean scalar) {
            this.scalar = scalar;
        }

        boolean scalar() {
            return this.scalar;
        }

        public static DataType dataType(Object value) {
            if (value == null) {
                return NULL;
            }
            if (value instanceof CharSequence) {
                return TEXT;
            }
            if (value instanceof Number) {
                return NUMBER;
            }
            if (value instanceof Reader) {
                return READER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Timestamp) {
                return TIMESTAMP;
            }
            if (value instanceof ResultRow) {
                return OBJECT;
            }
            if (JSONQueryStream.isArray(value)) {
                return ARRAY_OF_SCALAR;
            }
            if (value instanceof ResultRowIterator) {
                return ARRAY_OF_OBJECT;
            }
            if (value instanceof Iterator) {
                return ARRAY_OF_OBJECT;
            }
            throw new IllegalStateException();
        }
    }

    private static class CursorState {
        final DataType dataType;
        final Iterator<?> iter;

        public CursorState(ScalarIterator array) {
            this(DataType.ARRAY_OF_SCALAR, array);
        }

        CursorState(ColumnIterator row) {
            this(DataType.OBJECT, (Iterator<?>)row);
        }

        CursorState(ResultRowIterator rows) {
            this(DataType.ARRAY_OF_OBJECT, (Iterator<?>)rows);
        }

        private CursorState(DataType dataType, Iterator<?> iter) {
            this.dataType = dataType;
            this.iter = iter;
        }

        public String toString() {
            return "CursorState [dataType=" + (Object)((Object)this.dataType) + ", iter=" + this.iter + "]";
        }
    }
}

