/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.config.ConfigurationBase;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MaybeEmpty;
import oracle.dbtools.plugin.api.conf.Configuration;

class ConfigurationBuilder
implements MaybeEmpty {
    private final Map<String, String> values = new LinkedHashMap<String, String>();
    private final ConfigurationBuilder defaults;
    private final State state;

    static ConfigurationBuilder defaults(Configurations existing) {
        ConfigurationBuilder builder = new ConfigurationBuilder(State.DEFAULTS, null);
        String confName = "defaults";
        ConfigurationBuilder.existingConf(existing, builder, confName);
        return builder;
    }

    private static void existingConf(Configurations existing, ConfigurationBuilder builder, String confName) {
        Configuration existingConf = existing.get(confName);
        if (existingConf != null) {
            for (String name : existingConf.propertyNames()) {
                builder.add(name, existingConf.get(name));
            }
        }
    }

    static ConfigurationBuilder builder(ConfigurationBuilder defaults, Configurations existing, String name) {
        boolean noExistingConfs = Iterables.size((Iterable)existing) <= 1;
        State state = State.NORMAL;
        if (noExistingConfs && !name.endsWith("_al") && !name.endsWith("_rt") && !name.endsWith("_pu")) {
            state = State.PUSH_TO_DEFAULTS;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(state, defaults);
        ConfigurationBuilder.existingConf(existing, builder, name);
        return builder;
    }

    private ConfigurationBuilder(State state, ConfigurationBuilder defaults) {
        this.state = state;
        this.defaults = defaults;
    }

    ConfigurationBuilder add(String name, String value) {
        switch (this.state) {
            case DEFAULTS: {
                this.values.put(name, value);
                break;
            }
            case PUSH_TO_DEFAULTS: {
                if ("db.username".equals(name) || "db.password".equals(name)) {
                    this.values.put(name, value);
                    break;
                }
                this.defaults.add(name, value);
                break;
            }
            case NORMAL: {
                String defaultValue = this.defaults.get(name);
                if (value.equals(defaultValue)) break;
                this.values.put(name, value);
            }
        }
        return this;
    }

    private String get(String name) {
        return this.values.get(name);
    }

    Configuration build() {
        return new ConfigurationBase(){

            protected AssociativeArray<String, String> values() {
                return AssociativeArrays.fromMap((Map)ConfigurationBuilder.this.values);
            }

            public Iterable<String> propertyNames() {
                return ConfigurationBuilder.this.values.keySet();
            }
        };
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    static enum State {
        DEFAULTS,
        PUSH_TO_DEFAULTS,
        NORMAL;

    }
}

